/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.ldap;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.ldap.LdapManager;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserCollection;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.user.UserProvider;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class LdapUserProvider
implements UserProvider {
    private static final Logger Log = LoggerFactory.getLogger(LdapUserProvider.class);
    private static SimpleDateFormat ldapDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private LdapManager manager;
    private Map<String, String> searchFields;
    private int userCount = -1;
    private long expiresStamp = System.currentTimeMillis();

    public LdapUserProvider() {
        JiveGlobals.migrateProperty("ldap.searchFields");
        this.manager = LdapManager.getInstance();
        this.searchFields = new LinkedHashMap<String, String>();
        String fieldList = JiveGlobals.getProperty("ldap.searchFields");
        if (fieldList == null) {
            this.searchFields.put("Username", this.manager.getUsernameField());
            this.searchFields.put("Name", this.manager.getNameField());
            this.searchFields.put("Email", this.manager.getEmailField());
        } else {
            try {
                StringTokenizer i = new StringTokenizer(fieldList, ",");
                while (i.hasMoreTokens()) {
                    String[] field = i.nextToken().split("/");
                    this.searchFields.put(field[0], field[1]);
                }
            }
            catch (Exception e) {
                Log.error("Error parsing LDAP search fields: " + fieldList, (Throwable)e);
            }
        }
    }

    @Override
    public User loadUser(String username) throws UserNotFoundException {
        if (username.contains("@")) {
            if (!XMPPServer.getInstance().isLocal(new JID(username))) {
                throw new UserNotFoundException("Cannot load user of remote server: " + username);
            }
            username = username.substring(0, username.lastIndexOf("@"));
        }
        username = JID.unescapeNode((String)username);
        Context ctx = null;
        try {
            String userDN = this.manager.findUserDN(username);
            String[] attributes = new String[]{this.manager.getUsernameField(), this.manager.getNameField(), this.manager.getEmailField(), "createTimestamp", "modifyTimestamp"};
            ctx = this.manager.getContext(this.manager.getUsersBaseDN(username));
            Attributes attrs = ctx.getAttributes(userDN, attributes);
            String name = null;
            Attribute nameField = attrs.get(this.manager.getNameField());
            if (nameField != null) {
                name = (String)nameField.get();
            }
            String email = null;
            Attribute emailField = attrs.get(this.manager.getEmailField());
            if (emailField != null) {
                email = (String)emailField.get();
            }
            Date creationDate = new Date();
            Attribute creationDateField = attrs.get("createTimestamp");
            if (creationDateField != null && "".equals(((String)creationDateField.get()).trim())) {
                creationDate = LdapUserProvider.parseLDAPDate((String)creationDateField.get());
            }
            Date modificationDate = new Date();
            Attribute modificationDateField = attrs.get("modifyTimestamp");
            if (modificationDateField != null && "".equals(((String)modificationDateField.get()).trim())) {
                modificationDate = LdapUserProvider.parseLDAPDate((String)modificationDateField.get());
            }
            username = JID.escapeNode((String)username);
            Attribute authPassword = attrs.get("authPassword");
            User user = new User(username, name, email, creationDate, modificationDate);
            if (authPassword != null) {
                NamingEnumeration<?> values = authPassword.getAll();
                while (values.hasMore()) {
                    Attribute authPasswordValue = (Attribute)values.next();
                    String[] parts = ((String)authPasswordValue.get()).split("$");
                    String[] authInfo = parts[1].split(":");
                    String[] authValue = parts[2].split(":");
                    String scheme = parts[0].trim();
                    if (!"SCRAM-SHA-1".equals(scheme)) continue;
                    int iterations = Integer.valueOf(authInfo[0].trim());
                    String salt = authInfo[1].trim();
                    String storedKey = authValue[0].trim();
                    String serverKey = authValue[1].trim();
                    user.setSalt(salt);
                    user.setStoredKey(storedKey);
                    user.setServerKey(serverKey);
                    user.setIterations(iterations);
                    break;
                }
            }
            User user2 = user;
            return user2;
        }
        catch (Exception e) {
            throw new UserNotFoundException(e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public User createUser(String username, String password, String name, String email) throws UserAlreadyExistsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteUser(String username) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getUserCount() {
        if (this.userCount != -1 && System.currentTimeMillis() < this.expiresStamp) {
            return this.userCount;
        }
        this.userCount = this.manager.retrieveListCount(this.manager.getUsernameField(), MessageFormat.format(this.manager.getSearchFilter(), "*"));
        this.expiresStamp = System.currentTimeMillis() + 300000L;
        return this.userCount;
    }

    @Override
    public Collection<String> getUsernames() {
        return this.manager.retrieveList(this.manager.getUsernameField(), MessageFormat.format(this.manager.getSearchFilter(), "*"), -1, -1, null, true);
    }

    @Override
    public Collection<User> getUsers() {
        return this.getUsers(-1, -1);
    }

    @Override
    public Collection<User> getUsers(int startIndex, int numResults) {
        List<String> userlist = this.manager.retrieveList(this.manager.getUsernameField(), MessageFormat.format(this.manager.getSearchFilter(), "*"), startIndex, numResults, this.manager.getUsernameSuffix(), true);
        return new UserCollection(userlist.toArray(new String[userlist.size()]));
    }

    @Override
    public void setName(String username, String name) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEmail(String username, String email) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCreationDate(String username, Date creationDate) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setModificationDate(String username, Date modificationDate) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getSearchFields() throws UnsupportedOperationException {
        return Collections.unmodifiableSet(this.searchFields.keySet());
    }

    public void setSearchFields(String fieldList) {
        this.searchFields = new LinkedHashMap<String, String>();
        if (fieldList == null) {
            this.searchFields.put("Username", this.manager.getUsernameField());
            this.searchFields.put("Name", this.manager.getNameField());
            this.searchFields.put("Email", this.manager.getEmailField());
        } else {
            try {
                StringTokenizer i = new StringTokenizer(fieldList, ",");
                while (i.hasMoreTokens()) {
                    String[] field = i.nextToken().split("/");
                    this.searchFields.put(field[0], field[1]);
                }
            }
            catch (Exception e) {
                Log.error("Error parsing LDAP search fields: " + fieldList, (Throwable)e);
            }
        }
        JiveGlobals.setProperty("ldap.searchFields", fieldList);
    }

    @Override
    public Collection<User> findUsers(Set<String> fields, String query) throws UnsupportedOperationException {
        return this.findUsers(fields, query, -1, -1);
    }

    @Override
    public Collection<User> findUsers(Set<String> fields, String query, int startIndex, int numResults) throws UnsupportedOperationException {
        if (fields.isEmpty() || query == null || "".equals(query)) {
            return Collections.emptyList();
        }
        if (!(query = LdapManager.sanitizeSearchFilter(query, true)).endsWith("*")) {
            query = query + "*";
        }
        if (!this.searchFields.keySet().containsAll(fields)) {
            throw new IllegalArgumentException("Search fields " + fields + " are not valid.");
        }
        StringBuilder filter = new StringBuilder();
        filter.append("(&(");
        filter.append(MessageFormat.format(this.manager.getSearchFilter(), "*"));
        filter.append(')');
        if (fields.size() > 1) {
            filter.append("(|");
        }
        for (String field : fields) {
            String attribute = this.searchFields.get(field);
            filter.append('(').append(attribute).append('=').append(query).append(")");
        }
        if (fields.size() > 1) {
            filter.append(')');
        }
        filter.append(')');
        List<String> userlist = this.manager.retrieveList(this.manager.getUsernameField(), filter.toString(), startIndex, numResults, this.manager.getUsernameSuffix(), true);
        return new UserCollection(userlist.toArray(new String[userlist.size()]));
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isNameRequired() {
        return false;
    }

    @Override
    public boolean isEmailRequired() {
        return false;
    }

    private static Date parseLDAPDate(String dateText) {
        boolean useUTC = false;
        if (dateText.endsWith("Z")) {
            useUTC = true;
        }
        Date date = new Date();
        try {
            if (useUTC) {
                ldapDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                ldapDateFormat.setTimeZone(TimeZone.getDefault());
            }
            date = ldapDateFormat.parse(dateText);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        return date;
    }
}

