/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.keystore;

import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtils {
    private static final Logger Log = LoggerFactory.getLogger(CertificateUtils.class);

    public static Set<X509Certificate> filterValid(X509Certificate ... certificates) {
        HashSet<X509Certificate> results = new HashSet<X509Certificate>();
        if (certificates != null) {
            for (X509Certificate certificate : certificates) {
                if (certificate == null) continue;
                try {
                    certificate.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    continue;
                }
                results.add(certificate);
            }
        }
        return results;
    }

    public static Set<X509Certificate> filterValid(Collection<X509Certificate> certificates) {
        if (certificates == null) {
            return Collections.emptySet();
        }
        return CertificateUtils.filterValid(certificates.toArray(new X509Certificate[certificates.size()]));
    }

    public static Set<TrustAnchor> toTrustAnchors(X509Certificate ... certificates) {
        HashSet<TrustAnchor> result = new HashSet<TrustAnchor>();
        for (X509Certificate certificate : certificates) {
            if (certificate == null) continue;
            result.add(new TrustAnchor(certificate, null));
        }
        return result;
    }

    public static Set<TrustAnchor> toTrustAnchors(Collection<X509Certificate> certificates) {
        if (certificates == null) {
            return Collections.emptySet();
        }
        return CertificateUtils.toTrustAnchors(certificates.toArray(new X509Certificate[certificates.size()]));
    }

    /*
     * WARNING - void declaration
     */
    public static List<X509Certificate> order(Collection<X509Certificate> certificates) throws CertificateException {
        void var5_8;
        Principal subject;
        LinkedList<X509Certificate> orderedResult = new LinkedList<X509Certificate>();
        if (certificates.isEmpty()) {
            return orderedResult;
        }
        if (certificates.size() == 1) {
            orderedResult.addAll(certificates);
            return orderedResult;
        }
        HashMap<Principal, X509Certificate> byIssuer = new HashMap<Principal, X509Certificate>();
        HashMap<Principal, X509Certificate> bySubject = new HashMap<Principal, X509Certificate>();
        for (X509Certificate x509Certificate : certificates) {
            Principal principal = x509Certificate.getIssuerDN();
            if (principal.equals(subject = x509Certificate.getSubjectDN())) {
                X509Certificate sameIssuer = byIssuer.put(null, x509Certificate);
                if (sameIssuer != null) {
                    throw new CertificateException("The provided input should not contain multiple root CA certificates. Issuer of first detected Root CA certificate: " + principal + " Issuer of second detected Root CA certificate: : " + sameIssuer);
                }
            } else if (byIssuer.put(principal, x509Certificate) != null) {
                throw new CertificateException("The provided input should not contain multiple certificates with identical issuerDN values. Offending value: " + principal);
            }
            if (bySubject.put(subject, x509Certificate) == null) continue;
            throw new CertificateException("The provided input should not contain multiple certificates with identical subjectDN values. Offending value: " + subject);
        }
        X509Certificate first = null;
        for (Map.Entry entry : bySubject.entrySet()) {
            subject = (Principal)entry.getKey();
            X509Certificate certificate = (X509Certificate)entry.getValue();
            if (byIssuer.containsKey(subject)) continue;
            if (first == null) {
                first = certificate;
                continue;
            }
            throw new CertificateException("The provided input should not contain more than one certificates that has a subjectDN value that's not equal to the issuerDN value of another certificate.");
        }
        if (first == null) {
            throw new CertificateException("The provided input should contain a certificate that has a subjectDN value that's not equal to the issuerDN value of any other certificate.");
        }
        orderedResult.add(first);
        X509Certificate x509Certificate = (X509Certificate)bySubject.remove(first.getIssuerDN());
        while (var5_8 != null) {
            orderedResult.add((X509Certificate)var5_8);
            X509Certificate x509Certificate2 = (X509Certificate)bySubject.remove(var5_8.getIssuerDN());
        }
        if (orderedResult.size() != certificates.size()) {
            throw new CertificateException("Unable to recreate a certificate chain from the provided input.");
        }
        return orderedResult;
    }

    public static X509Certificate identifyEndEntityCertificate(Collection<X509Certificate> chain) throws CertificateException {
        if (chain.isEmpty()) {
            throw new CertificateException();
        }
        try {
            return CertificateUtils.order(chain).get(0);
        }
        catch (CertificateException ex) {
            Log.warn("Unable to order the provided chain. As a fallback, the end entity certificate is assumed to be the first certificate of the input.", (Throwable)ex);
            return chain.iterator().next();
        }
    }

    public static Date findValidPointInTime(X509Certificate ... chain) {
        Date earliestNotAfter = null;
        Date latestNotBefore = null;
        for (X509Certificate certificate : chain) {
            if (certificate == null) continue;
            Date notAfter = certificate.getNotAfter();
            if (earliestNotAfter == null || notAfter != null && notAfter.before(earliestNotAfter)) {
                earliestNotAfter = notAfter;
            }
            Date notBefore = certificate.getNotBefore();
            if (latestNotBefore != null && (notBefore == null || !notBefore.after(latestNotBefore))) continue;
            latestNotBefore = notBefore;
        }
        if (latestNotBefore != null && earliestNotAfter != null && latestNotBefore.before(earliestNotAfter)) {
            return latestNotBefore;
        }
        return null;
    }
}

