/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.keystore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jivesoftware.openfire.keystore.CertificateStoreConfigException;
import org.jivesoftware.openfire.keystore.CertificateStoreConfiguration;
import org.jivesoftware.util.CertificateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CertificateStore {
    private static final Logger Log = LoggerFactory.getLogger(CertificateStore.class);
    protected static final Provider PROVIDER = new BouncyCastleProvider();
    protected final KeyStore store;
    protected final CertificateStoreConfiguration configuration;

    public CertificateStore(CertificateStoreConfiguration configuration, boolean createIfAbsent) throws CertificateStoreConfigException {
        block28: {
            if (configuration == null) {
                throw new IllegalArgumentException("Argument 'configuration' cannot be null.");
            }
            this.configuration = configuration;
            try {
                File file = configuration.getFile();
                if (createIfAbsent && !file.exists()) {
                    try (FileOutputStream os = new FileOutputStream(file.getPath());){
                        this.store = KeyStore.getInstance(configuration.getType());
                        this.store.load(null, configuration.getPassword());
                        this.store.store(os, configuration.getPassword());
                        break block28;
                    }
                }
                try (FileInputStream is = new FileInputStream(file);){
                    this.store = KeyStore.getInstance(configuration.getType());
                    this.store.load(is, configuration.getPassword());
                }
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                throw new CertificateStoreConfigException("Unable to load store of type '" + configuration.getType() + "' from file '" + configuration.getFile() + "'", ex);
            }
        }
    }

    public void reload() throws CertificateStoreConfigException {
        try (FileInputStream is = new FileInputStream(this.configuration.getFile());){
            this.store.load(is, this.configuration.getPassword());
            CertificateManager.fireCertificateStoreChanged(this);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException ex) {
            throw new CertificateStoreConfigException("Unable to reload store in '" + this.configuration.getFile() + "'", ex);
        }
    }

    public void persist() throws CertificateStoreConfigException {
        try (FileOutputStream os = new FileOutputStream(this.configuration.getFile());){
            this.store.store(os, this.configuration.getPassword());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new CertificateStoreConfigException("Unable to save changes to store in '" + this.configuration.getFile() + "'", ex);
        }
    }

    public Map<String, X509Certificate> getAllCertificates() throws KeyStoreException {
        HashMap<String, X509Certificate> results = new HashMap<String, X509Certificate>();
        for (String alias : Collections.list(this.store.aliases())) {
            Certificate certificate = this.store.getCertificate(alias);
            if (!(certificate instanceof X509Certificate)) continue;
            results.put(alias, (X509Certificate)certificate);
        }
        return results;
    }

    public void delete(String alias) throws CertificateStoreConfigException {
        if (alias == null || alias.trim().isEmpty()) {
            throw new IllegalArgumentException("Argument 'alias' cannot be null or an empty String.");
        }
        try {
            if (!this.store.containsAlias(alias)) {
                Log.info("Unable to delete certificate for alias '" + alias + "' from store, as the store does not contain a certificate for that alias.");
                return;
            }
            this.store.deleteEntry(alias);
            this.persist();
        }
        catch (KeyStoreException | CertificateStoreConfigException e) {
            this.reload();
            throw new CertificateStoreConfigException("Unable to install a certificate into an identity store.", e);
        }
    }

    public KeyStore getStore() {
        return this.store;
    }

    public CertificateStoreConfiguration getConfiguration() {
        return this.configuration;
    }

    static {
        Security.addProvider(PROVIDER);
    }
}

