/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.interceptor;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.dom4j.Element;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.component.ComponentEventListener;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.interceptor.InterceptorManager;
import org.jivesoftware.openfire.interceptor.PacketInterceptor;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.TaskEngine;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class PacketCopier
implements PacketInterceptor,
ComponentEventListener {
    private static final Logger Log = LoggerFactory.getLogger(PacketCopier.class);
    private static final PacketCopier instance = new PacketCopier();
    private Map<String, Subscription> subscribers = new ConcurrentHashMap<String, Subscription>();
    private String serverName;
    private RoutingTable routingTable;
    private ProcessPacketsTask packetsTask;
    private BlockingQueue<InterceptedPacket> packetQueue = new LinkedBlockingQueue<InterceptedPacket>(10000);

    public static PacketCopier getInstance() {
        return instance;
    }

    private PacketCopier() {
        InternalComponentManager.getInstance().addListener(this);
        XMPPServer server = XMPPServer.getInstance();
        this.serverName = server.getServerInfo().getXMPPDomain();
        this.routingTable = server.getRoutingTable();
        InterceptorManager.getInstance().addInterceptor(this);
        this.packetsTask = new ProcessPacketsTask();
        TaskEngine.getInstance().schedule((TimerTask)this.packetsTask, 5000L, 5000L);
    }

    public void addSubscriber(JID componentJID, boolean iqEnabled, boolean messageEnabled, boolean presenceEnabled, boolean incoming, boolean processed) {
        this.subscribers.put(componentJID.toString(), new Subscription(iqEnabled, messageEnabled, presenceEnabled, incoming, processed));
    }

    public void removeSubscriber(JID componentJID) {
        this.subscribers.remove(componentJID.toString());
    }

    @Override
    public void interceptPacket(Packet packet, Session session, boolean incoming, boolean processed) throws PacketRejectedException {
        if (!this.subscribers.isEmpty()) {
            boolean queue = false;
            Class<?> packetClass = packet.getClass();
            for (Subscription subscription : this.subscribers.values()) {
                if (subscription.isPresenceEnabled() && packetClass == Presence.class) {
                    queue = true;
                    continue;
                }
                if (subscription.isMessageEnabled() && packetClass == Message.class) {
                    queue = true;
                    continue;
                }
                if (!subscription.isIQEnabled() || packetClass != IQ.class) continue;
                queue = true;
            }
            if (queue) {
                this.packetQueue.add(new InterceptedPacket(packet, incoming, processed));
            }
        }
    }

    @Override
    public void componentInfoReceived(IQ iq) {
    }

    @Override
    public void componentRegistered(JID componentJID) {
    }

    @Override
    public void componentUnregistered(JID componentJID) {
        this.removeSubscriber(componentJID);
    }

    private void processPackets() {
        ArrayList packets = new ArrayList(this.packetQueue.size());
        this.packetQueue.drainTo(packets);
        for (InterceptedPacket interceptedPacket : packets) {
            for (Map.Entry<String, Subscription> entry : this.subscribers.entrySet()) {
                boolean notify = false;
                String componentJID = entry.getKey();
                Subscription subscription = entry.getValue();
                if (subscription.isIncoming() == interceptedPacket.isIncoming() && subscription.isProcessed() == interceptedPacket.isProcessed()) {
                    Class packetClass = interceptedPacket.getPacketClass();
                    if (subscription.isPresenceEnabled() && packetClass == Presence.class) {
                        notify = true;
                    } else if (subscription.isMessageEnabled() && packetClass == Message.class) {
                        notify = true;
                    } else if (subscription.isIQEnabled() && packetClass == IQ.class) {
                        notify = true;
                    }
                }
                if (!notify) continue;
                try {
                    Message message = new Message();
                    message.setFrom(this.serverName);
                    message.setTo(componentJID);
                    Element childElement = message.addChildElement("copy", "http://jabber.org/protocol/packet#event");
                    childElement.addAttribute("incoming", subscription.isIncoming() ? "true" : "false");
                    childElement.addAttribute("processed", subscription.isProcessed() ? "true" : "false");
                    childElement.addAttribute("date", XMPPDateTimeFormat.format(interceptedPacket.getCreationDate()));
                    childElement.add(interceptedPacket.getElement().createCopy());
                    this.routingTable.routePacket(message.getTo(), (Packet)message, true);
                }
                catch (Exception e) {
                    Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
                }
            }
        }
    }

    private static class InterceptedPacket {
        private Element element;
        private Class packetClass;
        private Date creationDate;
        private boolean incoming;
        private boolean processed;

        public InterceptedPacket(Packet packet, boolean incoming, boolean processed) {
            this.packetClass = packet.getClass();
            this.element = packet.getElement();
            this.incoming = incoming;
            this.processed = processed;
            this.creationDate = new Date();
        }

        public Class getPacketClass() {
            return this.packetClass;
        }

        public Date getCreationDate() {
            return this.creationDate;
        }

        public Element getElement() {
            return this.element;
        }

        public boolean isIncoming() {
            return this.incoming;
        }

        public boolean isProcessed() {
            return this.processed;
        }
    }

    private static class Subscription {
        private boolean presenceEnabled;
        private boolean messageEnabled;
        private boolean iqEnabled;
        private boolean incoming;
        private boolean processed;

        public Subscription(boolean iqEnabled, boolean messageEnabled, boolean presenceEnabled, boolean incoming, boolean processed) {
            this.incoming = incoming;
            this.iqEnabled = iqEnabled;
            this.messageEnabled = messageEnabled;
            this.presenceEnabled = presenceEnabled;
            this.processed = processed;
        }

        public boolean isIQEnabled() {
            return this.iqEnabled;
        }

        public boolean isMessageEnabled() {
            return this.messageEnabled;
        }

        public boolean isPresenceEnabled() {
            return this.presenceEnabled;
        }

        public boolean isIncoming() {
            return this.incoming;
        }

        public boolean isProcessed() {
            return this.processed;
        }
    }

    private class ProcessPacketsTask
    extends TimerTask {
        private ProcessPacketsTask() {
        }

        @Override
        public void run() {
            try {
                PacketCopier.this.processPackets();
            }
            catch (Throwable e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), e);
            }
        }
    }
}

