/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.interceptor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.interceptor.PacketInterceptor;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Packet;

public class InterceptorManager {
    private static final Logger Log = LoggerFactory.getLogger(InterceptorManager.class);
    private static InterceptorManager instance = new InterceptorManager();
    private XMPPServer server = XMPPServer.getInstance();
    private List<PacketInterceptor> globalInterceptors = new CopyOnWriteArrayList<PacketInterceptor>();
    private Map<String, List<PacketInterceptor>> usersInterceptors = new ConcurrentHashMap<String, List<PacketInterceptor>>();

    public static InterceptorManager getInstance() {
        return instance;
    }

    public List<PacketInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.globalInterceptors);
    }

    public void addInterceptor(PacketInterceptor interceptor) {
        if (interceptor == null) {
            throw new NullPointerException("Parameter interceptor was null.");
        }
        if (this.globalInterceptors.contains(interceptor)) {
            this.globalInterceptors.remove(interceptor);
        }
        this.globalInterceptors.add(interceptor);
    }

    public void addInterceptor(int index, PacketInterceptor interceptor) {
        if (index < 0 || index > this.globalInterceptors.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " invalid.");
        }
        if (interceptor == null) {
            throw new NullPointerException("Parameter interceptor was null.");
        }
        if (this.globalInterceptors.contains(interceptor)) {
            int oldIndex = this.globalInterceptors.indexOf(interceptor);
            if (oldIndex < index) {
                --index;
            }
            this.globalInterceptors.remove(interceptor);
        }
        this.globalInterceptors.add(index, interceptor);
    }

    public boolean removeInterceptor(PacketInterceptor interceptor) {
        return this.globalInterceptors.remove(interceptor);
    }

    public List<PacketInterceptor> getUserInterceptors(String username) {
        List<PacketInterceptor> userInterceptors = this.usersInterceptors.get(username);
        if (userInterceptors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(userInterceptors);
    }

    public void addUserInterceptor(String username, int index, PacketInterceptor interceptor) {
        List<PacketInterceptor> userInterceptors = this.usersInterceptors.get(username);
        if (userInterceptors == null) {
            userInterceptors = new CopyOnWriteArrayList<PacketInterceptor>();
            this.usersInterceptors.put(username, userInterceptors);
        } else {
            if (index < 0 || index > userInterceptors.size()) {
                throw new IndexOutOfBoundsException("Index " + index + " invalid.");
            }
            if (interceptor == null) {
                throw new NullPointerException("Parameter interceptor was null.");
            }
            if (userInterceptors.contains(interceptor)) {
                int oldIndex = userInterceptors.indexOf(interceptor);
                if (oldIndex < index) {
                    --index;
                }
                userInterceptors.remove(interceptor);
            }
        }
        userInterceptors.add(index, interceptor);
    }

    public boolean removeUserInterceptor(String username, PacketInterceptor interceptor) {
        boolean answer = false;
        List<PacketInterceptor> userInterceptors = this.usersInterceptors.get(username);
        if (userInterceptors != null) {
            answer = userInterceptors.remove(interceptor);
            if (userInterceptors.isEmpty()) {
                this.usersInterceptors.remove(username);
            }
        }
        return answer;
    }

    public void invokeInterceptors(Packet packet, Session session, boolean read, boolean processed) throws PacketRejectedException {
        String username;
        InterceptorManager.invokeInterceptors(this.globalInterceptors, packet, session, read, processed);
        if (this.usersInterceptors.isEmpty()) {
            return;
        }
        String string = username = session != null ? session.getAddress().getNode() : null;
        if (username != null && this.server.isLocal(session.getAddress())) {
            Collection userInterceptors = this.usersInterceptors.get(username);
            InterceptorManager.invokeInterceptors(userInterceptors, packet, session, read, processed);
        }
    }

    protected static void invokeInterceptors(Collection<PacketInterceptor> interceptors, Packet packet, Session session, boolean read, boolean processed) throws PacketRejectedException {
        if (interceptors == null || interceptors.isEmpty()) {
            return;
        }
        for (PacketInterceptor interceptor : interceptors) {
            try {
                interceptor.interceptPacket(packet, session, read, processed);
            }
            catch (PacketRejectedException e) {
                if (processed) {
                    Log.error("Post interceptor cannot reject packet.", (Throwable)e);
                    continue;
                }
                throw e;
            }
            catch (Throwable e) {
                Log.error("Error in interceptor: " + interceptor + " while intercepting: " + packet, e);
            }
        }
    }
}

