/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceServlet
extends HttpServlet {
    private static final Logger Log = LoggerFactory.getLogger(ResourceServlet.class);
    private static long expiresOffset = 864000L;
    private boolean debug = false;
    private boolean disableCompression = false;
    private static Cache<String, byte[]> cache = CacheFactory.createCache("Javascript Cache");

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.debug = Boolean.valueOf(config.getInitParameter("debug"));
        this.disableCompression = Boolean.valueOf(config.getInitParameter("disableCompression"));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) {
        boolean compress = false;
        boolean javascript = request.getRequestURI().endsWith("scripts/");
        if (!this.disableCompression) {
            if (request.getHeader("accept-encoding") != null && request.getHeader("accept-encoding").contains("gzip")) {
                compress = true;
            } else if (request.getHeader("---------------") != null) {
                compress = true;
            }
        }
        if (javascript) {
            response.setHeader("Content-type", "text/javascript");
        } else {
            response.setHeader("Content-type", "text/css");
        }
        response.setHeader("Vary", "Accept-Encoding");
        if (!this.debug) {
            SimpleDateFormat formatter = new SimpleDateFormat("d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            response.setHeader("Expires", formatter.format(new Date(System.currentTimeMillis() + expiresOffset)));
            response.setHeader("Cache-Control", "max-age=" + expiresOffset);
        } else {
            response.setHeader("Expires", "1");
            compress = false;
        }
        try {
            String cacheKey = String.valueOf(compress + " " + javascript);
            byte[] content = (byte[])cache.get(cacheKey);
            if (javascript && (this.debug || content == null)) {
                content = ResourceServlet.getJavaScriptContent(compress);
                cache.put(cacheKey, content);
            } else if (javascript || content == null) {
                // empty if block
            }
            response.setContentLength(content.length);
            if (compress) {
                response.setHeader("Content-Encoding", "gzip");
            }
            try (ByteArrayInputStream in = new ByteArrayInputStream(content);
                 ServletOutputStream out = response.getOutputStream();){
                int len;
                byte[] buf = new byte[131072];
                while ((len = in.read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
                out.flush();
            }
        }
        catch (IOException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] getJavaScriptContent(boolean compress) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Collection<String> getJavascriptFiles() {
        return Arrays.asList("prototype.js", "getelementsbyselector.js", "sarissa.js", "connection.js", "yahoo-min.js", "dom-min.js", "event-min.js", "dragdrop-min.js", "yui-ext.js", "spank.js");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJavaScriptFile(String path) {
        StringBuilder sb = new StringBuilder();
        try (InputStream in = ResourceServlet.getResourceAsStream(path);){
            if (in == null) {
                Log.error("Unable to find javascript file: '" + path + "' in classpath");
                String string = "";
                return string;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(in, "ISO-8859-1"));){
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line.trim()).append('\n');
                }
                return sb.toString();
            }
        }
        catch (Exception e) {
            Log.error("Error loading JavaScript file: '" + path + "'.", (Throwable)e);
        }
        return sb.toString();
    }

    private static InputStream getResourceAsStream(String resourceName) {
        File file = new File(JiveGlobals.getHomeDirectory() + File.separator + "resources" + File.separator + "spank" + File.separator + "scripts", resourceName);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

