/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.http;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.http.BoshBindingError;
import org.jivesoftware.openfire.http.HttpBindException;
import org.jivesoftware.openfire.http.HttpConnection;
import org.jivesoftware.openfire.http.HttpConnectionClosedException;
import org.jivesoftware.openfire.http.HttpSession;
import org.jivesoftware.openfire.http.SessionListener;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.NamedThreadFactory;
import org.jivesoftware.util.TaskEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionManager {
    private static final Logger Log = LoggerFactory.getLogger(HttpSessionManager.class);
    private SessionManager sessionManager;
    private Map<String, HttpSession> sessionMap = new ConcurrentHashMap<String, HttpSession>(JiveGlobals.getIntProperty("xmpp.httpbind.session.initial.count", 16));
    private TimerTask inactivityTask;
    private ThreadPoolExecutor sendPacketPool;
    private SessionListener sessionListener = new SessionListener(){

        @Override
        public void connectionOpened(HttpSession session, HttpConnection connection) {
        }

        @Override
        public void connectionClosed(HttpSession session, HttpConnection connection) {
        }

        @Override
        public void sessionClosed(HttpSession session) {
            HttpSessionManager.this.sessionMap.remove(session.getStreamID().getID());
        }
    };

    public HttpSessionManager() {
        JiveGlobals.migrateProperty("xmpp.httpbind.worker.threads");
        JiveGlobals.migrateProperty("xmpp.httpbind.worker.timeout");
    }

    @Deprecated
    public void init() {
    }

    private int getCorePoolSize(int maxPoolSize) {
        return maxPoolSize / 4 + 1;
    }

    public void start() {
        Log.info("Starting instance");
        this.sessionManager = SessionManager.getInstance();
        int maxClientPoolSize = JiveGlobals.getIntProperty("xmpp.client.processing.threads", 8);
        int maxPoolSize = JiveGlobals.getIntProperty("xmpp.httpbind.worker.threads", maxClientPoolSize);
        int keepAlive = JiveGlobals.getIntProperty("xmpp.httpbind.worker.timeout", 60);
        this.sendPacketPool = new ThreadPoolExecutor(this.getCorePoolSize(maxPoolSize), maxPoolSize, (long)keepAlive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("httpbind-worker-", true, null, Thread.currentThread().getThreadGroup(), null));
        this.sendPacketPool.prestartCoreThread();
        this.inactivityTask = new HttpSessionReaper();
        TaskEngine.getInstance().schedule(this.inactivityTask, 30000L, 30000L);
    }

    public void stop() {
        Log.info("Stopping instance");
        this.inactivityTask.cancel();
        for (HttpSession session : this.sessionMap.values()) {
            session.close();
        }
        this.sessionMap.clear();
        this.sendPacketPool.shutdown();
    }

    public HttpSession getSession(String streamID) {
        return this.sessionMap.get(streamID);
    }

    public HttpSession createSession(InetAddress address, Element rootNode, HttpConnection connection) throws UnauthorizedException, HttpBindException {
        String language = rootNode.attributeValue(QName.get((String)"lang", (String)"http://www.w3.org/XML/1998/namespace"));
        if (language == null || "".equals(language)) {
            language = "en";
        }
        int wait = HttpSessionManager.getIntAttribute(rootNode.attributeValue("wait"), 60);
        int hold = HttpSessionManager.getIntAttribute(rootNode.attributeValue("hold"), 1);
        String version = rootNode.attributeValue("ver");
        if (version == null || "".equals(version)) {
            version = "1.5";
        }
        HttpSession session = this.createSession(connection.getRequestId(), address, connection, Locale.forLanguageTag(language));
        session.setWait(Math.min(wait, this.getMaxWait()));
        session.setHold(hold);
        session.setSecure(connection.isSecure());
        session.setMaxPollingInterval(this.getPollingInterval());
        session.setMaxRequests(this.getMaxRequests());
        session.setMaxPause(this.getMaxPause());
        if (session.isPollingSession()) {
            session.setDefaultInactivityTimeout(this.getPollingInactivityTimeout());
        } else {
            session.setDefaultInactivityTimeout(this.getInactivityTimeout());
        }
        session.resetInactivityTimeout();
        String[] versionString = version.split("\\.");
        session.setMajorVersion(Integer.parseInt(versionString[0]));
        session.setMinorVersion(Integer.parseInt(versionString[1]));
        connection.setSession(session);
        try {
            connection.deliverBody(HttpSessionManager.createSessionCreationResponse(session), true);
        }
        catch (IOException | DocumentException | HttpConnectionClosedException e) {
            Log.error("Error creating session.", e);
            throw new HttpBindException("Internal server error", BoshBindingError.internalServerError);
        }
        return session;
    }

    public int getMaxPause() {
        return JiveGlobals.getIntProperty("xmpp.httpbind.client.maxpause", 300);
    }

    public int getMaxWait() {
        return JiveGlobals.getIntProperty("xmpp.httpbind.client.requests.wait", Integer.MAX_VALUE);
    }

    public int getPollingInterval() {
        return JiveGlobals.getIntProperty("xmpp.httpbind.client.requests.polling", 5);
    }

    public int getMaxRequests() {
        return JiveGlobals.getIntProperty("xmpp.httpbind.client.requests.max", 2);
    }

    public int getInactivityTimeout() {
        return JiveGlobals.getIntProperty("xmpp.httpbind.client.idle", 30);
    }

    public int getPollingInactivityTimeout() {
        return JiveGlobals.getIntProperty("xmpp.httpbind.client.idle.polling", 60);
    }

    private HttpSession createSession(long rid, InetAddress address, HttpConnection connection, Locale language) throws UnauthorizedException {
        StreamID streamID = SessionManager.getInstance().nextStreamID();
        HttpSession session = this.sessionManager.createClientHttpSession(rid, address, streamID, connection, language);
        this.sessionMap.put(streamID.getID(), session);
        session.addSessionCloseListener(this.sessionListener);
        return session;
    }

    private static int getIntAttribute(String value, int defaultValue) {
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private static String createSessionCreationResponse(HttpSession session) throws DocumentException {
        Element response = DocumentHelper.createElement((QName)QName.get((String)"body", (String)"http://jabber.org/protocol/httpbind"));
        response.addNamespace("stream", "http://etherx.jabber.org/streams");
        response.addAttribute("from", session.getServerName());
        response.addAttribute("authid", session.getStreamID().getID());
        response.addAttribute("sid", session.getStreamID().getID());
        response.addAttribute("secure", Boolean.TRUE.toString());
        response.addAttribute("requests", String.valueOf(session.getMaxRequests()));
        response.addAttribute("inactivity", String.valueOf(session.getInactivityTimeout()));
        response.addAttribute("polling", String.valueOf(session.getMaxPollingInterval()));
        response.addAttribute("wait", String.valueOf(session.getWait()));
        if (session.getMajorVersion() == 1 && session.getMinorVersion() >= 6 || session.getMajorVersion() > 1) {
            response.addAttribute("hold", String.valueOf(session.getHold()));
            response.addAttribute("ack", String.valueOf(session.getLastAcknowledged()));
            response.addAttribute("maxpause", String.valueOf(session.getMaxPause()));
            response.addAttribute("ver", String.valueOf(session.getMajorVersion()) + "." + String.valueOf(session.getMinorVersion()));
        }
        Element features = response.addElement("stream:features");
        for (Element feature : session.getAvailableStreamFeaturesElements()) {
            features.add(feature);
        }
        return response.asXML();
    }

    protected void execute(Runnable runnable) {
        this.sendPacketPool.execute(runnable);
    }

    private class HttpSessionReaper
    extends TimerTask {
        private HttpSessionReaper() {
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            for (HttpSession session : HttpSessionManager.this.sessionMap.values()) {
                try {
                    long lastActive = currentTime - session.getLastActivity();
                    if (Log.isDebugEnabled()) {
                        Log.debug("Session was last active " + lastActive + " ms ago: " + session.getAddress());
                    }
                    if (lastActive <= (long)session.getInactivityTimeout() * 1000L) continue;
                    Log.info("Closing idle session: " + session.getAddress());
                    session.close();
                }
                catch (Exception e) {
                    Log.error("Failed to determine idle state for session: " + session, (Throwable)e);
                }
            }
        }
    }
}

