/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.http;

import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.XMPPPacketReader;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.SessionPacketRouter;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.http.BoshBindingError;
import org.jivesoftware.openfire.http.HttpBindException;
import org.jivesoftware.openfire.http.HttpBindManager;
import org.jivesoftware.openfire.http.HttpBindServlet;
import org.jivesoftware.openfire.http.HttpConnection;
import org.jivesoftware.openfire.http.HttpConnectionClosedException;
import org.jivesoftware.openfire.http.SessionListener;
import org.jivesoftware.openfire.multiplex.UnknownStanzaException;
import org.jivesoftware.openfire.net.MXParser;
import org.jivesoftware.openfire.net.SASLAuthentication;
import org.jivesoftware.openfire.net.VirtualConnection;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.TaskEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class HttpSession
extends LocalClientSession {
    private static final Logger Log = LoggerFactory.getLogger(HttpSession.class);
    private static XmlPullParserFactory factory = null;
    private static ThreadLocal<XMPPPacketReader> localParser = null;
    private int wait;
    private int hold = 0;
    private String language;
    private final List<HttpConnection> connectionQueue = Collections.synchronizedList(new LinkedList());
    private final List<Deliverable> pendingElements = Collections.synchronizedList(new ArrayList());
    private final List<Delivered> sentElements = Collections.synchronizedList(new ArrayList());
    private boolean isSecure;
    private int maxPollingInterval;
    private long lastPoll = -1L;
    private Set<SessionListener> listeners = new CopyOnWriteArraySet<SessionListener>();
    private volatile boolean isClosed = false;
    private int inactivityTimeout;
    private int defaultInactivityTimeout;
    private long lastActivity;
    private long lastRequestID;
    private boolean lastResponseEmpty;
    private int maxRequests;
    private int maxPause;
    private PacketDeliverer backupDeliverer;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private X509Certificate[] sslCertificates;
    private final Queue<Collection<Element>> packetsToSend = new LinkedList<Collection<Element>>();
    private SessionPacketRouter router;
    private static final Comparator<HttpConnection> connectionComparator;

    public HttpSession(PacketDeliverer backupDeliverer, String serverName, InetAddress address, StreamID streamID, long rid, HttpConnection connection, Locale language) {
        super(serverName, new HttpVirtualConnection(address, ConnectionType.SOCKET_C2S), streamID, language);
        this.lastActivity = System.currentTimeMillis();
        this.lastRequestID = rid;
        this.backupDeliverer = backupDeliverer;
        this.sslCertificates = connection.getPeerCertificates();
    }

    public Collection<Element> getAvailableStreamFeaturesElements() {
        Element sasl;
        ArrayList<Element> elements = new ArrayList<Element>();
        if (this.getAuthToken() == null && (sasl = SASLAuthentication.getSASLMechanismsElement(this)) != null) {
            elements.add(sasl);
        }
        if (XMPPServer.getInstance().getIQRegisterHandler().isInbandRegEnabled()) {
            elements.add(DocumentHelper.createElement((QName)new QName("register", new Namespace("", "http://jabber.org/features/iq-register"))));
        }
        Element bind = DocumentHelper.createElement((QName)new QName("bind", new Namespace("", "urn:ietf:params:xml:ns:xmpp-bind")));
        elements.add(bind);
        Element session = DocumentHelper.createElement((QName)new QName("session", new Namespace("", "urn:ietf:params:xml:ns:xmpp-session")));
        session.addElement("optional");
        elements.add(session);
        return elements;
    }

    @Override
    public String getAvailableStreamFeatures() {
        StringBuilder sb = new StringBuilder(200);
        for (Element element : this.getAvailableStreamFeaturesElements()) {
            sb.append(element.asXML());
        }
        return sb.toString();
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.conn.close();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public void setWait(int wait) {
        this.wait = wait;
    }

    public int getWait() {
        return this.wait;
    }

    public void setHold(int hold) {
        this.hold = hold;
    }

    public int getHold() {
        return this.hold;
    }

    public void setMaxPollingInterval(int maxPollingInterval) {
        this.maxPollingInterval = maxPollingInterval;
    }

    public int getMaxPollingInterval() {
        return this.maxPollingInterval;
    }

    public void setMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public void setMaxPause(int maxPause) {
        this.maxPause = maxPause;
    }

    public int getMaxPause() {
        return this.maxPause;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    public boolean isPollingSession() {
        return this.wait == 0 || this.hold == 0;
    }

    public void addSessionCloseListener(SessionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSessionCloseListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    public void setDefaultInactivityTimeout(int defaultInactivityTimeout) {
        this.defaultInactivityTimeout = defaultInactivityTimeout;
    }

    public void setInactivityTimeout(int inactivityTimeout) {
        this.inactivityTimeout = inactivityTimeout;
    }

    public void resetInactivityTimeout() {
        this.inactivityTimeout = this.defaultInactivityTimeout;
    }

    public int getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(int duration) {
        List<HttpConnection> list = this.connectionQueue;
        synchronized (list) {
            for (HttpConnection toClose : this.connectionQueue) {
                if (toClose.isClosed()) continue;
                toClose.close();
                this.lastRequestID = toClose.getRequestId();
            }
        }
        this.setInactivityTimeout(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivity() {
        if (!this.connectionQueue.isEmpty()) {
            List<HttpConnection> list = this.connectionQueue;
            synchronized (list) {
                for (HttpConnection connection : this.connectionQueue) {
                    if (connection.isClosed()) continue;
                    this.lastActivity = System.currentTimeMillis();
                    break;
                }
            }
        }
        return this.lastActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastAcknowledged() {
        long ack = this.lastRequestID;
        Collections.sort(this.connectionQueue, connectionComparator);
        List<HttpConnection> list = this.connectionQueue;
        synchronized (list) {
            for (HttpConnection connection : this.connectionQueue) {
                if (connection.getRequestId() != ack + 1L) continue;
                ++ack;
            }
        }
        return ack;
    }

    public void setMajorVersion(int majorVersion) {
        if (majorVersion != 1) {
            return;
        }
        this.majorVersion = majorVersion;
    }

    public int getMajorVersion() {
        if (this.majorVersion != -1) {
            return this.majorVersion;
        }
        return 1;
    }

    public void setMinorVersion(int minorVersion) {
        if (minorVersion <= 5) {
            this.minorVersion = 5;
        } else if (minorVersion >= 6) {
            this.minorVersion = 6;
        }
    }

    public int getMinorVersion() {
        if (this.minorVersion != -1) {
            return this.minorVersion;
        }
        return 5;
    }

    public void setLastResponseEmpty(boolean lastResponseEmpty) {
        this.lastResponseEmpty = lastResponseEmpty;
    }

    protected void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public void forwardRequest(long rid, boolean isSecure, Element rootNode, AsyncContext context) throws HttpBindException, HttpConnectionClosedException, IOException {
        boolean isPoll;
        List elements = rootNode.elements();
        boolean bl = isPoll = elements.size() == 0;
        if ("terminate".equals(rootNode.attributeValue("type"))) {
            isPoll = false;
        } else if ("true".equals(rootNode.attributeValue(new QName("restart", rootNode.getNamespaceForPrefix("xmpp"))))) {
            isPoll = false;
        } else if (rootNode.attributeValue("pause") != null) {
            isPoll = false;
        }
        HttpConnection connection = this.createConnection(rid, isSecure, isPoll, context);
        if (elements.size() > 0) {
            this.packetsToSend.add(elements);
            new HttpPacketSender(this).init();
        }
        String type = rootNode.attributeValue("type");
        String restartStream = rootNode.attributeValue(new QName("restart", rootNode.getNamespaceForPrefix("xmpp")));
        int pauseDuration = HttpBindServlet.getIntAttribute(rootNode.attributeValue("pause"), -1);
        if ("terminate".equals(type)) {
            connection.deliverBody(this.createEmptyBody(true), true);
            this.close();
            this.lastRequestID = connection.getRequestId();
        } else if ("true".equals(restartStream) && rootNode.elements().size() == 0) {
            connection.deliverBody(this.createSessionRestartResponse(), true);
            this.lastRequestID = connection.getRequestId();
        } else if (pauseDuration > 0 && pauseDuration <= this.getMaxPause()) {
            this.pause(pauseDuration);
            connection.deliverBody(this.createEmptyBody(false), true);
            this.lastRequestID = connection.getRequestId();
            this.setLastResponseEmpty(true);
        } else {
            this.resetInactivityTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPendingPackets() {
        Queue<Collection<Element>> queue = this.packetsToSend;
        synchronized (queue) {
            if (this.packetsToSend.isEmpty()) {
                return;
            }
            if (this.router == null) {
                this.router = new SessionPacketRouter(this);
            }
            for (Element packet : this.packetsToSend.remove()) {
                try {
                    this.router.route(packet);
                }
                catch (UnknownStanzaException e) {
                    Log.error("Client provided unknown packet type", (Throwable)e);
                }
            }
        }
    }

    public X509Certificate[] getPeerCertificates() {
        return this.sslCertificates;
    }

    synchronized HttpConnection createConnection(long rid, boolean isSecure, boolean isPoll, AsyncContext context) throws HttpConnectionClosedException, HttpBindException, IOException {
        final HttpConnection connection = new HttpConnection(rid, isSecure, this.sslCertificates, context);
        connection.setSession(this);
        context.setTimeout((long)this.getWait() * 1000L);
        context.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent asyncEvent) throws IOException {
                Log.debug("complete event " + asyncEvent);
                HttpSession.this.connectionQueue.remove(connection);
                HttpSession.this.fireConnectionClosed(connection);
            }

            public void onTimeout(AsyncEvent asyncEvent) throws IOException {
                Log.debug("timeout event " + asyncEvent);
                try {
                    connection.deliverBody(HttpSession.this.createEmptyBody(false), false);
                    HttpSession.this.setLastResponseEmpty(true);
                    if (connection.getRequestId() != HttpSession.this.lastRequestID + 1L) {
                        throw new IOException("Unexpected RID error.");
                    }
                    HttpSession.this.lastRequestID = connection.getRequestId();
                }
                catch (HttpConnectionClosedException e) {
                    Log.warn("Unexpected exception while processing connection timeout.", (Throwable)e);
                }
            }

            public void onError(AsyncEvent asyncEvent) throws IOException {
                Log.debug("error event " + asyncEvent);
                Log.warn("Unhandled AsyncListener error: " + asyncEvent.getThrowable());
                HttpSession.this.connectionQueue.remove(connection);
                HttpSession.this.fireConnectionClosed(connection);
            }

            public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
            }
        });
        if (rid <= this.lastRequestID) {
            Delivered deliverable = this.retrieveDeliverable(rid);
            if (deliverable == null) {
                Log.warn("Deliverable unavailable for " + rid);
                throw new HttpBindException("Unexpected RID error.", BoshBindingError.itemNotFound);
            }
            connection.deliverBody(this.createDeliverable(deliverable.deliverables), true);
            this.addConnection(connection, isPoll);
            return connection;
        }
        if (rid > this.lastRequestID + (long)this.maxRequests) {
            Log.warn("Request " + rid + " > " + (this.lastRequestID + (long)this.maxRequests) + ", ending session.");
            throw new HttpBindException("Unexpected RID error.", BoshBindingError.itemNotFound);
        }
        this.addConnection(connection, isPoll);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Delivered retrieveDeliverable(long rid) {
        Delivered result = null;
        List<Delivered> list = this.sentElements;
        synchronized (list) {
            for (Delivered delivered : this.sentElements) {
                if (delivered.getRequestID() != rid) continue;
                result = delivered;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnection(HttpConnection connection, boolean isPoll) throws HttpBindException, HttpConnectionClosedException, IOException {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null.");
        }
        if (this.isSecure && !connection.isSecure()) {
            throw new HttpBindException("Session was started from secure connection, all connections on this session must be secured.", BoshBindingError.badRequest);
        }
        long rid = connection.getRequestId();
        List<Object> list = this.connectionQueue;
        synchronized (list) {
            for (HttpConnection queuedConnection : this.connectionQueue) {
                if (queuedConnection.getRequestId() != rid) continue;
                if (Log.isDebugEnabled()) {
                    Log.debug("Found previous connection in queue with rid " + rid);
                }
                if (queuedConnection.isClosed()) {
                    Delivered deliverable;
                    if (Log.isDebugEnabled()) {
                        Log.debug("It's closed - copying deliverables");
                    }
                    if ((deliverable = this.retrieveDeliverable(rid)) == null) {
                        Log.warn("Deliverable unavailable for " + rid);
                        throw new HttpBindException("Unexpected RID error.", BoshBindingError.itemNotFound);
                    }
                    connection.deliverBody(this.createDeliverable(deliverable.deliverables), true);
                    break;
                }
                if (Log.isDebugEnabled()) {
                    Log.debug("It's still open - calling close()");
                }
                this.deliver(queuedConnection, Collections.singleton(new Deliverable("")));
                connection.close();
                if (rid != this.lastRequestID + 1L) break;
                this.lastRequestID = rid;
                break;
            }
        }
        this.checkOveractivity(isPoll);
        this.sslCertificates = connection.getPeerCertificates();
        if (this.isPollingSession() || this.pendingElements.size() > 0 && connection.getRequestId() == this.lastRequestID + 1L) {
            this.fireConnectionOpened(connection);
            list = this.pendingElements;
            synchronized (list) {
                this.deliver(connection, this.pendingElements);
                this.lastRequestID = connection.getRequestId();
                this.pendingElements.clear();
            }
        }
        this.connectionQueue.add(connection);
        Collections.sort(this.connectionQueue, connectionComparator);
        list = this.connectionQueue;
        synchronized (list) {
            int connectionsToClose = this.connectionQueue.get(this.connectionQueue.size() - 1) != connection ? this.connectionQueue.size() : this.getOpenConnectionCount() - this.hold;
            int closed = 0;
            for (int i = 0; i < this.connectionQueue.size() && closed < connectionsToClose; ++i) {
                HttpConnection toClose = this.connectionQueue.get(i);
                if (toClose.isClosed() || toClose.getRequestId() != this.lastRequestID + 1L) continue;
                if (toClose == connection) {
                    this.deliver("");
                } else {
                    toClose.close();
                }
                this.lastRequestID = toClose.getRequestId();
                ++closed;
            }
        }
    }

    private int getOpenConnectionCount() {
        int count = 0;
        for (HttpConnection connection : this.connectionQueue) {
            if (connection.isClosed()) continue;
            ++count;
        }
        return count;
    }

    private void deliver(HttpConnection connection, Collection<Deliverable> deliverable) throws HttpConnectionClosedException, IOException {
        connection.deliverBody(this.createDeliverable(deliverable), true);
        Delivered delivered = new Delivered(deliverable);
        delivered.setRequestID(connection.getRequestId());
        while (this.sentElements.size() > this.maxRequests) {
            this.sentElements.remove(0);
        }
        this.sentElements.add(delivered);
    }

    private void fireConnectionOpened(HttpConnection connection) {
        this.lastActivity = System.currentTimeMillis();
        for (SessionListener listener : this.listeners) {
            listener.connectionOpened(this, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOveractivity(boolean isPoll) throws HttpBindException {
        int pendingConnections = 0;
        boolean overactivity = false;
        String errorMessage = "Overactivity detected";
        List<HttpConnection> list = this.connectionQueue;
        synchronized (list) {
            for (HttpConnection conn : this.connectionQueue) {
                if (conn.isClosed()) continue;
                ++pendingConnections;
            }
        }
        if (pendingConnections >= this.maxRequests) {
            overactivity = true;
            errorMessage = errorMessage + ", too many simultaneous requests.";
        } else if (isPoll) {
            long time = System.currentTimeMillis();
            if (time - this.lastPoll < (long)this.maxPollingInterval * 1000L) {
                overactivity = this.isPollingSession() ? this.lastResponseEmpty : pendingConnections >= this.maxRequests - 1;
            }
            errorMessage = errorMessage + ", minimum polling interval is " + this.maxPollingInterval + ", current interval " + (time - this.lastPoll) / 1000L;
            this.lastPoll = time;
        }
        this.setLastResponseEmpty(false);
        if (overactivity) {
            Log.debug(errorMessage);
            if (!JiveGlobals.getBooleanProperty("xmpp.httpbind.client.requests.ignoreOveractivity", false)) {
                throw new HttpBindException(errorMessage, BoshBindingError.policyViolation);
            }
        }
    }

    private void deliver(String text) {
        if (text == null) {
            return;
        }
        this.deliver(new Deliverable(text));
    }

    @Override
    public void deliver(Packet stanza) {
        this.deliver(new Deliverable(Arrays.asList(stanza)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver(Deliverable stanza) {
        List<Deliverable> deliverable = Arrays.asList(stanza);
        boolean delivered = false;
        int pendingConnections = 0;
        List<HttpConnection> list = this.connectionQueue;
        synchronized (list) {
            for (HttpConnection connection : this.connectionQueue) {
                if (connection.isClosed()) continue;
                ++pendingConnections;
                try {
                    if (connection.getRequestId() != this.lastRequestID + 1L) continue;
                    this.lastRequestID = connection.getRequestId();
                    this.deliver(connection, deliverable);
                    delivered = true;
                    break;
                }
                catch (HttpConnectionClosedException e) {
                    Log.warn("Iterating over a connection that was closed. Openfire will recover from this problem, but it should not occur in the first place.");
                }
                catch (IOException e) {
                    Log.warn("An unexpected exception occurred while iterating over connections. Openfire will attempt to recover by ignoring this connection.", (Throwable)e);
                }
            }
        }
        if (!delivered) {
            if (pendingConnections > 0) {
                Log.warn("Unable to deliver a stanza (it is being queued instead), although there are available connections! RID / Connection processing is out of sync!");
            }
            this.pendingElements.add(stanza);
        }
    }

    private void fireConnectionClosed(HttpConnection connection) {
        this.lastActivity = System.currentTimeMillis();
        for (SessionListener listener : this.listeners) {
            listener.connectionClosed(this, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createDeliverable(Collection<Deliverable> elements) {
        StringBuilder builder = new StringBuilder();
        builder.append("<body xmlns='http://jabber.org/protocol/httpbind' ack='").append(this.getLastAcknowledged()).append("'>");
        this.setLastResponseEmpty(elements.size() == 0);
        Collection<Deliverable> collection = elements;
        synchronized (collection) {
            for (Deliverable child : elements) {
                builder.append(child.getDeliverable());
            }
        }
        builder.append("</body>");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            Object object = this.connectionQueue;
            synchronized (object) {
                for (HttpConnection toClose : this.connectionQueue) {
                    try {
                        if (toClose.isClosed()) continue;
                        if (!this.pendingElements.isEmpty() && toClose.getRequestId() == this.lastRequestID + 1L) {
                            List<Deliverable> list = this.pendingElements;
                            synchronized (list) {
                                this.deliver(toClose, this.pendingElements);
                                this.lastRequestID = toClose.getRequestId();
                                this.pendingElements.clear();
                                continue;
                            }
                        }
                        toClose.deliverBody(null, true);
                    }
                    catch (HttpConnectionClosedException httpConnectionClosedException) {
                    }
                    catch (IOException e) {
                        Log.debug("An unexpected exception occurred while closing a session.", (Throwable)e);
                    }
                }
            }
            object = this.pendingElements;
            synchronized (object) {
                for (Deliverable deliverable : this.pendingElements) {
                    this.failDelivery(deliverable.getPackets());
                }
                this.pendingElements.clear();
            }
        }
        catch (Throwable throwable) {
            for (SessionListener listener : this.listeners) {
                listener.sessionClosed(this);
            }
            this.listeners.clear();
            throw throwable;
        }
        for (SessionListener listener : this.listeners) {
            listener.sessionClosed(this);
        }
        this.listeners.clear();
    }

    private void failDelivery(final Collection<Packet> packets) {
        if (packets == null) {
            return;
        }
        TaskEngine.getInstance().submit(new Runnable(){

            @Override
            public void run() {
                for (Packet packet : packets) {
                    try {
                        HttpSession.this.backupDeliverer.deliver(packet);
                    }
                    catch (UnauthorizedException e) {
                        Log.error("Unable to deliver message to backup deliverer", (Throwable)e);
                    }
                }
            }
        });
    }

    protected String createEmptyBody(boolean terminate) {
        Element body = DocumentHelper.createElement((QName)QName.get((String)"body", (String)"http://jabber.org/protocol/httpbind"));
        if (terminate) {
            body.addAttribute("type", "terminate");
        }
        body.addAttribute("ack", String.valueOf(this.getLastAcknowledged()));
        return body.asXML();
    }

    private String createSessionRestartResponse() {
        Element response = DocumentHelper.createElement((QName)QName.get((String)"body", (String)"http://jabber.org/protocol/httpbind"));
        response.addNamespace("stream", "http://etherx.jabber.org/streams");
        Element features = response.addElement("stream:features");
        for (Element feature : this.getAvailableStreamFeaturesElements()) {
            features.add(feature);
        }
        return response.asXML();
    }

    static {
        try {
            factory = XmlPullParserFactory.newInstance((String)MXParser.class.getName(), null);
            factory.setNamespaceAware(true);
        }
        catch (XmlPullParserException e) {
            Log.error("Error creating a parser factory", (Throwable)e);
        }
        localParser = new ThreadLocal<XMPPPacketReader>(){

            @Override
            protected XMPPPacketReader initialValue() {
                XMPPPacketReader parser = new XMPPPacketReader();
                factory.setNamespaceAware(true);
                parser.setXPPFactory(factory);
                return parser;
            }
        };
        connectionComparator = new Comparator<HttpConnection>(){

            @Override
            public int compare(HttpConnection o1, HttpConnection o2) {
                return (int)(o1.getRequestId() - o2.getRequestId());
            }
        };
    }

    private class HttpPacketSender
    implements Runnable {
        private HttpSession session;

        HttpPacketSender(HttpSession session) {
            this.session = session;
        }

        @Override
        public void run() {
            this.session.sendPendingPackets();
        }

        private void init() {
            HttpBindManager.getInstance().getSessionManager().execute(this);
        }
    }

    private class Delivered {
        private long requestID;
        private Collection<Deliverable> deliverables;

        public Delivered(Collection<Deliverable> deliverables) {
            this.deliverables = deliverables;
        }

        public void setRequestID(long requestID) {
            this.requestID = requestID;
        }

        public long getRequestID() {
            return this.requestID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<Packet> getPackets() {
            ArrayList<Packet> packets = new ArrayList<Packet>();
            Collection<Deliverable> collection = this.deliverables;
            synchronized (collection) {
                for (Deliverable deliverable : this.deliverables) {
                    if (deliverable.packets == null) continue;
                    packets.addAll(deliverable.getPackets());
                }
            }
            return packets;
        }
    }

    static class Deliverable {
        private final String text;
        private final Collection<String> packets;

        public Deliverable(String text) {
            this.text = text;
            this.packets = null;
        }

        public Deliverable(Collection<Packet> elements) {
            this.text = null;
            this.packets = new ArrayList<String>();
            for (Packet packet : elements) {
                if (Namespace.NO_NAMESPACE.equals((Object)packet.getElement().getNamespace())) {
                    int slash;
                    StringBuilder packetXml = new StringBuilder(packet.toXML());
                    int noslash = packetXml.indexOf(">");
                    int insertAt = noslash - 1 == (slash = packetXml.indexOf("/>")) ? slash : noslash;
                    packetXml.insert(insertAt, " xmlns=\"jabber:client\"");
                    this.packets.add(packetXml.toString());
                    continue;
                }
                this.packets.add(packet.toXML());
            }
        }

        public String getDeliverable() {
            if (this.text == null) {
                StringBuilder builder = new StringBuilder();
                for (String packet : this.packets) {
                    builder.append(packet);
                }
                return builder.toString();
            }
            return this.text;
        }

        public Collection<Packet> getPackets() {
            if (this.packets == null) {
                return null;
            }
            ArrayList<Packet> answer = new ArrayList<Packet>();
            for (String packetXML : this.packets) {
                try {
                    Message packet = null;
                    Element element = ((XMPPPacketReader)localParser.get()).read(new StringReader(packetXML)).getRootElement();
                    String tag = element.getName();
                    if ("message".equals(tag)) {
                        packet = new Message(element, true);
                    } else if ("presence".equals(tag)) {
                        packet = new Presence(element, true);
                    } else if ("iq".equals(tag)) {
                        packet = new IQ(element, true);
                    }
                    answer.add((Packet)packet);
                }
                catch (Exception e) {
                    Log.error("Error while parsing Privacy Property", (Throwable)e);
                }
            }
            return answer;
        }
    }

    public static class HttpVirtualConnection
    extends VirtualConnection {
        private InetAddress address;
        private ConnectionConfiguration configuration;
        private ConnectionType connectionType;

        public HttpVirtualConnection(InetAddress address) {
            this.address = address;
            this.connectionType = ConnectionType.SOCKET_C2S;
        }

        public HttpVirtualConnection(InetAddress address, ConnectionType connectionType) {
            this.address = address;
            this.connectionType = connectionType;
        }

        @Override
        public void closeVirtualConnection() {
            ((HttpSession)this.session).closeSession();
        }

        @Override
        public byte[] getAddress() throws UnknownHostException {
            return this.address.getAddress();
        }

        @Override
        public String getHostAddress() throws UnknownHostException {
            return this.address.getHostAddress();
        }

        @Override
        public String getHostName() throws UnknownHostException {
            return this.address.getHostName();
        }

        @Override
        public void systemShutdown() {
            this.close();
        }

        @Override
        public void deliver(Packet packet) throws UnauthorizedException {
            ((HttpSession)this.session).deliver(packet);
        }

        @Override
        public void deliverRawText(String text) {
            ((HttpSession)this.session).deliver(text);
        }

        @Override
        public ConnectionConfiguration getConfiguration() {
            if (this.configuration == null) {
                ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
                this.configuration = connectionManager.getListener(this.connectionType, true).generateConnectionConfiguration();
            }
            return this.configuration;
        }

        @Override
        public Certificate[] getPeerCertificates() {
            return ((HttpSession)this.session).getPeerCertificates();
        }
    }
}

