/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.http;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.servlet.AsyncContext;
import org.jivesoftware.openfire.http.HttpBindServlet;
import org.jivesoftware.openfire.http.HttpConnectionClosedException;
import org.jivesoftware.openfire.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection {
    private static final Logger Log = LoggerFactory.getLogger(HttpConnection.class);
    private final long requestId;
    private final X509Certificate[] sslCertificates;
    private final boolean isSecure;
    private HttpSession session;
    private boolean isClosed;
    private final AsyncContext context;

    public HttpConnection(long requestId, boolean isSecure, X509Certificate[] sslCertificates, AsyncContext context) {
        this.requestId = requestId;
        this.isSecure = isSecure;
        this.sslCertificates = sslCertificates;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this.isClosed) {
                return;
            }
        }
        try {
            this.deliverBody(null, true);
        }
        catch (IOException | HttpConnectionClosedException e) {
            Log.warn("Unexpected exception occurred while trying to close an HttpException.", (Throwable)e);
        }
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverBody(String body, boolean async) throws HttpConnectionClosedException, IOException {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this.isClosed) {
                throw new HttpConnectionClosedException("The http connection is no longer available to deliver content");
            }
            this.isClosed = true;
        }
        if (body == null) {
            body = this.getSession().createEmptyBody(false);
        }
        HttpBindServlet.respond(this.getSession(), this.context, body, async);
    }

    public long getRequestId() {
        return this.requestId;
    }

    void setSession(HttpSession session) {
        this.session = session;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public X509Certificate[] getPeerCertificates() {
        return this.sslCertificates;
    }

    public String toString() {
        return (this.session != null ? this.session.toString() : "[Anonymous]") + " rid: " + this.getRequestId();
    }
}

