/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.XMPPPacketReader;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.http.BoshBindingError;
import org.jivesoftware.openfire.http.HttpBindException;
import org.jivesoftware.openfire.http.HttpBindManager;
import org.jivesoftware.openfire.http.HttpConnection;
import org.jivesoftware.openfire.http.HttpConnectionClosedException;
import org.jivesoftware.openfire.http.HttpSession;
import org.jivesoftware.openfire.http.HttpSessionManager;
import org.jivesoftware.openfire.net.MXParser;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class HttpBindServlet
extends HttpServlet {
    private static final Logger Log = LoggerFactory.getLogger(HttpBindServlet.class);
    private HttpSessionManager sessionManager;
    private HttpBindManager boshManager;
    private static XmlPullParserFactory factory;
    private ThreadLocal<XMPPPacketReader> localReader = new ThreadLocal();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.boshManager = HttpBindManager.getInstance();
        this.sessionManager = this.boshManager.getSessionManager();
        this.sessionManager.start();
    }

    public void destroy() {
        super.destroy();
        this.sessionManager.stop();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.boshManager.isCORSEnabled()) {
            if (this.boshManager.isAllOriginsAllowed()) {
                response.setHeader("Access-Control-Allow-Origin", "*");
            } else {
                String origin = request.getHeader("Origin");
                if (this.boshManager.isThisOriginAllowed(origin)) {
                    response.setHeader("Access-Control-Allow-Origin", origin);
                }
            }
            response.setHeader("Access-Control-Allow-Methods", "PROPFIND, PROPPATCH, COPY, MOVE, DELETE, MKCOL, LOCK, UNLOCK, PUT, GETLIB, VERSION-CONTROL, CHECKIN, CHECKOUT, UNCHECKOUT, REPORT, UPDATE, CANCELUPLOAD, HEAD, OPTIONS, GET, POST");
            response.setHeader("Access-Control-Allow-Headers", "Overwrite, Destination, Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
            response.setHeader("Access-Control-Max-Age", "86400");
        }
        super.service(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext context = request.startAsync();
        boolean isScriptSyntaxEnabled = this.boshManager.isScriptSyntaxEnabled();
        if (!isScriptSyntaxEnabled) {
            HttpBindServlet.sendLegacyError(context, BoshBindingError.itemNotFound);
            return;
        }
        String queryString = request.getQueryString();
        if (queryString == null || "".equals(queryString)) {
            HttpBindServlet.sendLegacyError(context, BoshBindingError.badRequest);
            return;
        }
        if ("isBoshAvailable".equals(queryString)) {
            response.setStatus(200);
            context.complete();
            return;
        }
        queryString = URLDecoder.decode(queryString, "UTF-8");
        this.processContent(context, queryString);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext context = request.startAsync();
        try {
            request.getInputStream().setReadListener((ReadListener)new ReadListenerImpl(context));
        }
        catch (IllegalStateException e) {
            Log.warn("Error when setting read listener", (Throwable)e);
            context.complete();
        }
    }

    protected void processContent(AsyncContext context, String content) throws IOException {
        Document document;
        String remoteAddress = HttpBindServlet.getRemoteAddress(context);
        try {
            document = this.getPacketReader().read(new StringReader(content), "UTF-8");
        }
        catch (Exception ex) {
            Log.warn("Error parsing request data from [" + remoteAddress + "]", (Throwable)ex);
            HttpBindServlet.sendLegacyError(context, BoshBindingError.badRequest);
            return;
        }
        if (document == null) {
            Log.info("The result of parsing request data from [" + remoteAddress + "] was a null-object.");
            HttpBindServlet.sendLegacyError(context, BoshBindingError.badRequest);
            return;
        }
        Element node = document.getRootElement();
        if (node == null || !"body".equals(node.getName())) {
            Log.info("Root element 'body' is missing from parsed request data from [" + remoteAddress + "]");
            HttpBindServlet.sendLegacyError(context, BoshBindingError.badRequest);
            return;
        }
        long rid = HttpBindServlet.getLongAttribute(node.attributeValue("rid"), -1L);
        if (rid <= 0L) {
            Log.info("Root element 'body' does not contain a valid RID attribute value in parsed request data from [" + remoteAddress + "]");
            HttpBindServlet.sendLegacyError(context, BoshBindingError.badRequest, "Body-element is missing a RID (Request ID) value, or the provided value is a non-positive integer.");
            return;
        }
        String sid = node.attributeValue("sid");
        if (sid == null) {
            if (node.elements().size() > 0) {
                Log.info("Root element 'body' does not contain a SID attribute value in parsed request data from [" + remoteAddress + "]");
                HttpBindServlet.sendLegacyError(context, BoshBindingError.badRequest);
                return;
            }
            this.createNewSession(context, node);
        } else {
            this.handleSessionRequest(sid, context, node);
        }
    }

    protected void createNewSession(AsyncContext context, Element rootNode) throws IOException {
        long rid = HttpBindServlet.getLongAttribute(rootNode.attributeValue("rid"), -1L);
        try {
            X509Certificate[] certificates = (X509Certificate[])context.getRequest().getAttribute("javax.servlet.request.X509Certificate");
            HttpConnection connection = new HttpConnection(rid, context.getRequest().isSecure(), certificates, context);
            InetAddress address = InetAddress.getByName(context.getRequest().getRemoteAddr());
            connection.setSession(this.sessionManager.createSession(address, rootNode, connection));
            if (JiveGlobals.getBooleanProperty("log.httpbind.enabled", false)) {
                Log.info(new Date() + ": HTTP RECV(" + connection.getSession().getStreamID().getID() + "): " + rootNode.asXML());
            }
        }
        catch (UnauthorizedException | HttpBindException e) {
            HttpBindServlet.sendLegacyError(context, BoshBindingError.internalServerError, "Server has not finished initialization.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSessionRequest(String sid, AsyncContext context, Element rootNode) throws IOException {
        HttpSession session;
        if (JiveGlobals.getBooleanProperty("log.httpbind.enabled", false)) {
            Log.info(new Date() + ": HTTP RECV(" + sid + "): " + rootNode.asXML());
        }
        if ((session = this.sessionManager.getSession(sid)) == null) {
            if (Log.isDebugEnabled()) {
                Log.debug("Client provided invalid session: " + sid + ". [" + context.getRequest().getRemoteAddr() + "]");
            }
            HttpBindServlet.sendLegacyError(context, BoshBindingError.itemNotFound, "Invalid SID value.");
            return;
        }
        long rid = HttpBindServlet.getLongAttribute(rootNode.attributeValue("rid"), -1L);
        HttpSession httpSession = session;
        synchronized (httpSession) {
            try {
                session.forwardRequest(rid, context.getRequest().isSecure(), rootNode, context);
            }
            catch (HttpBindException e) {
                this.sendError(session, context, e.getBindingError());
            }
            catch (HttpConnectionClosedException nc) {
                Log.error("Error sending packet to client.", (Throwable)nc);
                context.complete();
            }
        }
    }

    private XMPPPacketReader getPacketReader() {
        XMPPPacketReader reader = this.localReader.get();
        if (reader == null) {
            reader = new XMPPPacketReader();
            reader.setXPPFactory(factory);
            this.localReader.set(reader);
        }
        return reader;
    }

    public static void respond(HttpSession session, AsyncContext context, String content, boolean async) throws IOException {
        HttpServletResponse response = (HttpServletResponse)context.getResponse();
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        response.setStatus(200);
        response.setContentType("GET".equals(request.getMethod()) ? "text/javascript" : "text/xml");
        response.setCharacterEncoding("UTF-8");
        if ("GET".equals(request.getMethod())) {
            if (JiveGlobals.getBooleanProperty("xmpp.httpbind.client.no-cache.enabled", true)) {
                response.addHeader("Cache-Control", "no-store");
                response.addHeader("Cache-Control", "no-cache");
                response.addHeader("Pragma", "no-cache");
            }
            content = "_BOSH_(\"" + StringEscapeUtils.escapeJavaScript((String)content) + "\")";
        }
        if (JiveGlobals.getBooleanProperty("log.httpbind.enabled", false)) {
            System.out.println(new Date() + ": HTTP SENT(" + session.getStreamID().getID() + "): " + content);
        }
        byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
        response.setContentLength(byteContent.length);
        if (async) {
            response.getOutputStream().setWriteListener((WriteListener)new WriteListenerImpl(context, byteContent));
        } else {
            context.getResponse().getOutputStream().write(byteContent);
            context.getResponse().getOutputStream().flush();
            context.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError(HttpSession session, AsyncContext context, BoshBindingError bindingError) throws IOException {
        if (JiveGlobals.getBooleanProperty("log.httpbind.enabled", false)) {
            System.out.println(new Date() + ": HTTP ERR(" + session.getStreamID().getID() + "): " + bindingError.getErrorType().getType() + ", " + bindingError.getCondition() + ".");
        }
        try {
            if (session.getMajorVersion() == 1 && session.getMinorVersion() >= 6 || session.getMajorVersion() > 1) {
                String errorBody = HttpBindServlet.createErrorBody(bindingError.getErrorType().getType(), bindingError.getCondition());
                HttpBindServlet.respond(session, context, errorBody, true);
            } else {
                HttpBindServlet.sendLegacyError(context, bindingError);
            }
        }
        finally {
            if (bindingError.getErrorType() == BoshBindingError.Type.terminate) {
                session.close();
            }
        }
    }

    protected static void sendLegacyError(AsyncContext context, BoshBindingError error, String message) throws IOException {
        HttpServletResponse response = (HttpServletResponse)context.getResponse();
        if (message == null || message.trim().length() == 0) {
            response.sendError(error.getLegacyErrorCode());
        } else {
            response.sendError(error.getLegacyErrorCode(), message);
        }
        context.complete();
    }

    protected static void sendLegacyError(AsyncContext context, BoshBindingError error) throws IOException {
        HttpBindServlet.sendLegacyError(context, error, null);
    }

    protected static String createErrorBody(String type, String condition) {
        Element body = DocumentHelper.createElement((QName)QName.get((String)"body", (String)"http://jabber.org/protocol/httpbind"));
        body.addAttribute("type", type);
        body.addAttribute("condition", condition);
        return body.asXML();
    }

    protected static long getLongAttribute(String value, long defaultValue) {
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        try {
            return Long.valueOf(value);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    protected static int getIntAttribute(String value, int defaultValue) {
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    protected static String getRemoteAddress(AsyncContext context) {
        String remoteAddress = null;
        if (context.getRequest() != null && context.getRequest().getRemoteAddr() != null) {
            remoteAddress = context.getRequest().getRemoteAddr();
        }
        if (remoteAddress == null || remoteAddress.trim().length() == 0) {
            remoteAddress = "<UNKNOWN ADDRESS>";
        }
        return remoteAddress;
    }

    static {
        try {
            factory = XmlPullParserFactory.newInstance((String)MXParser.class.getName(), null);
        }
        catch (XmlPullParserException e) {
            Log.error("Error creating a parser factory", (Throwable)e);
        }
    }

    private static class WriteListenerImpl
    implements WriteListener {
        private final AsyncContext context;
        private final byte[] data;
        private final String remoteAddress;
        private volatile boolean written;

        public WriteListenerImpl(AsyncContext context, byte[] data) {
            this.context = context;
            this.data = data;
            this.remoteAddress = HttpBindServlet.getRemoteAddress(context);
        }

        public void onWritePossible() throws IOException {
            Log.trace("Data can be written to [" + this.remoteAddress + "]");
            ServletOutputStream servletOutputStream = this.context.getResponse().getOutputStream();
            while (servletOutputStream.isReady()) {
                if (!this.written) {
                    this.written = true;
                    servletOutputStream.write(this.data);
                    continue;
                }
                this.context.complete();
            }
        }

        public void onError(Throwable throwable) {
            Log.warn("Error writing response data to [" + this.remoteAddress + "]", throwable);
            this.context.complete();
        }
    }

    class ReadListenerImpl
    implements ReadListener {
        private final AsyncContext context;
        private final ByteArrayOutputStream outStream = new ByteArrayOutputStream(1024);
        private final String remoteAddress;

        ReadListenerImpl(AsyncContext context) {
            this.context = context;
            this.remoteAddress = HttpBindServlet.getRemoteAddress(context);
        }

        public void onDataAvailable() throws IOException {
            int length;
            Log.trace("Data is available to be read from [" + this.remoteAddress + "]");
            ServletInputStream inputStream = this.context.getRequest().getInputStream();
            byte[] b = new byte[1024];
            while (inputStream.isReady() && (length = inputStream.read(b)) != -1) {
                this.outStream.write(b, 0, length);
            }
        }

        public void onAllDataRead() throws IOException {
            Log.trace("All data has been read from [" + this.remoteAddress + "]");
            HttpBindServlet.this.processContent(this.context, this.outStream.toString(StandardCharsets.UTF_8.name()));
        }

        public void onError(Throwable throwable) {
            Log.warn("Error reading request data from [" + this.remoteAddress + "]", throwable);
            try {
                HttpBindServlet.sendLegacyError(this.context, BoshBindingError.badRequest);
            }
            catch (IOException ex) {
                Log.debug("Error while sending an error to [" + this.remoteAddress + "] in response to an earlier data-read failure.", (Throwable)ex);
            }
        }
    }
}

