/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import org.jivesoftware.openfire.ChannelHandler;
import org.jivesoftware.openfire.OfflineMessage;
import org.jivesoftware.openfire.OfflineMessageStore;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.PresenceManager;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.cluster.ClusterEventListener;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.handler.DirectedPresence;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class PresenceUpdateHandler
extends BasicModule
implements ChannelHandler,
ClusterEventListener {
    private static final Logger Log = LoggerFactory.getLogger(PresenceUpdateHandler.class);
    public static final String PRESENCE_CACHE_NAME = "Directed Presences";
    private Cache<String, Collection<DirectedPresence>> directedPresencesCache;
    private Map<String, Collection<DirectedPresence>> localDirectedPresences = new ConcurrentHashMap<String, Collection<DirectedPresence>>();
    private RoutingTable routingTable;
    private RosterManager rosterManager;
    private XMPPServer localServer;
    private PresenceManager presenceManager;
    private PacketDeliverer deliverer;
    private OfflineMessageStore messageStore;
    private SessionManager sessionManager;
    private UserManager userManager;

    public PresenceUpdateHandler() {
        super("Presence update handler");
    }

    public void process(Packet packet) throws UnauthorizedException, PacketException {
        this.process((Presence)packet, this.sessionManager.getSession(packet.getFrom()));
    }

    private void process(Presence presence, ClientSession session) throws UnauthorizedException, PacketException {
        try {
            Presence.Type type = presence.getType();
            if (type == null) {
                if (session != null && session.getStatus() == -1) {
                    Log.warn("Rejected available presence: " + presence + " - " + session);
                    return;
                }
                this.broadcastUpdate(presence.createCopy());
                if (session != null) {
                    session.setPresence(presence);
                    if (!session.isInitialized()) {
                        this.initSession(session);
                        session.setInitialized(true);
                    }
                }
                this.presenceManager.userAvailable(presence);
            } else if (Presence.Type.unavailable == type) {
                this.broadcastUpdate(presence.createCopy());
                this.broadcastUnavailableForDirectedPresences(presence);
                if (session != null) {
                    session.setPresence(presence);
                }
                this.presenceManager.userUnavailable(presence);
            } else {
                presence = presence.createCopy();
                if (session != null) {
                    presence.setFrom(new JID(null, session.getServerName(), null, true));
                    presence.setTo(session.getAddress());
                } else {
                    JID sender = presence.getFrom();
                    presence.setFrom(presence.getTo());
                    presence.setTo(sender);
                }
                presence.setError(PacketError.Condition.bad_request);
                this.deliverer.deliver((Packet)presence);
            }
        }
        catch (Exception e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error") + ". Triggered by packet: " + presence, (Throwable)e);
        }
    }

    public void process(Presence presence) throws PacketException {
        try {
            this.process((Packet)presence);
        }
        catch (UnauthorizedException e) {
            try {
                LocalSession session = (LocalSession)((Object)this.sessionManager.getSession(presence.getFrom()));
                presence = presence.createCopy();
                if (session != null) {
                    presence.setFrom(new JID(null, session.getServerName(), null, true));
                    presence.setTo(session.getAddress());
                } else {
                    JID sender = presence.getFrom();
                    presence.setFrom(presence.getTo());
                    presence.setTo(sender);
                }
                presence.setError(PacketError.Condition.not_authorized);
                this.deliverer.deliver((Packet)presence);
            }
            catch (Exception err) {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)err);
            }
        }
    }

    private void initSession(ClientSession session) throws UserNotFoundException {
        if (this.userManager.isRegisteredUser(session.getAddress().getNode())) {
            String username = session.getAddress().getNode();
            if (RosterManager.isRosterServiceEnabled()) {
                Roster roster = this.rosterManager.getRoster(username);
                for (RosterItem rosterItem : roster.getRosterItems()) {
                    if (rosterItem.getRecvStatus() == RosterItem.RECV_SUBSCRIBE) {
                        session.process((Packet)this.createSubscribePresence(rosterItem.getJid(), session.getAddress().asBareJID(), true));
                    } else if (rosterItem.getRecvStatus() == RosterItem.RECV_UNSUBSCRIBE) {
                        session.process((Packet)this.createSubscribePresence(rosterItem.getJid(), session.getAddress().asBareJID(), false));
                    }
                    if (rosterItem.getSubStatus() != RosterItem.SUB_TO && rosterItem.getSubStatus() != RosterItem.SUB_BOTH) continue;
                    this.presenceManager.probePresence(session.getAddress(), rosterItem.getJid());
                }
            }
            if (session.canFloodOfflineMessages()) {
                Collection<OfflineMessage> messages = this.messageStore.getMessages(username, true);
                for (Message message : messages) {
                    session.process((Packet)message);
                }
            }
        }
    }

    public Presence createSubscribePresence(JID senderAddress, JID targetJID, boolean isSubscribe) {
        Presence presence = new Presence();
        presence.setFrom(senderAddress);
        presence.setTo(targetJID);
        if (isSubscribe) {
            presence.setType(Presence.Type.subscribe);
        } else {
            presence.setType(Presence.Type.unsubscribe);
        }
        return presence;
    }

    private void broadcastUpdate(Presence update) {
        if (update.getFrom() == null) {
            return;
        }
        if (this.localServer.isLocal(update.getFrom())) {
            if (!RosterManager.isRosterServiceEnabled()) {
                return;
            }
            String name = update.getFrom().getNode();
            try {
                if (name != null && !"".equals(name)) {
                    Roster roster = this.rosterManager.getRoster(name);
                    roster.broadcastPresence(update);
                }
            }
            catch (UserNotFoundException e) {
                Log.warn("Presence being sent from unknown user " + name, (Throwable)e);
            }
            catch (PacketException e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
            }
        } else {
            Log.warn("Presence requested from server " + this.localServer.getServerInfo().getXMPPDomain() + " by unknown user: " + update.getFrom());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directedPresenceSent(Presence update, JID handlerJID, String jid) {
        block28: {
            if (update.getFrom() == null) {
                return;
            }
            if (this.localServer.isLocal(update.getFrom())) {
                boolean keepTrack = false;
                String name = update.getFrom().getNode();
                if (name != null && !"".equals(name)) {
                    if (!RosterManager.isRosterServiceEnabled()) {
                        keepTrack = true;
                    } else {
                        try {
                            Roster roster = this.rosterManager.getRoster(name);
                            RosterItem rosterItem = null;
                            try {
                                rosterItem = roster.getRosterItem(update.getTo());
                            }
                            catch (UserNotFoundException userNotFoundException) {
                                // empty catch block
                            }
                            if (rosterItem == null || RosterItem.SUB_NONE == rosterItem.getSubStatus() || RosterItem.SUB_TO == rosterItem.getSubStatus()) {
                                keepTrack = true;
                            }
                        }
                        catch (UserNotFoundException e) {
                            Log.warn("Presence being sent from unknown user " + name, (Throwable)e);
                        }
                        catch (PacketException e) {
                            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
                        }
                    }
                } else if (update.getFrom().getResource() != null) {
                    keepTrack = true;
                }
                if (keepTrack) {
                    String sender = update.getFrom().toString();
                    Lock lock = CacheFactory.getLock(sender, this.directedPresencesCache);
                    try {
                        lock.lock();
                        ConcurrentLinkedQueue<DirectedPresence> directedPresences = (ConcurrentLinkedQueue<DirectedPresence>)this.directedPresencesCache.get(sender);
                        if (Presence.Type.unavailable.equals((Object)update.getType())) {
                            if (directedPresences == null) break block28;
                            if (this.routingTable.hasClientRoute(handlerJID)) {
                                for (DirectedPresence directedPresence : directedPresences) {
                                    if (!directedPresence.getHandler().equals((Object)handlerJID)) continue;
                                    directedPresences.remove(directedPresence);
                                    break;
                                }
                            } else {
                                for (DirectedPresence directedPresence : directedPresences) {
                                    if (!directedPresence.getHandler().equals((Object)handlerJID)) continue;
                                    directedPresence.removeReceiver(jid);
                                    if (!directedPresence.isEmpty()) break;
                                    directedPresences.remove(directedPresence);
                                    break;
                                }
                            }
                            if (directedPresences.isEmpty()) {
                                this.directedPresencesCache.remove(sender);
                                this.localDirectedPresences.remove(sender);
                            } else {
                                this.directedPresencesCache.put(sender, directedPresences);
                                this.localDirectedPresences.put(sender, directedPresences);
                            }
                            break block28;
                        }
                        if (directedPresences == null) {
                            directedPresences = new ConcurrentLinkedQueue<DirectedPresence>();
                        }
                        DirectedPresence affectedDirectedPresence = null;
                        for (DirectedPresence directedPresence : directedPresences) {
                            if (!directedPresence.getHandler().equals((Object)handlerJID)) continue;
                            affectedDirectedPresence = directedPresence;
                            break;
                        }
                        if (affectedDirectedPresence == null) {
                            affectedDirectedPresence = new DirectedPresence(handlerJID);
                            directedPresences.add(affectedDirectedPresence);
                        }
                        affectedDirectedPresence.addReceiver(jid);
                        this.directedPresencesCache.put(sender, directedPresences);
                        this.localDirectedPresences.put(sender, directedPresences);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastUnavailableForDirectedPresences(Presence update) {
        JID from = update.getFrom();
        if (from == null) {
            return;
        }
        if (this.localServer.isLocal(from)) {
            Collection directedPresences = null;
            Lock lock = CacheFactory.getLock(from.toString(), this.directedPresencesCache);
            try {
                lock.lock();
                directedPresences = (Collection)this.directedPresencesCache.remove(from.toString());
            }
            finally {
                lock.unlock();
            }
            if (directedPresences != null) {
                for (DirectedPresence directedPresence : directedPresences) {
                    for (String receiver : directedPresence.getReceivers()) {
                        Presence presence = update.createCopy();
                        presence.setTo(receiver);
                        this.localServer.getPresenceRouter().route(presence);
                    }
                }
                this.localDirectedPresences.remove(from.toString());
            }
        }
    }

    public boolean hasDirectPresence(JID ownerJID, JID recipientJID) {
        if (recipientJID == null) {
            return false;
        }
        Collection directedPresences = (Collection)this.directedPresencesCache.get(ownerJID.toString());
        if (directedPresences != null) {
            String recipient = recipientJID.toBareJID();
            for (DirectedPresence directedPresence : directedPresences) {
                for (String receiver : directedPresence.getReceivers()) {
                    if (!receiver.contains(recipient)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void removedExpiredPresences() {
        HashMap<String, Collection<DirectedPresence>> copy = new HashMap<String, Collection<DirectedPresence>>(this.localDirectedPresences);
        for (Map.Entry entry : copy.entrySet()) {
            for (DirectedPresence directedPresence : (Collection)entry.getValue()) {
                if (this.routingTable.hasClientRoute(directedPresence.getHandler()) || this.routingTable.hasComponentRoute(directedPresence.getHandler())) continue;
                Collection<DirectedPresence> presences = this.localDirectedPresences.get(entry.getKey());
                presences.remove(directedPresence);
                if (!presences.isEmpty()) continue;
                this.localDirectedPresences.remove(entry.getKey());
            }
        }
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.localServer = server;
        this.rosterManager = server.getRosterManager();
        this.presenceManager = server.getPresenceManager();
        this.deliverer = server.getPacketDeliverer();
        this.messageStore = server.getOfflineMessageStore();
        this.sessionManager = server.getSessionManager();
        this.userManager = server.getUserManager();
        this.routingTable = server.getRoutingTable();
        this.directedPresencesCache = CacheFactory.createCache(PRESENCE_CACHE_NAME);
        ClusterManager.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void joinedCluster() {
        for (Map.Entry<String, Collection<DirectedPresence>> entry : this.localDirectedPresences.entrySet()) {
            if (entry.getValue().isEmpty()) {
                Log.warn("PresenceUpdateHandler - Skipping empty directed presences when joining cluster for sender: " + entry.getKey());
                continue;
            }
            Lock lock = CacheFactory.getLock(entry.getKey(), this.directedPresencesCache);
            try {
                lock.lock();
                this.directedPresencesCache.put(entry.getKey(), entry.getValue());
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void joinedCluster(byte[] nodeID) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leftCluster() {
        if (!XMPPServer.getInstance().isShuttingDown()) {
            for (Map.Entry<String, Collection<DirectedPresence>> entry : this.localDirectedPresences.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    Log.warn("PresenceUpdateHandler - Skipping empty directed presences when leaving cluster for sender: " + entry.getKey());
                    continue;
                }
                Lock lock = CacheFactory.getLock(entry.getKey(), this.directedPresencesCache);
                try {
                    lock.lock();
                    this.directedPresencesCache.put(entry.getKey(), entry.getValue());
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @Override
    public void leftCluster(byte[] nodeID) {
    }

    @Override
    public void markedAsSeniorClusterMember() {
    }
}

