/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import java.util.Collection;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.roster.RosterManager;
import org.xmpp.packet.IQ;
import org.xmpp.packet.PacketError;

public class IQSharedGroupHandler
extends IQHandler {
    private IQHandlerInfo info = new IQHandlerInfo("sharedgroup", "http://www.jivesoftware.org/protocol/sharedgroup");
    private String serverName;
    private RosterManager rosterManager;

    public IQSharedGroupHandler() {
        super("Shared Groups Handler");
    }

    @Override
    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        IQ result = IQ.createResultIQ((IQ)packet);
        String username = packet.getFrom().getNode();
        if (!this.serverName.equals(packet.getFrom().getDomain()) || username == null) {
            result.setChildElement(packet.getChildElement().createCopy());
            result.setError(PacketError.Condition.not_allowed);
            return result;
        }
        Collection<Group> groups = this.rosterManager.getSharedGroups(username);
        Element sharedGroups = result.setChildElement("sharedgroup", "http://www.jivesoftware.org/protocol/sharedgroup");
        for (Group sharedGroup : groups) {
            String displayName = (String)sharedGroup.getProperties().get("sharedRoster.displayName");
            if (displayName == null) continue;
            sharedGroups.addElement("group").setText(displayName);
        }
        return result;
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.serverName = server.getServerInfo().getXMPPDomain();
        this.rosterManager = server.getRosterManager();
    }
}

