/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import gnu.inet.encoding.IDNAException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.SharedGroupException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.roster.RosterItem;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Roster;

public class IQRosterHandler
extends IQHandler
implements ServerFeaturesProvider {
    private static final Logger Log = LoggerFactory.getLogger(IQRosterHandler.class);
    private IQHandlerInfo info = new IQHandlerInfo("query", "jabber:iq:roster");
    private UserManager userManager;
    private XMPPServer localServer;
    private PacketRouter router;

    public IQRosterHandler() {
        super("XMPP Roster Handler");
    }

    @Override
    public IQ handleIQ(IQ packet) throws UnauthorizedException, PacketException {
        try {
            IQ returnPacket;
            org.xmpp.packet.Roster roster = (org.xmpp.packet.Roster)packet;
            JID recipientJID = packet.getTo();
            if (recipientJID == null || recipientJID.equals((Object)packet.getFrom().asBareJID())) {
                returnPacket = this.manageRoster(roster);
            } else {
                returnPacket = IQ.createResultIQ((IQ)packet);
                returnPacket.setError(PacketError.Condition.forbidden);
            }
            return returnPacket;
        }
        catch (SharedGroupException e) {
            IQ result = IQ.createResultIQ((IQ)packet);
            result.setChildElement(packet.getChildElement().createCopy());
            result.setError(PacketError.Condition.not_acceptable);
            return result;
        }
        catch (Exception e) {
            if (e.getCause() instanceof IDNAException || e.getCause() instanceof IllegalArgumentException) {
                Log.warn(LocaleUtils.getLocalizedString("admin.error") + e.getMessage());
                IQ result = IQ.createResultIQ((IQ)packet);
                result.setChildElement(packet.getChildElement().createCopy());
                result.setError(PacketError.Condition.jid_malformed);
                return result;
            }
            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
            IQ result = IQ.createResultIQ((IQ)packet);
            result.setChildElement(packet.getChildElement().createCopy());
            result.setError(PacketError.Condition.internal_server_error);
            return result;
        }
    }

    private IQ manageRoster(org.xmpp.packet.Roster packet) throws UnauthorizedException, UserAlreadyExistsException, SharedGroupException {
        org.xmpp.packet.Roster returnPacket = null;
        JID sender = packet.getFrom();
        IQ.Type type = packet.getType();
        try {
            if (!(sender.getNode() != null && RosterManager.isRosterServiceEnabled() && this.userManager.isRegisteredUser(sender.getNode()) || IQ.Type.get != type)) {
                IQ reply = IQ.createResultIQ((IQ)packet);
                reply.setChildElement("query", "jabber:iq:roster");
                return reply;
            }
            if (!this.localServer.isLocal(sender)) {
                Log.warn("Discarding IQ roster packet of remote user: " + packet);
                return null;
            }
            Roster cachedRoster = this.userManager.getUser(sender.getNode()).getRoster();
            if (IQ.Type.get == type) {
                if (RosterManager.isRosterVersioningEnabled()) {
                    String clientVersion = packet.getChildElement().attributeValue("ver");
                    String latestVersion = String.valueOf(cachedRoster.hashCode());
                    if (!latestVersion.equals(clientVersion)) {
                        returnPacket = cachedRoster.getReset();
                        returnPacket.getChildElement().addAttribute("ver", latestVersion);
                    } else {
                        returnPacket = new IQ();
                    }
                } else {
                    returnPacket = cachedRoster.getReset();
                }
                returnPacket.setType(IQ.Type.result);
                returnPacket.setTo(sender);
                returnPacket.setID(packet.getID());
                this.deliverer.deliver((Packet)returnPacket);
                returnPacket = null;
            } else if (IQ.Type.set == type) {
                returnPacket = IQ.createResultIQ((IQ)packet);
                if (packet.getItems().size() > 1) {
                    returnPacket.setError(new PacketError(PacketError.Condition.bad_request, PacketError.Type.modify, "Query contains more than one item"));
                } else {
                    for (Roster.Item item : packet.getItems()) {
                        if (item.getSubscription() == Roster.Subscription.remove) {
                            if (this.removeItem(cachedRoster, packet.getFrom(), item) != null) continue;
                            returnPacket.setError(PacketError.Condition.item_not_found);
                            continue;
                        }
                        PacketError error = IQRosterHandler.checkGroups(item.getGroups());
                        if (error != null) {
                            returnPacket.setError(error);
                            continue;
                        }
                        if (cachedRoster.isRosterItem(item.getJID())) {
                            RosterItem cachedItem = cachedRoster.getRosterItem(item.getJID());
                            cachedItem.setAsCopyOf(item);
                            cachedRoster.updateRosterItem(cachedItem);
                            continue;
                        }
                        cachedRoster.createRosterItem(item);
                    }
                }
            }
        }
        catch (UserNotFoundException e) {
            throw new UnauthorizedException(e);
        }
        return returnPacket;
    }

    private static PacketError checkGroups(Iterable<String> groups) {
        HashSet<String> set = new HashSet<String>();
        for (String group : groups) {
            if (!set.add(group)) {
                return new PacketError(PacketError.Condition.bad_request, PacketError.Type.modify, "Item contains duplicate groups");
            }
            if (!group.isEmpty()) continue;
            return new PacketError(PacketError.Condition.not_acceptable, PacketError.Type.modify, "Group is of zero length");
        }
        return null;
    }

    private RosterItem removeItem(Roster roster, JID sender, Roster.Item item) throws SharedGroupException {
        RosterItem removedItem;
        block6: {
            JID recipient = item.getJID();
            removedItem = roster.deleteRosterItem(item.getJID(), true);
            if (this.localServer.isLocal(recipient)) {
                try {
                    Roster recipientRoster = this.userManager.getUser(recipient.getNode()).getRoster();
                    RosterItem rosterItem = recipientRoster.getRosterItem(sender);
                    if (rosterItem.getRecvStatus().equals((Object)RosterItem.RECV_SUBSCRIBE)) {
                        recipientRoster.deleteRosterItem(sender, true);
                        break block6;
                    }
                    rosterItem.setAskStatus(RosterItem.ASK_NONE);
                    rosterItem.setRecvStatus(RosterItem.RECV_NONE);
                    rosterItem.setSubStatus(RosterItem.SUB_NONE);
                    recipientRoster.updateRosterItem(rosterItem);
                }
                catch (UserNotFoundException recipientRoster) {}
            } else {
                String serverDomain = this.localServer.getServerInfo().getXMPPDomain();
                if (recipient.getDomain().contains(serverDomain)) {
                    Packet removePacket = this.createRemoveForward(sender, recipient);
                    this.router.route(removePacket);
                }
            }
        }
        return removedItem;
    }

    private Packet createRemoveForward(JID from, JID to) {
        org.xmpp.packet.Roster response = new org.xmpp.packet.Roster(IQ.Type.set);
        response.setFrom(from);
        response.setTo(to);
        response.addItem(from, Roster.Subscription.remove);
        return response;
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.localServer = server;
        this.userManager = server.getUserManager();
        this.router = server.getPacketRouter();
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public Iterator<String> getFeatures() {
        return Collections.singleton("jabber:iq:roster").iterator();
    }
}

