/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.event.UserEventListener;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.privacy.PrivacyList;
import org.jivesoftware.openfire.privacy.PrivacyListManager;
import org.jivesoftware.openfire.privacy.PrivacyListProvider;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;

public class IQPrivacyHandler
extends IQHandler
implements ServerFeaturesProvider,
UserEventListener {
    private IQHandlerInfo info;
    private PrivacyListManager manager = PrivacyListManager.getInstance();
    private PrivacyListProvider provider = PrivacyListProvider.getInstance();

    public IQPrivacyHandler() {
        super("Blocking Communication Handler");
        this.info = new IQHandlerInfo("query", "jabber:iq:privacy");
    }

    @Override
    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        IQ.Type type = packet.getType();
        JID from = packet.getFrom();
        if (from.getNode() == null || !UserManager.getInstance().isRegisteredUser(from.getNode())) {
            IQ result = IQ.createResultIQ((IQ)packet);
            result.setChildElement(packet.getChildElement().createCopy());
            result.setError(PacketError.Condition.service_unavailable);
            return result;
        }
        IQ result = null;
        if (type.equals((Object)IQ.Type.get)) {
            Element child = packet.getChildElement();
            List elements = child.elements();
            result = elements.isEmpty() ? this.getPrivacyListsNames(packet, from) : this.getPrivacyList(packet, from);
        } else if (type.equals((Object)IQ.Type.set)) {
            Element child = packet.getChildElement();
            Element activeList = child.element("active");
            Element defaultList = child.element("default");
            if (activeList != null) {
                String listName = activeList.attributeValue("name");
                result = listName != null ? this.setActiveList(packet, from, listName) : this.declineActiveList(packet, from);
            } else if (defaultList != null) {
                String listName = defaultList.attributeValue("name");
                result = listName != null ? this.setDefaultList(packet, from, listName) : this.declineDefaultList(packet, from);
            } else {
                Element list = child.element("list");
                String listName = list.attributeValue("name");
                List items = list.elements();
                result = !items.isEmpty() ? this.updateOrCreateList(packet, from, list) : this.deleteList(packet, from, listName);
            }
        }
        return result;
    }

    private IQ getPrivacyListsNames(IQ packet, JID from) {
        IQ result = IQ.createResultIQ((IQ)packet);
        Element childElement = packet.getChildElement().createCopy();
        result.setChildElement(childElement);
        Map<String, Boolean> privacyLists = this.provider.getPrivacyLists(from.getNode());
        for (String listName : privacyLists.keySet()) {
            if (!privacyLists.get(listName).booleanValue()) continue;
            childElement.addElement("default").addAttribute("name", listName);
        }
        ClientSession session = this.sessionManager.getSession(from);
        if (session != null && session.getActiveList() != null) {
            childElement.addElement("active").addAttribute("name", session.getActiveList().getName());
        }
        for (String listName : privacyLists.keySet()) {
            childElement.addElement("list").addAttribute("name", listName);
        }
        return result;
    }

    private IQ getPrivacyList(IQ packet, JID from) {
        IQ result = IQ.createResultIQ((IQ)packet);
        Element childElement = packet.getChildElement().createCopy();
        result.setChildElement(childElement);
        List lists = childElement.elements("list");
        if (lists.size() > 1) {
            result.setError(PacketError.Condition.bad_request);
        } else {
            String listName = ((Element)lists.get(0)).attributeValue("name");
            PrivacyList list = null;
            if (listName != null) {
                list = this.manager.getPrivacyList(from.getNode(), listName);
            }
            if (list != null) {
                childElement = result.setChildElement("query", "jabber:iq:privacy");
                childElement.add(list.asElement());
            } else {
                result.setError(PacketError.Condition.item_not_found);
            }
        }
        return result;
    }

    private IQ setActiveList(IQ packet, JID from, String listName) {
        IQ result = IQ.createResultIQ((IQ)packet);
        Element childElement = packet.getChildElement().createCopy();
        result.setChildElement(childElement);
        PrivacyList list = this.manager.getPrivacyList(from.getNode(), listName);
        if (list != null) {
            ClientSession session = this.sessionManager.getSession(from);
            if (session != null) {
                session.setActiveList(list);
            }
        } else {
            result.setError(PacketError.Condition.item_not_found);
        }
        return result;
    }

    private IQ declineActiveList(IQ packet, JID from) {
        ClientSession session = this.sessionManager.getSession(from);
        session.setActiveList(null);
        return IQ.createResultIQ((IQ)packet);
    }

    private IQ setDefaultList(IQ packet, JID from, String listName) {
        IQ result = IQ.createResultIQ((IQ)packet);
        Element childElement = packet.getChildElement().createCopy();
        result.setChildElement(childElement);
        if (this.sessionManager.getSessionCount(from.getNode()) > 1) {
            result.setError(PacketError.Condition.conflict);
        } else {
            PrivacyList list = this.manager.getPrivacyList(from.getNode(), listName);
            if (list != null) {
                ClientSession session = this.sessionManager.getSession(from);
                PrivacyList oldDefaultList = session.getDefaultList();
                this.manager.changeDefaultList(from.getNode(), list, oldDefaultList);
                session.setDefaultList(list);
            } else {
                result.setError(PacketError.Condition.item_not_found);
            }
        }
        return result;
    }

    private IQ declineDefaultList(IQ packet, JID from) {
        IQ result = IQ.createResultIQ((IQ)packet);
        Element childElement = packet.getChildElement().createCopy();
        result.setChildElement(childElement);
        if (this.sessionManager.getSessionCount(from.getNode()) > 1) {
            result.setError(PacketError.Condition.conflict);
        } else {
            ClientSession session = this.sessionManager.getSession(from);
            if (session.getDefaultList() != null) {
                session.getDefaultList().setDefaultList(false);
                this.provider.updatePrivacyList(from.getNode(), session.getDefaultList());
                session.setDefaultList(null);
            }
        }
        return result;
    }

    private IQ updateOrCreateList(IQ packet, JID from, Element listElement) {
        IQ result = IQ.createResultIQ((IQ)packet);
        Element childElement = packet.getChildElement().createCopy();
        result.setChildElement(childElement);
        String listName = listElement.attributeValue("name");
        PrivacyList list = this.manager.getPrivacyList(from.getNode(), listName);
        if (list == null) {
            list = this.manager.createPrivacyList(from.getNode(), listName, listElement);
        } else {
            list.updateList(listElement);
            this.provider.updatePrivacyList(from.getNode(), list);
            for (ClientSession session : this.sessionManager.getSessions(from.getNode())) {
                if (list.equals(session.getDefaultList())) {
                    session.setDefaultList(list);
                }
                if (!list.equals(session.getActiveList())) continue;
                session.setActiveList(list);
            }
        }
        IQ pushPacket = new IQ(IQ.Type.set);
        Element child = pushPacket.setChildElement("query", "jabber:iq:privacy");
        child.addElement("list").addAttribute("name", list.getName());
        this.sessionManager.userBroadcast(from.getNode(), (Packet)pushPacket);
        return result;
    }

    private IQ deleteList(IQ packet, JID from, String listName) {
        IQ result = IQ.createResultIQ((IQ)packet);
        Element childElement = packet.getChildElement().createCopy();
        result.setChildElement(childElement);
        PrivacyList list = this.manager.getPrivacyList(from.getNode(), listName);
        if (list == null) {
            result.setError(PacketError.Condition.item_not_found);
            return result;
        }
        ClientSession currentSession = this.sessionManager.getSession(from);
        for (ClientSession session : this.sessionManager.getSessions(from.getNode())) {
            if (currentSession == session || !list.equals(session.getDefaultList()) && !list.equals(session.getActiveList())) continue;
            result.setError(PacketError.Condition.conflict);
            return result;
        }
        if (list.equals(currentSession.getDefaultList())) {
            currentSession.setDefaultList(null);
        }
        if (list.equals(currentSession.getActiveList())) {
            currentSession.setActiveList(null);
        }
        this.manager.deletePrivacyList(from.getNode(), listName);
        return result;
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public Iterator<String> getFeatures() {
        return Collections.singleton("jabber:iq:privacy").iterator();
    }

    public void userCreated(User user, Map params) {
    }

    public void userDeleting(User user, Map params) {
        this.manager.deletePrivacyLists(user.getUsername());
    }

    public void userModified(User user, Map params) {
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
    }
}

