/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.OfflineMessage;
import org.jivesoftware.openfire.OfflineMessageStore;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.disco.DiscoInfoProvider;
import org.jivesoftware.openfire.disco.DiscoItem;
import org.jivesoftware.openfire.disco.DiscoItemsProvider;
import org.jivesoftware.openfire.disco.IQDiscoInfoHandler;
import org.jivesoftware.openfire.disco.IQDiscoItemsHandler;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;

public class IQOfflineMessagesHandler
extends IQHandler
implements ServerFeaturesProvider,
DiscoInfoProvider,
DiscoItemsProvider {
    private static final Logger Log = LoggerFactory.getLogger(IQOfflineMessagesHandler.class);
    private static final String NAMESPACE = "http://jabber.org/protocol/offline";
    private final XMPPDateTimeFormat xmppDateTime = new XMPPDateTimeFormat();
    private IQHandlerInfo info = new IQHandlerInfo("offline", "http://jabber.org/protocol/offline");
    private IQDiscoInfoHandler infoHandler;
    private IQDiscoItemsHandler itemsHandler;
    private RoutingTable routingTable;
    private UserManager userManager;
    private OfflineMessageStore messageStore;

    public IQOfflineMessagesHandler() {
        super("Flexible Offline Message Retrieval Handler");
    }

    @Override
    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element offlineRequest = packet.getChildElement();
        JID from = packet.getFrom();
        if (offlineRequest.element("purge") != null) {
            this.messageStore.deleteMessages(from.getNode());
        } else if (offlineRequest.element("fetch") != null) {
            this.stopOfflineFlooding(from);
            for (OfflineMessage offlineMessage : this.messageStore.getMessages(from.getNode(), false)) {
                this.sendOfflineMessage(from, offlineMessage);
            }
        } else {
            Iterator it = offlineRequest.elementIterator("item");
            while (it.hasNext()) {
                Element item = (Element)it.next();
                Date creationDate = null;
                try {
                    creationDate = this.xmppDateTime.parseString(item.attributeValue("node"));
                }
                catch (ParseException e) {
                    Log.error("Error parsing date", (Throwable)e);
                }
                if ("view".equals(item.attributeValue("action"))) {
                    OfflineMessage offlineMsg = this.messageStore.getMessage(from.getNode(), creationDate);
                    if (offlineMsg == null) continue;
                    this.sendOfflineMessage(from, offlineMsg);
                    continue;
                }
                if (!"remove".equals(item.attributeValue("action"))) continue;
                if (this.messageStore.getMessage(from.getNode(), creationDate) != null) {
                    this.messageStore.deleteMessage(from.getNode(), creationDate);
                    continue;
                }
                reply.setError(PacketError.Condition.item_not_found);
            }
        }
        return reply;
    }

    private void sendOfflineMessage(JID receipient, OfflineMessage offlineMessage) {
        Element offlineInfo = offlineMessage.addChildElement("offline", NAMESPACE);
        offlineInfo.addElement("item").addAttribute("node", XMPPDateTimeFormat.format(offlineMessage.getCreationDate()));
        this.routingTable.routePacket(receipient, (Packet)offlineMessage, true);
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public Iterator<String> getFeatures() {
        return Collections.singleton(NAMESPACE).iterator();
    }

    @Override
    public Iterator<Element> getIdentities(String name, String node, JID senderJID) {
        Element identity = DocumentHelper.createElement((String)"identity");
        identity.addAttribute("category", "automation");
        identity.addAttribute("type", "message-list");
        return Collections.singleton(identity).iterator();
    }

    @Override
    public Iterator<String> getFeatures(String name, String node, JID senderJID) {
        return Collections.singleton(NAMESPACE).iterator();
    }

    @Override
    public DataForm getExtendedInfo(String name, String node, JID senderJID) {
        this.stopOfflineFlooding(senderJID);
        DataForm dataForm = new DataForm(DataForm.Type.result);
        FormField field1 = dataForm.addField();
        field1.setVariable("FORM_TYPE");
        field1.setType(FormField.Type.hidden);
        field1.addValue((Object)NAMESPACE);
        FormField field2 = dataForm.addField();
        field2.setVariable("number_of_messages");
        field2.addValue((Object)String.valueOf(this.messageStore.getMessages(senderJID.getNode(), false).size()));
        return dataForm;
    }

    @Override
    public boolean hasInfo(String name, String node, JID senderJID) {
        return NAMESPACE.equals(node) && this.userManager.isRegisteredUser(senderJID.getNode());
    }

    @Override
    public Iterator<DiscoItem> getItems(String name, String node, JID senderJID) {
        this.stopOfflineFlooding(senderJID);
        ArrayList<DiscoItem> answer = new ArrayList<DiscoItem>();
        for (OfflineMessage offlineMessage : this.messageStore.getMessages(senderJID.getNode(), false)) {
            answer.add(new DiscoItem(senderJID.asBareJID(), offlineMessage.getFrom().toString(), XMPPDateTimeFormat.format(offlineMessage.getCreationDate()), null));
        }
        return answer.iterator();
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.infoHandler = server.getIQDiscoInfoHandler();
        this.itemsHandler = server.getIQDiscoItemsHandler();
        this.messageStore = server.getOfflineMessageStore();
        this.userManager = server.getUserManager();
        this.routingTable = server.getRoutingTable();
    }

    @Override
    public void start() throws IllegalStateException {
        super.start();
        this.infoHandler.setServerNodeInfoProvider(NAMESPACE, this);
        this.itemsHandler.setServerNodeInfoProvider(NAMESPACE, this);
    }

    @Override
    public void stop() {
        super.stop();
        this.infoHandler.removeServerNodeInfoProvider(NAMESPACE);
        this.itemsHandler.removeServerNodeInfoProvider(NAMESPACE);
    }

    private void stopOfflineFlooding(JID senderJID) {
        LocalClientSession session = (LocalClientSession)this.sessionManager.getSession(senderJID);
        if (session != null) {
            session.setOfflineFloodStopped(true);
        }
    }
}

