/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.handler.IQHandler;
import org.xmpp.packet.IQ;

public final class IQEntityTimeHandler
extends IQHandler
implements ServerFeaturesProvider {
    private final IQHandlerInfo info = new IQHandlerInfo("time", "urn:xmpp:time");

    public IQEntityTimeHandler() {
        super("XEP-0202: Entity Time");
    }

    @Override
    public IQ handleIQ(IQ packet) {
        IQ response = IQ.createResultIQ((IQ)packet);
        Element timeElement = DocumentHelper.createElement((QName)QName.get((String)this.info.getName(), (String)this.info.getNamespace()));
        timeElement.addElement("tzo").setText(this.formatsTimeZone(TimeZone.getDefault()));
        timeElement.addElement("utc").setText(this.getUtcDate(new Date()));
        response.setChildElement(timeElement);
        return response;
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public Iterator<String> getFeatures() {
        return Collections.singleton(this.info.getNamespace()).iterator();
    }

    String formatsTimeZone(TimeZone tz) {
        int seconds = Math.abs(tz.getOffset(System.currentTimeMillis())) / 1000;
        int hours = seconds / 3600;
        int minutes = seconds % 3600 / 60;
        return (tz.getRawOffset() < 0 ? "-" : "+") + String.format("%02d:%02d", hours, minutes);
    }

    String getUtcDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        calendar.setTime(date);
        return DatatypeConverter.printDateTime((Calendar)calendar);
    }
}

