/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.group;

import java.nio.charset.StandardCharsets;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class GroupJID
extends JID {
    private static final Logger Log = LoggerFactory.getLogger(GroupJID.class);
    private static final long serialVersionUID = 5681300465012974014L;
    private transient String groupName;

    public GroupJID(String name) {
        super(GroupJID.encodeNode(name), XMPPServer.getInstance().getServerInfo().getXMPPDomain(), StringUtils.hash(name), true);
        this.groupName = name;
    }

    private GroupJID(JID source) {
        super(source.getNode(), source.getDomain(), source.getResource(), true);
    }

    public String getGroupName() {
        if (this.groupName == null) {
            this.groupName = GroupJID.decodeNode(this.getNode());
        }
        return this.groupName;
    }

    public JID asBareJID() {
        return this;
    }

    public String toBareJID() {
        return this.toString();
    }

    public int compareTo(JID jid) {
        int compare = this.getDomain().compareTo(jid.getDomain());
        if (compare == 0) {
            String otherNode = jid.getNode();
            int n = compare = otherNode == null ? 1 : this.getGroupName().compareTo(otherNode);
        }
        if (compare == 0) {
            compare = jid.getResource() == null ? 0 : -1;
        }
        return compare;
    }

    private static String encodeNode(String name) {
        return StringUtils.encodeBase32(name);
    }

    private static String decodeNode(String node) {
        return new String(StringUtils.decodeBase32(node), StandardCharsets.UTF_8);
    }

    public static boolean isGroup(JID jid) {
        try {
            return GroupJID.isGroup(jid, false);
        }
        catch (GroupNotFoundException gnfe) {
            Log.error("Unexpected group validation", (Throwable)gnfe);
            return false;
        }
    }

    public static boolean isGroup(JID jid, boolean groupMustExist) throws GroupNotFoundException {
        boolean isGroup = false;
        String groupName = null;
        String node = jid.getNode();
        if (node != null) {
            boolean bl = jid instanceof GroupJID ? true : (isGroup = jid.getResource() != null && StringUtils.isBase32(node) && StringUtils.hash(groupName = GroupJID.decodeNode(node)).equals(jid.getResource()));
            if (isGroup && groupMustExist) {
                Log.debug("Validating group: " + jid);
                if (XMPPServer.getInstance().isLocal(jid)) {
                    GroupManager.getInstance().getGroup(groupName);
                } else {
                    isGroup = false;
                }
            }
        }
        return isGroup;
    }

    public static JID fromJID(JID jid) {
        if (jid instanceof GroupJID || jid.getResource() == null || jid.getNode() == null) {
            return jid;
        }
        return GroupJID.isGroup(jid) ? new GroupJID(jid) : jid;
    }

    public static JID fromString(String jid) {
        Log.debug("Parsing JID from string: " + jid);
        return GroupJID.fromJID(new JID(jid));
    }
}

