/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.group;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAwareList;
import org.xmpp.packet.JID;

public class ConcurrentGroupList<T>
extends CopyOnWriteArrayList<T>
implements GroupAwareList<T> {
    private static final long serialVersionUID = 7735849143650412115L;
    private volatile transient Set<String> knownGroupNamesInList;
    private static final boolean ADD = true;
    private static final boolean REMOVE = false;

    public ConcurrentGroupList() {
    }

    public ConcurrentGroupList(Collection<? extends T> c) {
        super(c);
    }

    @Override
    public boolean includes(Object value) {
        boolean found = false;
        if (this.contains(value)) {
            found = true;
        } else if (value instanceof JID) {
            JID target = (JID)value;
            Iterator<Group> iterator = this.getGroups().iterator();
            while (!found && iterator.hasNext()) {
                found = iterator.next().isUser(target);
            }
        }
        return found;
    }

    @Override
    public Set<Group> getGroups() {
        HashSet<Group> result = new HashSet<Group>();
        for (String groupName : this.getKnownGroupNamesInList()) {
            result.add(Group.resolveFrom(groupName));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getKnownGroupNamesInList() {
        Set<String> result = this.knownGroupNamesInList;
        if (result == null) {
            ConcurrentGroupList concurrentGroupList = this;
            synchronized (concurrentGroupList) {
                result = this.knownGroupNamesInList;
                if (result == null) {
                    result = new HashSet<String>();
                    for (Object listItem : this) {
                        Group group = Group.resolveFrom(listItem);
                        if (group == null) continue;
                        result.add(group.getName());
                    }
                    this.knownGroupNamesInList = result.isEmpty() ? null : result;
                }
            }
        }
        return result;
    }

    private synchronized boolean syncGroups(Object item, boolean addOrRemove) {
        Group group;
        boolean result = false;
        if (this.knownGroupNamesInList != null && (group = Group.resolveFrom(item)) != null) {
            result = true;
            if (addOrRemove) {
                this.knownGroupNamesInList.add(group.getName());
            } else if (!addOrRemove) {
                this.knownGroupNamesInList.remove(group.getName());
                if (this.knownGroupNamesInList.isEmpty()) {
                    this.knownGroupNamesInList = null;
                }
            }
        }
        return result;
    }

    @Override
    public T set(int index, T element) {
        T result = super.set(index, element);
        this.syncGroups(element, true);
        return result;
    }

    @Override
    public boolean add(T e) {
        boolean result = super.add(e);
        this.syncGroups(e, true);
        return result;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        this.syncGroups(element, true);
    }

    @Override
    public T remove(int index) {
        Object result = super.remove(index);
        this.syncGroups(result, false);
        return (T)result;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = super.remove(o);
        if (removed) {
            this.syncGroups(o, false);
        }
        return removed;
    }

    @Override
    public boolean addIfAbsent(T e) {
        boolean added = super.addIfAbsent(e);
        if (added) {
            this.syncGroups(e, true);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = super.removeAll(c);
        if (changed) {
            ConcurrentGroupList concurrentGroupList = this;
            synchronized (concurrentGroupList) {
                this.knownGroupNamesInList = null;
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = super.retainAll(c);
        if (changed) {
            ConcurrentGroupList concurrentGroupList = this;
            synchronized (concurrentGroupList) {
                this.knownGroupNamesInList = null;
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addAllAbsent(Collection<? extends T> c) {
        int added = super.addAllAbsent(c);
        if (added > 0) {
            ConcurrentGroupList concurrentGroupList = this;
            synchronized (concurrentGroupList) {
                this.knownGroupNamesInList = null;
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        super.clear();
        ConcurrentGroupList concurrentGroupList = this;
        synchronized (concurrentGroupList) {
            this.knownGroupNamesInList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = super.addAll(c);
        if (changed) {
            ConcurrentGroupList concurrentGroupList = this;
            synchronized (concurrentGroupList) {
                this.knownGroupNamesInList = null;
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean changed = super.addAll(index, c);
        if (changed) {
            ConcurrentGroupList concurrentGroupList = this;
            synchronized (concurrentGroupList) {
                this.knownGroupNamesInList = null;
            }
        }
        return changed;
    }
}

