/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.entitycaps;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.util.cache.CacheSizes;
import org.jivesoftware.util.cache.Cacheable;
import org.jivesoftware.util.cache.CannotCalculateSizeException;
import org.jivesoftware.util.cache.ExternalizableUtil;

public class EntityCapabilities
implements Cacheable,
Externalizable {
    private Set<String> identities = new HashSet<String>();
    private Set<String> features = new HashSet<String>();
    private String verAttribute;
    private String hashAttribute;

    boolean addIdentity(String identity) {
        return this.identities.add(identity);
    }

    boolean addFeature(String feature) {
        return this.features.add(feature);
    }

    public boolean containsIdentity(String category, String type) {
        return this.identities.contains(category + "/" + type);
    }

    public boolean containsFeature(String feature) {
        return this.features.contains(feature);
    }

    void setVerAttribute(String verAttribute) {
        this.verAttribute = verAttribute;
    }

    String getVerAttribute() {
        return this.verAttribute;
    }

    void setHashAttribute(String hashAttribute) {
        this.hashAttribute = hashAttribute;
    }

    String getHashAttribute() {
        return this.hashAttribute;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ExternalizableUtil.getInstance().readStrings(in, this.identities);
        ExternalizableUtil.getInstance().readStrings(in, this.features);
        this.verAttribute = ExternalizableUtil.getInstance().readSafeUTF(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeStrings(out, this.identities);
        ExternalizableUtil.getInstance().writeStrings(out, this.features);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.verAttribute);
    }

    @Override
    public int getCachedSize() throws CannotCalculateSizeException {
        int size = CacheSizes.sizeOfCollection(this.identities);
        size += CacheSizes.sizeOfCollection(this.features);
        return size += CacheSizes.sizeOfString(this.verAttribute);
    }
}

