/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.disco;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.xmpp.packet.JID;
import org.xmpp.resultsetmanagement.Result;

public class DiscoItem
implements Result {
    private final JID jid;
    private final String name;
    private final String node;
    private final String action;
    private final Element element;
    private volatile String uid = null;

    public DiscoItem(Element element) {
        this.element = element;
        this.jid = new JID(element.attributeValue("jid"));
        this.action = element.attributeValue("action");
        this.name = element.attributeValue("name");
        this.node = element.attributeValue("node");
    }

    public DiscoItem(JID jid, String name, String node, String action) {
        if (jid == null) {
            throw new IllegalArgumentException("Argument 'jid' cannot be null.");
        }
        if (action != null && !action.equals("update") && !action.equals("remove")) {
            throw new IllegalArgumentException("Argument 'jid' cannot have any other value than null, \"update\" or \"remove\".");
        }
        this.jid = jid;
        this.name = name;
        this.node = node;
        this.action = action;
        this.element = DocumentHelper.createElement((String)"item");
        this.element.addAttribute("jid", jid.toString());
        if (action != null) {
            this.element.addAttribute("action", action);
        }
        if (name != null) {
            this.element.addAttribute("name", name);
        }
        if (node != null) {
            this.element.addAttribute("node", node);
        }
    }

    public JID getJID() {
        return this.jid;
    }

    public String getNode() {
        return this.node;
    }

    public String getName() {
        return this.name;
    }

    public String getAction() {
        return this.action;
    }

    public Element getElement() {
        return this.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUID() {
        if (this.uid == null) {
            DiscoItem discoItem = this;
            synchronized (discoItem) {
                if (this.uid == null) {
                    StringBuilder sb = new StringBuilder(this.jid.toString());
                    if (this.name != null) {
                        sb.append(this.name);
                    }
                    if (this.node != null) {
                        sb.append(this.node);
                    }
                    if (this.action != null) {
                        sb.append(this.action);
                    }
                    this.uid = sb.toString();
                }
            }
        }
        return this.uid;
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DiscoItem && this.getUID().equals(((DiscoItem)obj).getUID());
    }

    public String toString() {
        return this.element.asXML();
    }
}

