/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.container;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;

public class PluginServletContext
implements ServletContext {
    protected final ServletContext proxy;
    private final PluginManager pluginManager;
    private final Plugin plugin;

    public PluginServletContext(ServletContext proxy, PluginManager pluginManager, Plugin plugin) {
        this.proxy = proxy;
        this.pluginManager = pluginManager;
        this.plugin = plugin;
    }

    protected static String stripLeadingSlash(String input) {
        if (input.startsWith("/")) {
            return input.substring(1);
        }
        return input;
    }

    public String getContextPath() {
        return this.proxy.getContextPath();
    }

    public ServletContext getContext(String s) {
        return this.proxy.getContext(s);
    }

    public int getMajorVersion() {
        return this.proxy.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.proxy.getMinorVersion();
    }

    public int getEffectiveMajorVersion() {
        return this.proxy.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.proxy.getEffectiveMinorVersion();
    }

    public String getMimeType(String s) {
        return this.proxy.getMimeType(s);
    }

    public Set<String> getResourcePaths(String s) {
        String pluginPath = "/plugins/" + this.pluginManager.getName(this.plugin) + "/";
        Set proxyResults = this.proxy.getResourcePaths(pluginPath + s);
        HashSet<String> results = new HashSet<String>();
        for (String proxyResult : proxyResults) {
            results.add(proxyResult.replaceFirst(pluginPath, ""));
        }
        return results;
    }

    public URL getResource(String s) throws MalformedURLException {
        return this.pluginManager.getPluginClassloader(this.plugin).getResource(PluginServletContext.stripLeadingSlash(s));
    }

    public InputStream getResourceAsStream(String s) {
        return this.pluginManager.getPluginClassloader(this.plugin).getResourceAsStream(PluginServletContext.stripLeadingSlash(s));
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return this.proxy.getRequestDispatcher(s);
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        return this.proxy.getNamedDispatcher(s);
    }

    public Servlet getServlet(String s) throws ServletException {
        return this.proxy.getServlet(s);
    }

    public Enumeration<Servlet> getServlets() {
        return this.proxy.getServlets();
    }

    public Enumeration<String> getServletNames() {
        return this.proxy.getServletNames();
    }

    public void log(String s) {
        this.proxy.log(s);
    }

    public void log(Exception e, String s) {
        this.proxy.log(e, s);
    }

    public void log(String s, Throwable throwable) {
        this.proxy.log(s, throwable);
    }

    public String getRealPath(String s) {
        return null;
    }

    public String getServerInfo() {
        return this.proxy.getServerInfo();
    }

    public String getInitParameter(String s) {
        return this.proxy.getInitParameter(s);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.proxy.getInitParameterNames();
    }

    public boolean setInitParameter(String s, String s1) {
        return this.proxy.setInitParameter(s, s1);
    }

    public Object getAttribute(String s) {
        return this.proxy.getAttribute(s);
    }

    public Enumeration<String> getAttributeNames() {
        return this.proxy.getAttributeNames();
    }

    public void setAttribute(String s, Object o) {
        this.proxy.setAttribute(s, o);
    }

    public void removeAttribute(String s) {
        this.proxy.removeAttribute(s);
    }

    public String getServletContextName() {
        return this.proxy.getServletContextName();
    }

    public ServletRegistration.Dynamic addServlet(String s, String s1) {
        return this.proxy.addServlet(s, s1);
    }

    public ServletRegistration.Dynamic addServlet(String s, Servlet servlet) {
        return this.proxy.addServlet(s, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String s, Class<? extends Servlet> aClass) {
        return this.proxy.addServlet(s, aClass);
    }

    public <T extends Servlet> T createServlet(Class<T> aClass) throws ServletException {
        return (T)this.proxy.createServlet(aClass);
    }

    public ServletRegistration getServletRegistration(String s) {
        return this.proxy.getServletRegistration(s);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.proxy.getServletRegistrations();
    }

    public FilterRegistration.Dynamic addFilter(String s, String s1) {
        return this.proxy.addFilter(s, s1);
    }

    public FilterRegistration.Dynamic addFilter(String s, Filter filter) {
        return this.proxy.addFilter(s, filter);
    }

    public FilterRegistration.Dynamic addFilter(String s, Class<? extends Filter> aClass) {
        return this.proxy.addFilter(s, aClass);
    }

    public <T extends Filter> T createFilter(Class<T> aClass) throws ServletException {
        return (T)this.proxy.createFilter(aClass);
    }

    public FilterRegistration getFilterRegistration(String s) {
        return this.proxy.getFilterRegistration(s);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.proxy.getFilterRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.proxy.getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
        this.proxy.setSessionTrackingModes(set);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.proxy.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.proxy.getEffectiveSessionTrackingModes();
    }

    public void addListener(String s) {
        this.proxy.addListener(s);
    }

    public <T extends EventListener> void addListener(T t) {
        this.proxy.addListener(t);
    }

    public void addListener(Class<? extends EventListener> aClass) {
        this.proxy.addListener(aClass);
    }

    public <T extends EventListener> T createListener(Class<T> aClass) throws ServletException {
        return (T)this.proxy.createListener(aClass);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.proxy.getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        return this.pluginManager.getPluginClassloader(this.plugin);
    }

    public void declareRoles(String ... strings) {
        this.proxy.declareRoles(strings);
    }

    public String getVirtualServerName() {
        return this.proxy.getVirtualServerName();
    }
}

