/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.container;

import java.io.File;
import java.io.FilenameFilter;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.openfire.XMPPServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader
extends URLClassLoader {
    private static final Logger Log = LoggerFactory.getLogger(PluginClassLoader.class);
    private List<JarURLConnection> cachedJarFiles = new ArrayList<JarURLConnection>();

    public PluginClassLoader() {
        super(new URL[0], PluginClassLoader.findParentClassLoader());
    }

    public void addDirectory(File directory, boolean developmentMode) {
        try {
            File libDir;
            File[] jars;
            File webDir;
            File i18nDir;
            File databaseDir;
            File classesDir = new File(directory, "classes");
            if (classesDir.exists()) {
                this.addURL(classesDir.toURI().toURL());
            }
            if ((databaseDir = new File(directory, "database")).exists()) {
                this.addURL(databaseDir.toURI().toURL());
            }
            if ((i18nDir = new File(directory, "i18n")).exists()) {
                this.addURL(i18nDir.toURI().toURL());
            }
            if ((webDir = new File(directory, "web")).exists()) {
                this.addURL(webDir.toURI().toURL());
            }
            if ((jars = (libDir = new File(directory, "lib")).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") || name.endsWith(".zip");
                }
            })) != null) {
                for (int i = 0; i < jars.length; ++i) {
                    if (jars[i] == null || !jars[i].isFile()) continue;
                    String jarFileUri = jars[i].toURI().toString() + "!/";
                    if (developmentMode) {
                        if (jars[i].getName().equals("plugin-" + directory.getName() + ".jar")) continue;
                        this.addURLFile(new URL("jar", "", -1, jarFileUri));
                        continue;
                    }
                    this.addURLFile(new URL("jar", "", -1, jarFileUri));
                }
            }
        }
        catch (MalformedURLException mue) {
            Log.error(mue.getMessage(), (Throwable)mue);
        }
    }

    public void addURLFile(URL file) {
        try {
            URLConnection uc = file.openConnection();
            if (uc instanceof JarURLConnection) {
                uc.setUseCaches(true);
                ((JarURLConnection)uc).getManifest();
                this.cachedJarFiles.add((JarURLConnection)uc);
            }
        }
        catch (Exception e) {
            Log.warn("Failed to cache plugin JAR file: " + file.toExternalForm());
        }
        this.addURL(file);
    }

    public void unloadJarFiles() {
        for (JarURLConnection url : this.cachedJarFiles) {
            try {
                Log.info("Unloading plugin JAR file " + url.getJarFile().getName());
                url.getJarFile().close();
            }
            catch (Exception e) {
                Log.error("Failed to unload JAR file", (Throwable)e);
            }
        }
    }

    private static ClassLoader findParentClassLoader() {
        ClassLoader parent = XMPPServer.class.getClassLoader();
        if (parent == null) {
            parent = PluginClassLoader.class.getClassLoader();
        }
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent;
    }
}

