/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.container;

import java.io.File;
import java.util.ArrayList;
import javax.servlet.ServletContainerInitializer;
import org.apache.jasper.servlet.JasperInitializer;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.spdy.server.http.HTTPSPDYServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jivesoftware.openfire.JMXManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.keystore.CertificateStore;
import org.jivesoftware.openfire.keystore.IdentityStore;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.openfire.spi.EncryptionArtifactFactory;
import org.jivesoftware.util.CertificateEventListener;
import org.jivesoftware.util.CertificateManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminConsolePlugin
implements Plugin {
    private static final Logger Log = LoggerFactory.getLogger(AdminConsolePlugin.class);
    public static final String secret = StringUtils.randomString(64);
    private int adminPort;
    private int adminSecurePort;
    private Server adminServer;
    private ContextHandlerCollection contexts = new ContextHandlerCollection();
    private CertificateEventListener certificateListener;
    private boolean restartNeeded = false;
    private boolean sslEnabled = false;
    private File pluginDir;

    public void startup() {
        this.restartNeeded = false;
        this.certificateListener = new CertificateListener();
        CertificateManager.addListener(this.certificateListener);
        int serverThreads = JiveGlobals.getXMLProperty("adminConsole.serverThreads", 2);
        this.adminPort = JiveGlobals.getXMLProperty("adminConsole.port", 9090);
        this.adminSecurePort = JiveGlobals.getXMLProperty("adminConsole.securePort", 9091);
        QueuedThreadPool tp = new QueuedThreadPool();
        tp.setName("Jetty-QTP-AdminConsole");
        this.adminServer = new Server((ThreadPool)tp);
        if (JMXManager.isEnabled()) {
            JMXManager jmx = JMXManager.getInstance();
            this.adminServer.addBean((Object)jmx.getContainer());
        }
        if (this.adminPort > 0) {
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSendServerVersion(false);
            ServerConnector httpConnector = new ServerConnector(this.adminServer, null, null, null, -1, serverThreads, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            String bindInterface = this.getBindInterface();
            httpConnector.setHost(bindInterface);
            httpConnector.setPort(this.adminPort);
            this.adminServer.addConnector((Connector)httpConnector);
        }
        this.sslEnabled = false;
        try {
            IdentityStore identityStore = null;
            if (XMPPServer.getInstance().getCertificateStoreManager() == null) {
                Log.warn("Admin console: CertifcateStoreManager has not been initialized yet. HTTPS will be unavailable.");
            } else {
                identityStore = XMPPServer.getInstance().getCertificateStoreManager().getIdentityStore(ConnectionType.WEBADMIN);
            }
            if (identityStore != null && this.adminSecurePort > 0) {
                if (identityStore.getAllCertificates().isEmpty()) {
                    Log.warn("Admin console: Identity store does not have any certificates. HTTPS will be unavailable.");
                } else {
                    HTTPSPDYServerConnector httpsConnector;
                    if (!identityStore.containsDomainCertificate("RSA")) {
                        Log.warn("Admin console: Using RSA certificates but they are not valid for the hosted domain");
                    }
                    ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
                    ConnectionConfiguration configuration = connectionManager.getListener(ConnectionType.WEBADMIN, true).generateConnectionConfiguration();
                    SslContextFactory sslContextFactory = new EncryptionArtifactFactory(configuration).getSslContextFactory();
                    if ("npn".equals(JiveGlobals.getXMLProperty("spdy.protocol", ""))) {
                        httpsConnector = new HTTPSPDYServerConnector(this.adminServer, sslContextFactory);
                    } else {
                        HttpConfiguration httpsConfig = new HttpConfiguration();
                        httpsConfig.setSendServerVersion(false);
                        httpsConfig.setSecureScheme("https");
                        httpsConfig.setSecurePort(this.adminSecurePort);
                        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpsConfig);
                        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.toString());
                        httpsConnector = new ServerConnector(this.adminServer, null, null, null, -1, serverThreads, new ConnectionFactory[]{sslConnectionFactory, httpConnectionFactory});
                    }
                    String bindInterface = this.getBindInterface();
                    httpsConnector.setHost(bindInterface);
                    httpsConnector.setPort(this.adminSecurePort);
                    this.adminServer.addConnector((Connector)httpsConnector);
                    this.sslEnabled = true;
                }
            }
        }
        catch (Exception e) {
            Log.error("An exception occurred while trying to make available the admin console via HTTPS.", (Throwable)e);
        }
        if (this.adminServer.getConnectors() == null || this.adminServer.getConnectors().length == 0) {
            this.adminServer = null;
            this.log(LocaleUtils.getLocalizedString("admin.console.warning"));
            return;
        }
        HandlerCollection collection = new HandlerCollection();
        this.adminServer.setHandler((Handler)collection);
        collection.setHandlers(new Handler[]{this.contexts, new DefaultHandler()});
        try {
            this.adminServer.start();
            this.logAdminConsolePorts();
        }
        catch (Exception e) {
            Log.error("Could not start admin console server", (Throwable)e);
        }
    }

    public void shutdown() {
        if (this.certificateListener != null) {
            CertificateManager.removeListener(this.certificateListener);
        }
        try {
            if (this.adminServer != null && this.adminServer.isRunning()) {
                this.adminServer.stop();
            }
        }
        catch (Exception e) {
            Log.error("Error stopping admin console server", (Throwable)e);
        }
        this.adminServer = null;
    }

    @Override
    public void initializePlugin(PluginManager manager, File pluginDir) {
        this.pluginDir = pluginDir;
        this.createWebAppContext();
        this.startup();
    }

    @Override
    public void destroyPlugin() {
        this.shutdown();
    }

    public boolean isRestartNeeded() {
        return this.restartNeeded;
    }

    public String getBindInterface() {
        String adminInterfaceName = JiveGlobals.getXMLProperty("adminConsole.interface");
        String globalInterfaceName = JiveGlobals.getXMLProperty("network.interface");
        String bindInterface = null;
        if (adminInterfaceName != null && adminInterfaceName.trim().length() > 0) {
            bindInterface = adminInterfaceName;
        } else if (globalInterfaceName != null && globalInterfaceName.trim().length() > 0) {
            bindInterface = globalInterfaceName;
        }
        return bindInterface;
    }

    public int getAdminUnsecurePort() {
        return this.adminPort;
    }

    public int getAdminSecurePort() {
        if (!this.sslEnabled) {
            return 0;
        }
        return this.adminSecurePort;
    }

    public ContextHandlerCollection getContexts() {
        return this.contexts;
    }

    public void restart() {
        try {
            this.adminServer.stop();
            this.adminServer.start();
        }
        catch (Exception e) {
            Log.error("An exception occurred while restarting the admin console:", (Throwable)e);
        }
    }

    private void createWebAppContext() {
        WebAppContext context;
        boolean developmentMode = Boolean.getBoolean("developmentMode");
        if (developmentMode) {
            System.out.println(LocaleUtils.getLocalizedString("admin.console.devmode"));
            context = new WebAppContext((HandlerContainer)this.contexts, this.pluginDir.getParentFile().getParentFile().getParentFile().getParent() + File.separator + "src" + File.separator + "web", "/");
        } else {
            context = new WebAppContext((HandlerContainer)this.contexts, this.pluginDir.getAbsoluteFile() + File.separator + "webapp", "/");
        }
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        initializers.add(new ContainerInitializer((ServletContainerInitializer)new JasperInitializer(), null));
        context.setAttribute("org.eclipse.jetty.containerInitializers", initializers);
        context.setAttribute(InstanceManager.class.getName(), (Object)new SimpleInstanceManager());
        context.setWelcomeFiles(new String[]{"index.html"});
        if (developmentMode) {
            context.addBean((Object)new ServletContainerInitializersStarter(context), true);
        }
    }

    private void log(String string) {
        Log.info(string);
        System.out.println(string);
    }

    private void logAdminConsolePorts() {
        String listening = LocaleUtils.getLocalizedString("admin.console.listening");
        String hostname = this.getBindInterface() == null ? XMPPServer.getInstance().getServerInfo().getXMPPDomain() : this.getBindInterface();
        boolean isPlainStarted = false;
        boolean isSecureStarted = false;
        boolean isSPDY = false;
        for (Connector connector : this.adminServer.getConnectors()) {
            if (((ServerConnector)connector).getPort() == this.adminPort) {
                isPlainStarted = true;
            } else if (((ServerConnector)connector).getPort() == this.adminSecurePort) {
                isSecureStarted = true;
            }
            if (!(connector instanceof HTTPSPDYServerConnector)) continue;
            isSPDY = true;
        }
        if (isPlainStarted && isSecureStarted) {
            this.log(listening + ":" + System.getProperty("line.separator") + "  http://" + hostname + ":" + this.adminPort + System.getProperty("line.separator") + "  https://" + hostname + ":" + this.adminSecurePort + (isSPDY ? " (SPDY)" : ""));
        } else if (isSecureStarted) {
            this.log(listening + " https://" + hostname + ":" + this.adminSecurePort + (isSPDY ? " (SPDY)" : ""));
        } else if (isPlainStarted) {
            this.log(listening + " http://" + hostname + ":" + this.adminPort);
        }
    }

    private class CertificateListener
    implements CertificateEventListener {
        private CertificateListener() {
        }

        @Override
        public void storeContentChanged(CertificateStore store) {
            AdminConsolePlugin.this.restartNeeded = true;
        }
    }
}

