/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.admin.group;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class GetListGroupUsers
extends AdHocCommand {
    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle("Requesting List of Group Members");
        form.addInstruction("Fill out this form to request list of group members and admins.");
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("Group Name");
        field.setVariable("group");
        field.setRequired(true);
        command.add(form.getElement());
    }

    @Override
    public void execute(SessionData data, Element command) {
        HashMap<String, Object> fields;
        Group group;
        try {
            group = GroupManager.getInstance().getGroup(data.getData().get("group").get(0));
        }
        catch (GroupNotFoundException e) {
            Element note = command.addElement("note");
            note.addAttribute("type", "error");
            note.setText("Group name does not exist");
            return;
        }
        DataForm form = new DataForm(DataForm.Type.result);
        form.addReportedField("jid", "User", FormField.Type.jid_single);
        form.addReportedField("admin", "Description", FormField.Type.boolean_type);
        for (JID memberJID : group.getMembers()) {
            fields = new HashMap<String, Object>();
            fields.put("jid", memberJID.toString());
            fields.put("admin", false);
            form.addItemFields(fields);
        }
        for (JID memberJID : group.getAdmins()) {
            fields = new HashMap();
            fields.put("jid", memberJID.toString());
            fields.put("admin", true);
            form.addItemFields(fields);
        }
        command.add(form.getElement());
    }

    @Override
    public String getCode() {
        return "http://jabber.org/protocol/admin#get-group-members";
    }

    @Override
    public String getDefaultLabel() {
        return "Get List of Group Members";
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return AdHocCommand.Action.complete;
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 1;
    }
}

