/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.admin;

import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.http.HttpBindManager;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class HttpBindStatus
extends AdHocCommand {
    @Override
    public String getCode() {
        return "http://jabber.org/protocol/admin#status-http-bind";
    }

    @Override
    public String getDefaultLabel() {
        return "Current Http Bind Status";
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 0;
    }

    @Override
    public void execute(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.result);
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        HttpBindManager manager = HttpBindManager.getInstance();
        boolean isEnabled = manager.isHttpBindEnabled();
        field = form.addField();
        field.setLabel("Http Bind Enabled");
        field.setVariable("httpbindenabled");
        field.addValue((Object)String.valueOf(isEnabled));
        if (isEnabled) {
            field = form.addField();
            field.setLabel("Http Bind Address");
            field.setVariable("httpbindaddress");
            field.addValue((Object)manager.getHttpBindUnsecureAddress());
            field = form.addField();
            field.setLabel("Http Bind Secure Address");
            field.setVariable("httpbindsecureaddress");
            field.addValue((Object)manager.getHttpBindSecureAddress());
            String jsUrl = manager.getJavaScriptUrl();
            if (jsUrl != null) {
                field = form.addField();
                field.setLabel("Http Bind JavaScript Address");
                field.setVariable("javascriptaddress");
                field.addValue((Object)jsUrl);
            }
        }
        command.add(form.getElement());
    }

    @Override
    protected void addStageInformation(SessionData data, Element command) {
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.emptyList();
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return null;
    }

    @Override
    public boolean hasPermission(JID requester) {
        return super.hasPermission(requester) || InternalComponentManager.getInstance().hasComponent(requester);
    }
}

