/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.util.cache.CacheFactory;
import org.jivesoftware.util.cache.ClusterTask;

public class GetBasicStatistics
implements ClusterTask<Map<String, Object>> {
    public static final String NODE = "node";
    public static final String CLIENT = "client";
    public static final String INCOMING = "incoming";
    public static final String OUTGOING = "outgoing";
    public static final String MEMORY_CURRENT = "memory_cur";
    public static final String MEMORY_MAX = "memory_max";
    private Map<String, Object> values;

    @Override
    public Map<String, Object> getResult() {
        return this.values;
    }

    @Override
    public void run() {
        SessionManager manager = SessionManager.getInstance();
        this.values = new HashMap<String, Object>();
        this.values.put(NODE, CacheFactory.getClusterMemberID());
        this.values.put(CLIENT, manager.getUserSessionsCount(true));
        this.values.put(INCOMING, manager.getIncomingServerSessionsCount(true));
        this.values.put(OUTGOING, XMPPServer.getInstance().getRoutingTable().getServerSessionsCount());
        Runtime runtime = Runtime.getRuntime();
        double freeMemory = (double)runtime.freeMemory() / 1048576.0;
        double maxMemory = (double)runtime.maxMemory() / 1048576.0;
        double totalMemory = (double)runtime.totalMemory() / 1048576.0;
        double usedMemory = totalMemory - freeMemory;
        this.values.put(MEMORY_CURRENT, usedMemory);
        this.values.put(MEMORY_MAX, maxMemory);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }
}

