/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;

public class AuthToken {
    private static final long serialVersionUID = 1L;
    private String username;
    private String domain;
    private Boolean anonymous;

    public AuthToken(String jid) {
        if (jid == null) {
            this.domain = JiveGlobals.getProperty("xmpp.domain");
            return;
        }
        int index = jid.indexOf("@");
        if (index > -1) {
            this.username = jid.substring(0, index);
            this.domain = jid.substring(index + 1);
        } else {
            this.username = jid;
            this.domain = JiveGlobals.getProperty("xmpp.domain");
        }
    }

    public AuthToken(String jid, Boolean anonymous) {
        int index = jid.indexOf("@");
        if (index > -1) {
            this.username = jid.substring(0, index);
            this.domain = jid.substring(index + 1);
        } else {
            this.username = jid;
            this.domain = JiveGlobals.getProperty("xmpp.domain");
        }
        this.anonymous = anonymous;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isAnonymous() {
        if (this.anonymous == null) {
            this.anonymous = this.username == null || !UserManager.getInstance().isRegisteredUser(this.username);
        }
        return this.anonymous;
    }
}

