/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.jivesoftware.openfire.auth.AuthProvider;
import org.jivesoftware.openfire.auth.AuthToken;
import org.jivesoftware.openfire.auth.ConnectionException;
import org.jivesoftware.openfire.auth.DefaultAuthProvider;
import org.jivesoftware.openfire.auth.HybridAuthProvider;
import org.jivesoftware.openfire.auth.InternalUnauthenticatedException;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.lockout.LockOutManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.Blowfish;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthFactory {
    private static final Logger Log = LoggerFactory.getLogger(AuthFactory.class);
    private static AuthProvider authProvider = null;
    private static MessageDigest digest;
    private static final Object DIGEST_LOCK;
    private static Blowfish cipher;

    private static void initProvider() {
        JiveGlobals.migrateProperty("provider.auth.className");
        String className = JiveGlobals.getProperty("provider.auth.className", "org.jivesoftware.openfire.auth.DefaultAuthProvider");
        if (authProvider == null || !className.equals(authProvider.getClass().getName())) {
            try {
                Class c = ClassUtils.forName(className);
                authProvider = (AuthProvider)c.newInstance();
            }
            catch (Exception e) {
                Log.error("Error loading auth provider: " + className, (Throwable)e);
                authProvider = new DefaultAuthProvider();
            }
        }
    }

    public static AuthProvider getAuthProvider() {
        return authProvider;
    }

    public static boolean isProviderInstanceOf(Class<?> c) {
        return c.isInstance(authProvider);
    }

    public static boolean isProviderHybridInstanceOf(Class<? extends AuthProvider> clazz) {
        return authProvider instanceof HybridAuthProvider && ((HybridAuthProvider)authProvider).isProvider(clazz);
    }

    public static boolean supportsPasswordRetrieval() {
        return authProvider.supportsPasswordRetrieval();
    }

    public static String getPassword(String username) throws UserNotFoundException, UnsupportedOperationException {
        return authProvider.getPassword(username.toLowerCase());
    }

    public static void setPassword(String username, String password) throws UserNotFoundException, UnsupportedOperationException, ConnectionException, InternalUnauthenticatedException {
        authProvider.setPassword(username, password);
    }

    public static AuthToken authenticate(String username, String password) throws UnauthorizedException, ConnectionException, InternalUnauthenticatedException {
        if (LockOutManager.getInstance().isAccountDisabled(username)) {
            LockOutManager.getInstance().recordFailedLogin(username);
            throw new UnauthorizedException();
        }
        authProvider.authenticate(username, password);
        return new AuthToken(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createDigest(String token, String password) {
        Object object = DIGEST_LOCK;
        synchronized (object) {
            digest.update(token.getBytes());
            return StringUtils.encodeHex(digest.digest(password.getBytes()));
        }
    }

    public static String encryptPassword(String password) {
        if (password == null) {
            return null;
        }
        Blowfish cipher = AuthFactory.getCipher();
        if (cipher == null) {
            throw new UnsupportedOperationException();
        }
        return cipher.encryptString(password);
    }

    public static String decryptPassword(String encryptedPassword) {
        if (encryptedPassword == null) {
            return null;
        }
        Blowfish cipher = AuthFactory.getCipher();
        if (cipher == null) {
            throw new UnsupportedOperationException();
        }
        return cipher.decryptString(encryptedPassword);
    }

    private static synchronized Blowfish getCipher() {
        if (cipher != null) {
            return cipher;
        }
        try {
            String keyString = JiveGlobals.getProperty("passwordKey");
            if (keyString == null) {
                keyString = StringUtils.randomString(15);
                JiveGlobals.setProperty("passwordKey", keyString);
                if (!keyString.equals(JiveGlobals.getProperty("passwordKey"))) {
                    return null;
                }
            }
            cipher = new Blowfish(keyString);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        return cipher;
    }

    public static boolean supportsScram() {
        return authProvider.isScramSupported();
    }

    public static String getSalt(String username) throws UnsupportedOperationException, UserNotFoundException {
        return authProvider.getSalt(username);
    }

    public static int getIterations(String username) throws UnsupportedOperationException, UserNotFoundException {
        return authProvider.getIterations(username);
    }

    public static String getServerKey(String username) throws UnsupportedOperationException, UserNotFoundException {
        return authProvider.getServerKey(username);
    }

    public static String getStoredKey(String username) throws UnsupportedOperationException, UserNotFoundException {
        return authProvider.getStoredKey(username);
    }

    static {
        DIGEST_LOCK = new Object();
        cipher = null;
        try {
            digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
        }
        AuthFactory.initProvider();
        PropertyEventListener propListener = new PropertyEventListener(){

            public void propertySet(String property, Map params) {
                if ("provider.auth.className".equals(property)) {
                    AuthFactory.initProvider();
                }
            }

            public void propertyDeleted(String property, Map params) {
            }

            public void xmlPropertySet(String property, Map params) {
            }

            public void xmlPropertyDeleted(String property, Map params) {
            }
        };
        PropertyEventDispatcher.addListener(propListener);
    }
}

