/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.admin.AdminProvider;
import org.jivesoftware.openfire.admin.DefaultAdminProvider;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class AdminManager {
    private static final Logger Log = LoggerFactory.getLogger(AdminManager.class);
    private List<JID> adminList;
    private AdminProvider provider;

    public static AdminProvider getAdminProvider() {
        return AdminManagerContainer.instance.provider;
    }

    public static AdminManager getInstance() {
        return AdminManagerContainer.instance;
    }

    private AdminManager() {
        this.initProvider();
        PropertyEventListener propListener = new PropertyEventListener(){

            @Override
            public void propertySet(String property, Map<String, Object> params) {
                if ("provider.admin.className".equals(property)) {
                    AdminManager.this.initProvider();
                }
            }

            @Override
            public void propertyDeleted(String property, Map<String, Object> params) {
            }

            @Override
            public void xmlPropertySet(String property, Map<String, Object> params) {
            }

            @Override
            public void xmlPropertyDeleted(String property, Map<String, Object> params) {
            }
        };
        PropertyEventDispatcher.addListener(propListener);
    }

    private void initProvider() {
        JiveGlobals.migrateProperty("provider.admin.className");
        String className = JiveGlobals.getProperty("provider.admin.className", "org.jivesoftware.openfire.admin.DefaultAdminProvider");
        if (this.provider == null || !className.equals(this.provider.getClass().getName())) {
            try {
                Class c = ClassUtils.forName(className);
                this.provider = (AdminProvider)c.newInstance();
            }
            catch (Exception e) {
                Log.error("Error loading admin provider: " + className, (Throwable)e);
                this.provider = new DefaultAdminProvider();
            }
        }
    }

    private void loadAdminList() {
        this.adminList = this.provider.getAdmins();
    }

    public void refreshAdminAccounts() {
        this.loadAdminList();
    }

    public List<JID> getAdminAccounts() {
        if (this.adminList == null) {
            this.loadAdminList();
        }
        return this.adminList;
    }

    public void addAdminAccount(String username) {
        JID userJID;
        if (this.adminList == null) {
            this.loadAdminList();
        }
        if (this.adminList.contains(userJID = XMPPServer.getInstance().createJID(username, null))) {
            return;
        }
        this.adminList.add(userJID);
        this.provider.setAdmins(this.adminList);
    }

    public void addAdminAccount(JID jid) {
        JID bareJID;
        if (this.adminList == null) {
            this.loadAdminList();
        }
        if (this.adminList.contains(bareJID = jid.asBareJID())) {
            return;
        }
        this.adminList.add(bareJID);
        this.provider.setAdmins(this.adminList);
    }

    public void removeAdminAccount(String username) {
        JID userJID;
        if (this.adminList == null) {
            this.loadAdminList();
        }
        if (!this.adminList.contains(userJID = XMPPServer.getInstance().createJID(username, null))) {
            return;
        }
        this.adminList.remove(userJID);
        this.provider.setAdmins(this.adminList);
    }

    public void removeAdminAccount(JID jid) {
        JID bareJID;
        if (this.adminList == null) {
            this.loadAdminList();
        }
        if (!this.adminList.contains(bareJID = jid.asBareJID())) {
            return;
        }
        this.adminList.remove(bareJID);
        this.provider.setAdmins(this.adminList);
    }

    public boolean isUserAdmin(String username, boolean allowAdminIfEmpty) {
        if (this.adminList == null) {
            this.loadAdminList();
        }
        if (allowAdminIfEmpty && this.adminList.isEmpty()) {
            return "admin".equals(username);
        }
        JID userJID = XMPPServer.getInstance().createJID(username, null);
        return this.adminList.contains(userJID);
    }

    public boolean isUserAdmin(JID jid, boolean allowAdminIfEmpty) {
        if (this.adminList == null) {
            this.loadAdminList();
        }
        if (allowAdminIfEmpty && this.adminList.isEmpty()) {
            return "admin".equals(jid.getNode());
        }
        JID bareJID = jid.asBareJID();
        return this.adminList.contains(bareJID);
    }

    public void clearAdminUsers() {
        if (this.adminList == null) {
            this.adminList = new ArrayList<JID>();
        } else {
            this.adminList.clear();
        }
        this.provider.setAdmins(this.adminList);
    }

    public void setAdminUsers(List<String> usernames) {
        if (this.adminList == null) {
            this.adminList = new ArrayList<JID>();
        } else {
            this.adminList.clear();
        }
        ArrayList<JID> admins = new ArrayList<JID>();
        for (String username : usernames) {
            admins.add(XMPPServer.getInstance().createJID(username, null));
        }
        this.adminList.addAll(admins);
        this.provider.setAdmins(admins);
    }

    public void setAdminJIDs(List<JID> jids) {
        if (this.adminList == null) {
            this.adminList = new ArrayList<JID>();
        } else {
            this.adminList.clear();
        }
        ArrayList<JID> admins = new ArrayList<JID>();
        for (JID jid : jids) {
            if (jid == null) continue;
            admins.add(jid.asBareJID());
        }
        this.adminList.addAll(admins);
        this.provider.setAdmins(admins);
    }

    private static class AdminManagerContainer {
        private static AdminManager instance = new AdminManager();

        private AdminManagerContainer() {
        }
    }
}

