/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.ConnectionCloseListener;
import org.jivesoftware.openfire.LocalSessionManager;
import org.jivesoftware.openfire.OfflineMessage;
import org.jivesoftware.openfire.OfflineMessageStore;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionResultFilter;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.StreamIDFactory;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.audit.AuditStreamIDFactory;
import org.jivesoftware.openfire.auth.AuthToken;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.cluster.ClusterEventListener;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.event.SessionEventDispatcher;
import org.jivesoftware.openfire.http.HttpConnection;
import org.jivesoftware.openfire.http.HttpSession;
import org.jivesoftware.openfire.multiplex.ConnectionMultiplexerManager;
import org.jivesoftware.openfire.server.OutgoingSessionPromise;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.ClientSessionInfo;
import org.jivesoftware.openfire.session.ComponentSession;
import org.jivesoftware.openfire.session.ConnectionMultiplexerSession;
import org.jivesoftware.openfire.session.DomainPair;
import org.jivesoftware.openfire.session.GetSessionsCountTask;
import org.jivesoftware.openfire.session.IncomingServerSession;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.session.LocalComponentSession;
import org.jivesoftware.openfire.session.LocalConnectionMultiplexerSession;
import org.jivesoftware.openfire.session.LocalIncomingServerSession;
import org.jivesoftware.openfire.session.LocalOutgoingServerSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.openfire.session.OutgoingServerSession;
import org.jivesoftware.openfire.session.RemoteSessionLocator;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.openfire.spi.BasicStreamIDFactory;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.TaskEngine;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class SessionManager
extends BasicModule
implements ClusterEventListener {
    private static final Logger Log = LoggerFactory.getLogger(SessionManager.class);
    public static final String COMPONENT_SESSION_CACHE_NAME = "Components Sessions";
    public static final String CM_CACHE_NAME = "Connection Managers Sessions";
    public static final String ISS_CACHE_NAME = "Incoming Server Sessions";
    public static final String C2S_INFO_CACHE_NAME = "Client Session Info Cache";
    public static final int NEVER_KICK = -1;
    private XMPPServer server;
    private PacketRouter router;
    private String serverName;
    private JID serverAddress;
    private UserManager userManager;
    private int conflictLimit;
    private final AtomicInteger connectionsCounter = new AtomicInteger(0);
    private Cache<String, ClientSessionInfo> sessionInfoCache;
    private Cache<String, byte[]> componentSessionsCache;
    private Cache<String, byte[]> multiplexerSessionsCache;
    private Cache<StreamID, byte[]> incomingServerSessionsCache;
    private Cache<String, List<StreamID>> hostnameSessionsCache;
    private Cache<StreamID, Set<String>> validatedDomainsCache;
    private ClientSessionListener clientSessionListener = new ClientSessionListener();
    private ComponentSessionListener componentSessionListener = new ComponentSessionListener();
    private IncomingServerSessionListener incomingServerListener = new IncomingServerSessionListener();
    private OutgoingServerSessionListener outgoingServerListener = new OutgoingServerSessionListener();
    private ConnectionMultiplexerSessionListener multiplexerSessionListener = new ConnectionMultiplexerSessionListener();
    private final Map<StreamID, LocalSession> detachedSessions = new ConcurrentHashMap<StreamID, LocalSession>();
    private LocalSessionManager localSessionManager;
    private RoutingTable routingTable;
    private StreamIDFactory streamIDFactory = JiveGlobals.getBooleanProperty("xmpp.audit.active") ? new AuditStreamIDFactory() : new BasicStreamIDFactory();

    public static SessionManager getInstance() {
        return XMPPServer.getInstance().getSessionManager();
    }

    public SessionManager() {
        super("Session Manager");
        this.localSessionManager = new LocalSessionManager();
        this.conflictLimit = JiveGlobals.getIntProperty("xmpp.session.conflict-limit", 0);
    }

    public void addDetached(LocalSession localSession) {
        this.detachedSessions.put(localSession.getStreamID(), localSession);
    }

    public synchronized void removeDetached(LocalSession localSession) {
        LocalSession other = this.detachedSessions.get(localSession.getStreamID());
        if (other == localSession) {
            this.detachedSessions.remove(localSession.getStreamID());
        }
    }

    public ConnectionMultiplexerSession getConnectionMultiplexerSession(JID address) {
        byte[] nodeID;
        LocalConnectionMultiplexerSession session = this.localSessionManager.getConnnectionManagerSessions().get(address.toString());
        if (session == null && this.server.getRemoteSessionLocator() != null && (nodeID = (byte[])this.multiplexerSessionsCache.get(address.toString())) != null) {
            return this.server.getRemoteSessionLocator().getConnectionMultiplexerSession(nodeID, address);
        }
        return null;
    }

    public List<ConnectionMultiplexerSession> getConnectionMultiplexerSessions() {
        ArrayList<ConnectionMultiplexerSession> sessions = new ArrayList<ConnectionMultiplexerSession>();
        sessions.addAll(this.localSessionManager.getConnnectionManagerSessions().values());
        RemoteSessionLocator locator = this.server.getRemoteSessionLocator();
        if (locator != null) {
            for (Map.Entry entry : this.multiplexerSessionsCache.entrySet()) {
                if (this.server.getNodeID().equals((byte[])entry.getValue())) continue;
                sessions.add(locator.getConnectionMultiplexerSession((byte[])entry.getValue(), new JID((String)entry.getKey())));
            }
        }
        return sessions;
    }

    public List<ConnectionMultiplexerSession> getConnectionMultiplexerSessions(String domain) {
        ArrayList<ConnectionMultiplexerSession> sessions = new ArrayList<ConnectionMultiplexerSession>();
        for (String address : this.localSessionManager.getConnnectionManagerSessions().keySet()) {
            JID jid = new JID(address);
            if (!domain.equals(jid.getDomain())) continue;
            sessions.add(this.localSessionManager.getConnnectionManagerSessions().get(address));
        }
        RemoteSessionLocator locator = this.server.getRemoteSessionLocator();
        if (locator != null) {
            for (Map.Entry entry : this.multiplexerSessionsCache.entrySet()) {
                JID jid;
                if (this.server.getNodeID().equals((byte[])entry.getValue()) || !domain.equals((jid = new JID((String)entry.getKey())).getDomain())) continue;
                sessions.add(locator.getConnectionMultiplexerSession((byte[])entry.getValue(), new JID((String)entry.getKey())));
            }
        }
        return sessions;
    }

    public LocalConnectionMultiplexerSession createMultiplexerSession(Connection conn, JID address) {
        if (this.serverName == null) {
            throw new IllegalStateException("Server not initialized");
        }
        StreamID id = this.nextStreamID();
        LocalConnectionMultiplexerSession session = new LocalConnectionMultiplexerSession(this.serverName, conn, id);
        conn.init(session);
        conn.registerCloseListener(this.multiplexerSessionListener, session);
        boolean firstConnection = this.getConnectionMultiplexerSessions(address.getDomain()).isEmpty();
        this.localSessionManager.getConnnectionManagerSessions().put(address.toString(), session);
        this.multiplexerSessionsCache.put(address.toString(), this.server.getNodeID().toByteArray());
        if (firstConnection) {
            ConnectionMultiplexerManager.getInstance().multiplexerAvailable(address.getDomain());
        }
        return session;
    }

    public StreamID nextStreamID() {
        return this.streamIDFactory.createStreamID();
    }

    public LocalClientSession createClientSession(Connection conn, Locale language) {
        return this.createClientSession(conn, this.nextStreamID(), language);
    }

    public LocalClientSession createClientSession(Connection conn, StreamID id) {
        return this.createClientSession(conn, id, null);
    }

    public LocalClientSession createClientSession(Connection conn, StreamID id, Locale language) {
        if (this.serverName == null) {
            throw new IllegalStateException("Server not initialized");
        }
        LocalClientSession session = new LocalClientSession(this.serverName, conn, id, language);
        conn.init(session);
        conn.registerCloseListener(this.clientSessionListener, session);
        this.localSessionManager.getPreAuthenticatedSessions().put(session.getAddress().getResource(), session);
        this.connectionsCounter.incrementAndGet();
        return session;
    }

    public HttpSession createClientHttpSession(long rid, InetAddress address, StreamID id, HttpConnection connection, Locale language) throws UnauthorizedException {
        if (this.serverName == null) {
            throw new UnauthorizedException("Server not initialized");
        }
        PacketDeliverer backupDeliverer = this.server.getPacketDeliverer();
        HttpSession session = new HttpSession(backupDeliverer, this.serverName, address, id, rid, connection, language);
        Connection conn = session.getConnection();
        conn.init(session);
        conn.registerCloseListener(this.clientSessionListener, session);
        this.localSessionManager.getPreAuthenticatedSessions().put(session.getAddress().getResource(), session);
        this.connectionsCounter.incrementAndGet();
        return session;
    }

    public LocalComponentSession createComponentSession(JID address, Connection conn) {
        if (this.serverName == null) {
            throw new IllegalStateException("Server not initialized");
        }
        StreamID id = this.nextStreamID();
        LocalComponentSession session = new LocalComponentSession(this.serverName, conn, id);
        conn.init(session);
        conn.registerCloseListener(this.componentSessionListener, session);
        session.setAddress(address);
        this.localSessionManager.getComponentsSessions().add(session);
        this.componentSessionsCache.put(address.toString(), this.server.getNodeID().toByteArray());
        return session;
    }

    public LocalIncomingServerSession createIncomingServerSession(Connection conn, StreamID id, String fromDomain) throws UnauthorizedException {
        if (this.serverName == null) {
            throw new UnauthorizedException("Server not initialized");
        }
        LocalIncomingServerSession session = new LocalIncomingServerSession(this.serverName, conn, id, fromDomain);
        conn.init(session);
        conn.registerCloseListener(this.incomingServerListener, session);
        return session;
    }

    public void outgoingServerSessionCreated(LocalOutgoingServerSession session) {
        session.getConnection().registerCloseListener(this.outgoingServerListener, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIncomingServerSession(String hostname, LocalIncomingServerSession session) {
        StreamID streamID = session.getStreamID();
        this.localSessionManager.addIncomingServerSessions(streamID, session);
        this.incomingServerSessionsCache.put(streamID, this.server.getNodeID().toByteArray());
        Lock lock = CacheFactory.getLock(hostname, this.hostnameSessionsCache);
        try {
            lock.lock();
            ArrayList<StreamID> streamIDs = (ArrayList<StreamID>)this.hostnameSessionsCache.get(hostname);
            if (streamIDs == null) {
                streamIDs = new ArrayList<StreamID>();
            }
            streamIDs.add(streamID);
            this.hostnameSessionsCache.put(hostname, streamIDs);
        }
        finally {
            lock.unlock();
        }
        lock = CacheFactory.getLock(streamID, this.validatedDomainsCache);
        try {
            boolean added;
            lock.lock();
            HashSet<String> validatedDomains = (HashSet<String>)this.validatedDomainsCache.get(streamID);
            if (validatedDomains == null) {
                validatedDomains = new HashSet<String>();
            }
            if (added = validatedDomains.add(hostname)) {
                this.validatedDomainsCache.put(streamID, validatedDomains);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIncomingServerSession(String hostname, IncomingServerSession session) {
        StreamID streamID = session.getStreamID();
        this.localSessionManager.removeIncomingServerSessions(streamID);
        this.incomingServerSessionsCache.remove(streamID);
        Lock lock = CacheFactory.getLock(hostname, this.hostnameSessionsCache);
        try {
            lock.lock();
            List streamIDs = (List)this.hostnameSessionsCache.get(hostname);
            if (streamIDs != null) {
                streamIDs.remove(streamID);
                if (streamIDs.isEmpty()) {
                    this.hostnameSessionsCache.remove(hostname);
                } else {
                    this.hostnameSessionsCache.put(hostname, streamIDs);
                }
            }
        }
        finally {
            lock.unlock();
        }
        lock = CacheFactory.getLock(streamID, this.validatedDomainsCache);
        try {
            lock.lock();
            HashSet validatedDomains = (HashSet)this.validatedDomainsCache.get(streamID);
            if (validatedDomains == null) {
                validatedDomains = new HashSet();
            }
            validatedDomains.remove(hostname);
            if (!validatedDomains.isEmpty()) {
                this.validatedDomainsCache.put(streamID, validatedDomains);
            } else {
                this.validatedDomainsCache.remove(streamID);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getValidatedDomains(StreamID streamID) {
        Lock lock = CacheFactory.getLock(streamID, this.validatedDomainsCache);
        try {
            lock.lock();
            Set validatedDomains = (Set)this.validatedDomainsCache.get(streamID);
            if (validatedDomains == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Collection<String> collection = Collections.unmodifiableCollection(validatedDomains);
            return collection;
        }
        finally {
            lock.unlock();
        }
    }

    public void addSession(LocalClientSession session) {
        this.routingTable.addClientRoute(session.getAddress(), session);
        this.localSessionManager.getPreAuthenticatedSessions().remove(session.getStreamID().toString());
        SessionEventDispatcher.EventType event = session.getAuthToken().isAnonymous() ? SessionEventDispatcher.EventType.anonymous_session_created : SessionEventDispatcher.EventType.session_created;
        SessionEventDispatcher.dispatchEvent(session, event);
        if (ClusterManager.isClusteringStarted()) {
            this.sessionInfoCache.put(session.getAddress().toString(), new ClientSessionInfo(session));
        }
    }

    public void sessionAvailable(LocalClientSession session, Presence presence) {
        if (session.getAuthToken().isAnonymous()) {
            this.routingTable.addClientRoute(session.getAddress(), session);
        } else {
            this.routingTable.addClientRoute(session.getAddress(), session);
            this.broadcastPresenceOfOtherResource(session);
        }
    }

    public static boolean isOtherResourcePresenceEnabled() {
        return JiveGlobals.getBooleanProperty("xmpp.client.other-resource.presence", true);
    }

    private void broadcastPresenceOfOtherResource(LocalClientSession session) {
        if (!SessionManager.isOtherResourcePresenceEnabled()) {
            return;
        }
        JID searchJID = new JID(session.getAddress().getNode(), session.getAddress().getDomain(), null);
        List<JID> addresses = this.routingTable.getRoutes(searchJID, null);
        for (JID address : addresses) {
            if (address.equals((Object)session.getAddress())) continue;
            ClientSession userSession = this.routingTable.getClientRoute(address);
            Presence presence = userSession.getPresence().createCopy();
            presence.setTo(session.getAddress());
            session.process((Packet)presence);
        }
    }

    public void broadcastPresenceToOtherResources(JID originatingResource, Presence presence) {
        presence.setTo(originatingResource);
        this.routingTable.routePacket(originatingResource, (Packet)presence, false);
        if (!SessionManager.isOtherResourcePresenceEnabled()) {
            return;
        }
        JID searchJID = new JID(originatingResource.getNode(), originatingResource.getDomain(), null);
        List<JID> addresses = this.routingTable.getRoutes(searchJID, null);
        for (JID address : addresses) {
            if (originatingResource.equals((Object)address)) continue;
            presence.setTo(address);
            this.routingTable.routePacket(address, (Packet)presence, false);
        }
    }

    public void sessionUnavailable(LocalClientSession session) {
        if (session.getAddress() != null && this.routingTable != null && session.getAddress().toBareJID().trim().length() != 0) {
            this.routingTable.addClientRoute(session.getAddress(), session);
        }
    }

    public void changePriority(LocalClientSession session, int oldPriority) {
        if (session.getAuthToken().isAnonymous()) {
            return;
        }
        int newPriority = session.getPresence().getPriority();
        if (newPriority < 0 || oldPriority >= 0) {
            return;
        }
        JID searchJID = session.getAddress().asBareJID();
        for (JID address : this.routingTable.getRoutes(searchJID, null)) {
            ClientSession otherSession;
            if (address.equals((Object)session.getAddress()) || (otherSession = this.routingTable.getClientRoute(address)).getPresence().getPriority() < 0) continue;
            return;
        }
        if (session.canFloodOfflineMessages()) {
            OfflineMessageStore messageStore = this.server.getOfflineMessageStore();
            Collection<OfflineMessage> messages = messageStore.getMessages(session.getAuthToken().getUsername(), true);
            for (Message message : messages) {
                session.process((Packet)message);
            }
        }
    }

    public boolean isAnonymousRoute(String username) {
        return this.isAnonymousRoute(new JID(username, this.serverName, username, true));
    }

    public boolean isAnonymousRoute(JID address) {
        return this.routingTable.isAnonymousRoute(address);
    }

    public boolean isActiveRoute(String username, String resource) {
        boolean hasRoute = false;
        ClientSession session = this.routingTable.getClientRoute(new JID(username, this.serverName, resource));
        if (session != null && !session.isClosed()) {
            hasRoute = session.validate();
        }
        return hasRoute;
    }

    public ClientSession getSession(JID from) {
        ClientSession session;
        if (from == null || this.serverName == null || !this.serverName.equals(from.getDomain())) {
            return null;
        }
        if (from.getResource() != null && (session = (ClientSession)this.localSessionManager.getPreAuthenticatedSessions().get(from.getResource())) != null) {
            return session;
        }
        if (from.getResource() == null || from.getNode() == null) {
            return null;
        }
        return this.routingTable.getClientRoute(from);
    }

    public Collection<ClientSession> getSessions() {
        return this.routingTable.getClientsRoutes(false);
    }

    public Collection<ClientSession> getSessions(SessionResultFilter filter) {
        ArrayList<ClientSession> results = new ArrayList<ClientSession>();
        if (filter != null) {
            results.addAll(this.getSessions());
            ArrayList<ClientSession> filteredResults = new ArrayList<ClientSession>();
            for (ClientSession session : results) {
                filteredResults.add(session);
            }
            Collections.sort(filteredResults, filter.getSortComparator());
            int maxResults = filter.getNumResults();
            if (maxResults == -1) {
                maxResults = filteredResults.size();
            }
            ArrayList<ClientSession> finalResults = new ArrayList<ClientSession>();
            int startIndex = filter.getStartIndex();
            Iterator sortedIter = filteredResults.iterator();
            int i = 0;
            while (sortedIter.hasNext() && finalResults.size() < maxResults) {
                ClientSession result = (ClientSession)sortedIter.next();
                if (i >= startIndex) {
                    finalResults.add(result);
                }
                ++i;
            }
            return finalResults;
        }
        return results;
    }

    public LocalIncomingServerSession getIncomingServerSession(StreamID streamID) {
        return this.localSessionManager.getIncomingServerSession(streamID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IncomingServerSession> getIncomingServerSessions(String hostname) {
        List streamIDs;
        Lock lock = CacheFactory.getLock(hostname, this.hostnameSessionsCache);
        try {
            lock.lock();
            streamIDs = (List)this.hostnameSessionsCache.get(hostname);
        }
        finally {
            lock.unlock();
        }
        if (streamIDs == null) {
            return Collections.emptyList();
        }
        ArrayList<IncomingServerSession> sessions = new ArrayList<IncomingServerSession>();
        for (StreamID streamID : streamIDs) {
            byte[] nodeID;
            IncomingServerSession session = this.localSessionManager.getIncomingServerSession(streamID);
            RemoteSessionLocator locator = this.server.getRemoteSessionLocator();
            if (session == null && locator != null && (nodeID = (byte[])this.incomingServerSessionsCache.get(streamID)) != null) {
                session = locator.getIncomingServerSession(nodeID, streamID);
            }
            if (session == null) continue;
            sessions.add(session);
        }
        return sessions;
    }

    public OutgoingServerSession getOutgoingServerSession(DomainPair pair) {
        return this.routingTable.getServerRoute(pair);
    }

    public List<OutgoingServerSession> getOutgoingServerSessions(String host) {
        LinkedList<OutgoingServerSession> sessions = new LinkedList<OutgoingServerSession>();
        for (DomainPair pair : this.routingTable.getServerRoutes()) {
            if (!pair.getRemote().equals(host)) continue;
            sessions.add(this.routingTable.getServerRoute(pair));
        }
        return sessions;
    }

    public Collection<ClientSession> getSessions(String username) {
        ArrayList<ClientSession> sessionList = new ArrayList<ClientSession>();
        if (username != null && this.serverName != null) {
            List<JID> addresses = this.routingTable.getRoutes(new JID(username, this.serverName, null, true), null);
            for (JID address : addresses) {
                sessionList.add(this.routingTable.getClientRoute(address));
            }
        }
        return sessionList;
    }

    public int getConnectionsCount(boolean onlyLocal) {
        int total = this.connectionsCounter.get();
        if (!onlyLocal) {
            Collection<Object> results = CacheFactory.doSynchronousClusterTask(new GetSessionsCountTask(false), false);
            for (Object result : results) {
                if (result == null) continue;
                total += ((Integer)result).intValue();
            }
        }
        return total;
    }

    public int getUserSessionsCount(boolean onlyLocal) {
        int total = this.routingTable.getClientsRoutes(true).size();
        if (!onlyLocal) {
            Collection<Object> results = CacheFactory.doSynchronousClusterTask(new GetSessionsCountTask(true), false);
            for (Object result : results) {
                if (result == null) continue;
                total += ((Integer)result).intValue();
            }
        }
        return total;
    }

    public int getIncomingServerSessionsCount(boolean onlyLocal) {
        int total = this.localSessionManager.getIncomingServerSessions().size();
        if (!onlyLocal) {
            // empty if block
        }
        return total;
    }

    public int getActiveSessionCount(String username) {
        return this.routingTable.getRoutes(new JID(username, this.serverName, null, true), null).size();
    }

    public int getSessionCount(String username) {
        return this.routingTable.getRoutes(new JID(username, this.serverName, null, true), null).size();
    }

    public Collection<ComponentSession> getComponentSessions() {
        ArrayList<ComponentSession> sessions = new ArrayList<ComponentSession>();
        sessions.addAll(this.localSessionManager.getComponentsSessions());
        RemoteSessionLocator locator = this.server.getRemoteSessionLocator();
        if (locator != null) {
            for (Map.Entry entry : this.componentSessionsCache.entrySet()) {
                if (this.server.getNodeID().equals((byte[])entry.getValue())) continue;
                sessions.add(locator.getComponentSession((byte[])entry.getValue(), new JID((String)entry.getKey())));
            }
        }
        return sessions;
    }

    public ComponentSession getComponentSession(String domain) {
        byte[] byArray;
        for (ComponentSession componentSession : this.localSessionManager.getComponentsSessions()) {
            if (!domain.equals(componentSession.getAddress().getDomain())) continue;
            return componentSession;
        }
        RemoteSessionLocator locator = this.server.getRemoteSessionLocator();
        if (locator != null && (byArray = (byte[])this.componentSessionsCache.get(domain)) != null) {
            return locator.getComponentSession(byArray, new JID(domain));
        }
        return null;
    }

    public Collection<String> getIncomingServers() {
        return this.hostnameSessionsCache.keySet();
    }

    public Collection<String> getOutgoingServers() {
        return this.routingTable.getServerHostnames();
    }

    public Collection<DomainPair> getOutgoingDomainPairs() {
        return this.routingTable.getServerRoutes();
    }

    public void broadcast(Message packet) {
        this.routingTable.broadcastPacket(packet, false);
    }

    public void userBroadcast(String username, Packet packet) throws PacketException {
        for (JID address : this.routingTable.getRoutes(new JID(username, this.serverName, null), null)) {
            packet.setTo(address);
            this.routingTable.routePacket(address, packet, true);
        }
    }

    public boolean removeSession(LocalClientSession session) {
        if (session == null || this.serverName == null) {
            return false;
        }
        AuthToken authToken = session.getAuthToken();
        boolean anonymous = authToken == null || authToken.isAnonymous();
        return this.removeSession(session, session.getAddress(), anonymous, false);
    }

    public boolean removeSession(ClientSession session, JID fullJID, boolean anonymous, boolean forceUnavailable) {
        boolean preauth_removed;
        boolean removed;
        if (this.serverName == null) {
            return false;
        }
        if (session == null) {
            session = this.getSession(fullJID);
        }
        if (removed = this.routingTable.removeClientRoute(fullJID)) {
            if (anonymous) {
                SessionEventDispatcher.dispatchEvent(session, SessionEventDispatcher.EventType.anonymous_session_destroyed);
            } else {
                SessionEventDispatcher.dispatchEvent(session, SessionEventDispatcher.EventType.session_destroyed);
            }
        }
        boolean bl = preauth_removed = this.localSessionManager.getPreAuthenticatedSessions().remove(fullJID.getResource()) != null;
        if (forceUnavailable || session.getPresence().isAvailable()) {
            Presence offline = new Presence();
            offline.setFrom(fullJID);
            offline.setTo(new JID(null, this.serverName, null, true));
            offline.setType(Presence.Type.unavailable);
            this.router.route(offline);
        }
        this.sessionInfoCache.remove(fullJID.toString());
        if (removed || preauth_removed) {
            this.connectionsCounter.decrementAndGet();
            return true;
        }
        return false;
    }

    public int getConflictKickLimit() {
        return this.conflictLimit;
    }

    public Collection<String> getPreAuthenticatedKeys() {
        return this.localSessionManager.getPreAuthenticatedSessions().keySet();
    }

    public boolean isPreAuthenticatedSession(JID address) {
        return this.serverName.equals(address.getDomain()) && this.localSessionManager.getPreAuthenticatedSessions().containsKey(address.getResource());
    }

    public void setConflictKickLimit(int limit) {
        this.conflictLimit = limit;
        JiveGlobals.setProperty("xmpp.session.conflict-limit", Integer.toString(this.conflictLimit));
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.server = server;
        this.router = server.getPacketRouter();
        this.userManager = server.getUserManager();
        this.routingTable = server.getRoutingTable();
        this.serverName = server.getServerInfo().getXMPPDomain();
        this.serverAddress = new JID(this.serverName);
        this.streamIDFactory = JiveGlobals.getBooleanProperty("xmpp.audit.active") ? new AuditStreamIDFactory() : new BasicStreamIDFactory();
        String conflictLimitProp = JiveGlobals.getProperty("xmpp.session.conflict-limit");
        if (conflictLimitProp == null) {
            this.conflictLimit = 0;
            JiveGlobals.setProperty("xmpp.session.conflict-limit", Integer.toString(this.conflictLimit));
        } else {
            try {
                this.conflictLimit = Integer.parseInt(conflictLimitProp);
            }
            catch (NumberFormatException e) {
                this.conflictLimit = 0;
                JiveGlobals.setProperty("xmpp.session.conflict-limit", Integer.toString(this.conflictLimit));
            }
        }
        this.componentSessionsCache = CacheFactory.createCache(COMPONENT_SESSION_CACHE_NAME);
        this.multiplexerSessionsCache = CacheFactory.createCache(CM_CACHE_NAME);
        this.incomingServerSessionsCache = CacheFactory.createCache(ISS_CACHE_NAME);
        this.hostnameSessionsCache = CacheFactory.createCache("Sessions by Hostname");
        this.validatedDomainsCache = CacheFactory.createCache("Validated Domains");
        this.sessionInfoCache = CacheFactory.createCache(C2S_INFO_CACHE_NAME);
        ClusterManager.addListener(this);
    }

    public void sendServerMessage(String subject, String body) {
        this.sendServerMessage(null, subject, body);
    }

    public void sendServerMessage(JID address, String subject, String body) {
        Message packet = this.createServerMessage(subject, body);
        if (address == null || address.getNode() == null || !this.userManager.isRegisteredUser(address)) {
            this.broadcast(packet);
        } else if (address.getResource() == null || address.getResource().length() < 1) {
            this.userBroadcast(address.getNode(), (Packet)packet);
        } else {
            this.routingTable.routePacket(address, (Packet)packet, true);
        }
    }

    private Message createServerMessage(String subject, String body) {
        Message message = new Message();
        message.setFrom(this.serverAddress);
        if (subject != null) {
            message.setSubject(subject);
        }
        message.setBody(body);
        return message;
    }

    @Override
    public void start() throws IllegalStateException {
        super.start();
        this.localSessionManager.start();
        int period = 180000;
        TaskEngine.getInstance().scheduleAtFixedRate((TimerTask)new DetachedCleanupTask(), period, (long)period);
    }

    @Override
    public void stop() {
        Log.debug("SessionManager: Stopping server");
        OutgoingSessionPromise.getInstance().shutdown();
        if (JiveGlobals.getBooleanProperty("shutdownMessage.enabled")) {
            this.sendServerMessage(null, LocaleUtils.getLocalizedString("admin.shutdown.now"));
        }
        this.localSessionManager.stop();
        this.serverName = null;
    }

    public boolean isMultipleServerConnectionsAllowed() {
        return JiveGlobals.getBooleanProperty("xmpp.server.session.allowmultiple", true);
    }

    public void setMultipleServerConnectionsAllowed(boolean allowed) {
        JiveGlobals.setProperty("xmpp.server.session.allowmultiple", Boolean.toString(allowed));
        if (allowed && JiveGlobals.getIntProperty("xmpp.server.session.idle", 600000) <= 0) {
            Log.warn("Allowing multiple S2S connections for each domain, without setting a maximum idle timeout for these connections, is unrecommended! Either set xmpp.server.session.allowmultiple to 'false' or change xmpp.server.session.idle to a (large) positive value.");
        }
    }

    public void setServerSessionTimeout(int timeout) {
        if (this.getServerSessionTimeout() == timeout) {
            return;
        }
        JiveGlobals.setProperty("xmpp.server.session.timeout", Integer.toString(timeout));
    }

    public int getServerSessionTimeout() {
        return JiveGlobals.getIntProperty("xmpp.server.session.timeout", 300000);
    }

    public void setServerSessionIdleTime(int idleTime) {
        if (this.getServerSessionIdleTime() == idleTime) {
            return;
        }
        JiveGlobals.setProperty("xmpp.server.session.idle", Integer.toString(idleTime));
        if (idleTime <= 0 && this.isMultipleServerConnectionsAllowed()) {
            Log.warn("Allowing multiple S2S connections for each domain, without setting a maximum idle timeout for these connections, is unrecommended! Either set xmpp.server.session.allowmultiple to 'false' or change xmpp.server.session.idle to a (large) positive value.");
        }
    }

    public int getServerSessionIdleTime() {
        return JiveGlobals.getIntProperty("xmpp.server.session.idle", 600000);
    }

    public void setSessionDetachTime(int idleTime) {
        if (this.getSessionDetachTime() == idleTime) {
            return;
        }
        JiveGlobals.setProperty("xmpp.session.detach.timeout", Integer.toString(idleTime));
    }

    public int getSessionDetachTime() {
        return JiveGlobals.getIntProperty("xmpp.session.detach.timeout", 600000);
    }

    public Cache<String, ClientSessionInfo> getSessionInfoCache() {
        return this.sessionInfoCache;
    }

    @Override
    public void joinedCluster() {
        this.restoreCacheContent();
        for (ClientSession session : this.routingTable.getClientsRoutes(true)) {
            this.sessionInfoCache.put(session.getAddress().toString(), new ClientSessionInfo((LocalClientSession)session));
        }
    }

    @Override
    public void joinedCluster(byte[] nodeID) {
    }

    @Override
    public void leftCluster() {
        if (!XMPPServer.getInstance().isShuttingDown()) {
            this.restoreCacheContent();
        }
    }

    @Override
    public void leftCluster(byte[] nodeID) {
    }

    @Override
    public void markedAsSeniorClusterMember() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreCacheContent() {
        for (Session session : this.localSessionManager.getComponentsSessions()) {
            this.componentSessionsCache.put(session.getAddress().toString(), this.server.getNodeID().toByteArray());
        }
        for (String string : this.localSessionManager.getConnnectionManagerSessions().keySet()) {
            this.multiplexerSessionsCache.put(string, this.server.getNodeID().toByteArray());
        }
        for (LocalIncomingServerSession localIncomingServerSession : this.localSessionManager.getIncomingServerSessions()) {
            StreamID streamID = localIncomingServerSession.getStreamID();
            this.incomingServerSessionsCache.put(streamID, this.server.getNodeID().toByteArray());
            for (String hostname : localIncomingServerSession.getValidatedDomains()) {
                Lock lock = CacheFactory.getLock(hostname, this.hostnameSessionsCache);
                try {
                    lock.lock();
                    ArrayList<StreamID> streamIDs = (ArrayList<StreamID>)this.hostnameSessionsCache.get(hostname);
                    if (streamIDs == null) {
                        streamIDs = new ArrayList<StreamID>();
                    }
                    streamIDs.add(streamID);
                    this.hostnameSessionsCache.put(hostname, streamIDs);
                }
                finally {
                    lock.unlock();
                }
                lock = CacheFactory.getLock(streamID, this.validatedDomainsCache);
                try {
                    boolean added;
                    lock.lock();
                    HashSet<String> validatedDomains = (HashSet<String>)this.validatedDomainsCache.get(streamID);
                    if (validatedDomains == null) {
                        validatedDomains = new HashSet<String>();
                    }
                    if (!(added = validatedDomains.add(hostname))) continue;
                    this.validatedDomainsCache.put(streamID, validatedDomains);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    private class DetachedCleanupTask
    extends TimerTask {
        private DetachedCleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int idleTime = SessionManager.this.getSessionDetachTime();
            if (idleTime == -1) {
                return;
            }
            long deadline = System.currentTimeMillis() - (long)idleTime;
            for (LocalSession session : SessionManager.this.detachedSessions.values()) {
                try {
                    if (session.getLastActiveDate().getTime() >= deadline) continue;
                    SessionManager.this.removeDetached(session);
                    LocalClientSession clientSession = (LocalClientSession)session;
                    if (clientSession == null) continue;
                    try {
                        if ((clientSession.getPresence().isAvailable() || !clientSession.wasAvailable()) && SessionManager.this.routingTable.hasClientRoute(session.getAddress())) {
                            Presence presence = new Presence();
                            presence.setType(Presence.Type.unavailable);
                            presence.setFrom(session.getAddress());
                            SessionManager.this.router.route(presence);
                        }
                        session.getStreamManager().onClose(SessionManager.this.router, SessionManager.this.serverAddress);
                    }
                    finally {
                        SessionManager.this.removeSession(clientSession);
                    }
                }
                catch (Throwable e) {
                    Log.error(LocaleUtils.getLocalizedString("admin.error"), e);
                }
            }
        }
    }

    private class ConnectionMultiplexerSessionListener
    implements ConnectionCloseListener {
        private ConnectionMultiplexerSessionListener() {
        }

        @Override
        public void onConnectionClose(Object handback) {
            ConnectionMultiplexerSession session = (ConnectionMultiplexerSession)handback;
            String domain = session.getAddress().getDomain();
            SessionManager.this.localSessionManager.getConnnectionManagerSessions().remove(session.getAddress().toString());
            SessionManager.this.multiplexerSessionsCache.remove(session.getAddress().toString());
            if (SessionManager.this.getConnectionMultiplexerSessions(domain).isEmpty()) {
                ConnectionMultiplexerManager.getInstance().multiplexerUnavailable(domain);
            }
        }
    }

    private class OutgoingServerSessionListener
    implements ConnectionCloseListener {
        private OutgoingServerSessionListener() {
        }

        @Override
        public void onConnectionClose(Object handback) {
            OutgoingServerSession session = (OutgoingServerSession)handback;
            for (DomainPair domainPair : session.getOutgoingDomainPairs()) {
                SessionManager.this.server.getRoutingTable().removeServerRoute(domainPair);
            }
        }
    }

    private class IncomingServerSessionListener
    implements ConnectionCloseListener {
        private IncomingServerSessionListener() {
        }

        @Override
        public void onConnectionClose(Object handback) {
            IncomingServerSession session = (IncomingServerSession)handback;
            for (String hostname : session.getValidatedDomains()) {
                SessionManager.this.unregisterIncomingServerSession(hostname, session);
            }
        }
    }

    private class ComponentSessionListener
    implements ConnectionCloseListener {
        private ComponentSessionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionClose(Object handback) {
            LocalComponentSession session = (LocalComponentSession)handback;
            try {
                for (String domain : session.getExternalComponent().getSubdomains()) {
                    String subdomain = domain.substring(0, domain.indexOf(SessionManager.this.serverName) - 1);
                    InternalComponentManager.getInstance().removeComponent(subdomain, session.getExternalComponent());
                }
            }
            catch (Exception e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error.close"), (Throwable)e);
            }
            finally {
                SessionManager.this.localSessionManager.getComponentsSessions().remove(session);
                if (!InternalComponentManager.getInstance().hasComponent(session.getAddress())) {
                    SessionManager.this.componentSessionsCache.remove(session.getAddress().toString());
                }
            }
        }
    }

    private class ClientSessionListener
    implements ConnectionCloseListener {
        private ClientSessionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionClose(Object handback) {
            try {
                LocalClientSession session = (LocalClientSession)handback;
                if (session.isDetached()) {
                    Log.debug("Closing session is detached already.");
                    return;
                }
                if (session.getStreamManager().getResume()) {
                    Log.debug("Closing session has SM enabled; detaching.");
                    session.setDetached();
                    return;
                }
                try {
                    if ((session.getPresence().isAvailable() || !session.wasAvailable()) && SessionManager.this.routingTable.hasClientRoute(session.getAddress())) {
                        Presence presence = new Presence();
                        presence.setType(Presence.Type.unavailable);
                        presence.setFrom(session.getAddress());
                        SessionManager.this.router.route(presence);
                    }
                    session.getStreamManager().onClose(SessionManager.this.router, SessionManager.this.serverAddress);
                }
                finally {
                    SessionManager.this.removeSession(session);
                }
            }
            catch (Exception e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error.close"), (Throwable)e);
            }
        }
    }
}

