/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.QName;
import org.jivesoftware.openfire.MulticastRouter;
import org.jivesoftware.openfire.OfflineMessageStrategy;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.carbons.Sent;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.forward.Forwarded;
import org.jivesoftware.openfire.interceptor.InterceptorManager;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.PacketExtension;

public class MessageRouter
extends BasicModule {
    private static Logger log = LoggerFactory.getLogger(MessageRouter.class);
    private OfflineMessageStrategy messageStrategy;
    private RoutingTable routingTable;
    private SessionManager sessionManager;
    private MulticastRouter multicastRouter;
    private UserManager userManager;
    private String serverName;

    public MessageRouter() {
        super("XMPP Message Router");
    }

    public void route(Message packet) {
        block16: {
            if (packet == null) {
                throw new NullPointerException();
            }
            ClientSession session = this.sessionManager.getSession(packet.getFrom());
            try {
                InterceptorManager.getInstance().invokeInterceptors((Packet)packet, session, true, false);
                if (session == null || session.getStatus() == 3) {
                    JID recipientJID = packet.getTo();
                    if (recipientJID == null) {
                        recipientJID = packet.getFrom().asBareJID();
                    }
                    if (recipientJID.getNode() == null && recipientJID.getResource() == null && this.serverName.equals(recipientJID.getDomain())) {
                        if (packet.getElement().element("addresses") != null) {
                            this.multicastRouter.route((Packet)packet);
                        } else {
                            this.sendMessageToAdmins(packet);
                        }
                        return;
                    }
                    boolean isAcceptable = true;
                    if (session instanceof LocalClientSession) {
                        Message dummyMessage = packet.createCopy();
                        dummyMessage.setFrom(packet.getTo());
                        dummyMessage.setTo(packet.getFrom());
                        if (!((LocalClientSession)session).canProcess((Packet)dummyMessage)) {
                            packet.setTo(session.getAddress());
                            packet.setFrom((JID)null);
                            packet.setError(PacketError.Condition.not_acceptable);
                            session.process((Packet)packet);
                            isAcceptable = false;
                        }
                    }
                    if (isAcceptable) {
                        boolean isPrivate = packet.getElement().element(QName.get((String)"private", (String)"urn:xmpp:carbons:2")) != null;
                        try {
                            this.routingTable.routePacket(recipientJID, (Packet)packet, false);
                        }
                        catch (Exception e) {
                            log.error("Failed to route packet: " + packet.toXML(), (Throwable)e);
                            this.routingFailed(recipientJID, (Packet)packet);
                        }
                        if (packet.getType() == Message.Type.chat && !isPrivate && session != null) {
                            List<JID> routes = this.routingTable.getRoutes(packet.getFrom().asBareJID(), null);
                            for (JID route : routes) {
                                ClientSession clientSession;
                                if (route.equals((Object)session.getAddress()) || (clientSession = this.sessionManager.getSession(route)) == null || !clientSession.isMessageCarbonsEnabled()) continue;
                                Message message = new Message();
                                message.setType(packet.getType());
                                message.setFrom(packet.getFrom().asBareJID());
                                message.setTo(route);
                                message.addExtension((PacketExtension)new Sent(new Forwarded(packet)));
                                clientSession.process((Packet)message);
                            }
                        }
                    }
                } else {
                    packet.setTo(session.getAddress());
                    packet.setFrom((JID)null);
                    packet.setError(PacketError.Condition.not_authorized);
                    session.process((Packet)packet);
                }
                InterceptorManager.getInstance().invokeInterceptors((Packet)packet, session, true, true);
            }
            catch (PacketRejectedException e) {
                if (session == null || e.getRejectionMessage() == null || e.getRejectionMessage().trim().length() <= 0) break block16;
                Message reply = new Message();
                reply.setID(packet.getID());
                reply.setTo(session.getAddress());
                reply.setFrom(packet.getTo());
                reply.setType(packet.getType());
                reply.setThread(packet.getThread());
                reply.setBody(e.getRejectionMessage());
                session.process((Packet)reply);
            }
        }
    }

    private void sendMessageToAdmins(Message packet) {
        String jids = JiveGlobals.getProperty("xmpp.forward.admins");
        if (jids != null && jids.trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(jids, ", ");
            while (tokenizer.hasMoreTokens()) {
                String username = tokenizer.nextToken();
                Message forward = packet.createCopy();
                if (username.contains("@")) {
                    forward.setTo(username);
                } else {
                    forward.setTo(username + "@" + this.serverName);
                }
                this.route(forward);
            }
        } else {
            for (JID jid : XMPPServer.getInstance().getAdmins()) {
                Message forward = packet.createCopy();
                forward.setTo(jid);
                this.route(forward);
            }
        }
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.messageStrategy = server.getOfflineMessageStrategy();
        this.routingTable = server.getRoutingTable();
        this.sessionManager = server.getSessionManager();
        this.multicastRouter = server.getMulticastRouter();
        this.userManager = server.getUserManager();
        this.serverName = server.getServerInfo().getXMPPDomain();
    }

    public void routingFailed(JID recipient, Packet packet) {
        log.debug("Message sent to unreachable address: " + packet.toXML());
        Message msg = (Message)packet;
        boolean storeOffline = true;
        if (msg.getType().equals((Object)Message.Type.chat) && this.serverName.equals(recipient.getDomain()) && recipient.getResource() != null) {
            for (JID address : this.routingTable.getRoutes(recipient.asBareJID(), packet.getFrom())) {
                ClientSession session = this.routingTable.getClientRoute(address);
                if (session == null || !session.isInitialized() || session.getPresence().getPriority() < 1) continue;
                storeOffline = false;
            }
        }
        if (!storeOffline) {
            this.routingTable.routePacket(recipient.asBareJID(), packet, false);
        } else {
            this.messageStrategy.storeOffline((Message)packet);
        }
    }
}

