/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.MulticastRouter;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.interceptor.InterceptorManager;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.privacy.PrivacyList;
import org.jivesoftware.openfire.privacy.PrivacyListManager;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.DomainPair;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.TaskEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.IQResultListener;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;

public class IQRouter
extends BasicModule {
    private static final Logger Log = LoggerFactory.getLogger(IQRouter.class);
    private RoutingTable routingTable;
    private MulticastRouter multicastRouter;
    private String serverName;
    private List<IQHandler> iqHandlers = new ArrayList<IQHandler>();
    private Map<String, IQHandler> namespace2Handlers = new ConcurrentHashMap<String, IQHandler>();
    private Map<String, IQResultListener> resultListeners = new ConcurrentHashMap<String, IQResultListener>();
    private Map<String, Long> resultTimeout = new ConcurrentHashMap<String, Long>();
    private SessionManager sessionManager;
    private UserManager userManager;

    public IQRouter() {
        super("XMPP IQ Router");
    }

    public void route(IQ packet) {
        block11: {
            if (packet == null) {
                throw new NullPointerException();
            }
            JID sender = packet.getFrom();
            ClientSession session = this.sessionManager.getSession(sender);
            Element childElement = packet.getChildElement();
            try {
                InterceptorManager.getInstance().invokeInterceptors((Packet)packet, session, true, false);
                JID to = packet.getTo();
                if (session != null && to != null && session.getStatus() == 1 && !this.serverName.equals(to.toString())) {
                    IQ reply = IQ.createResultIQ((IQ)packet);
                    if (childElement != null) {
                        reply.setChildElement(childElement.createCopy());
                    }
                    reply.setError(PacketError.Condition.bad_request);
                    session.process((Packet)reply);
                    Log.warn("User tried to authenticate with this server using an unknown receipient: " + packet.toXML());
                } else if (session == null || session.getStatus() == 3 || childElement != null && this.isLocalServer(to) && ("jabber:iq:auth".equals(childElement.getNamespaceURI()) || "jabber:iq:register".equals(childElement.getNamespaceURI()) || "urn:ietf:params:xml:ns:xmpp-bind".equals(childElement.getNamespaceURI()))) {
                    this.handle(packet);
                } else if (packet.getType() == IQ.Type.get || packet.getType() == IQ.Type.set) {
                    IQ reply = IQ.createResultIQ((IQ)packet);
                    if (childElement != null) {
                        reply.setChildElement(childElement.createCopy());
                    }
                    reply.setError(PacketError.Condition.not_authorized);
                    session.process((Packet)reply);
                }
                InterceptorManager.getInstance().invokeInterceptors((Packet)packet, session, true, true);
            }
            catch (PacketRejectedException e) {
                if (session == null) break block11;
                IQ reply = new IQ();
                if (childElement != null) {
                    reply.setChildElement(childElement.createCopy());
                }
                reply.setID(packet.getID());
                reply.setTo(session.getAddress());
                reply.setFrom(packet.getTo());
                reply.setError(PacketError.Condition.not_allowed);
                session.process((Packet)reply);
                if (e.getRejectionMessage() == null || e.getRejectionMessage().trim().length() <= 0) break block11;
                Message notification = new Message();
                notification.setTo(session.getAddress());
                notification.setFrom(packet.getTo());
                notification.setBody(e.getRejectionMessage());
                session.process((Packet)notification);
            }
        }
    }

    public void addHandler(IQHandler handler) {
        if (this.iqHandlers.contains(handler)) {
            throw new IllegalArgumentException("IQHandler already provided by the server");
        }
        handler.initialize(XMPPServer.getInstance());
        this.namespace2Handlers.put(handler.getInfo().getNamespace(), handler);
    }

    public void removeHandler(IQHandler handler) {
        if (this.iqHandlers.contains(handler)) {
            throw new IllegalArgumentException("Cannot remove an IQHandler provided by the server");
        }
        this.namespace2Handlers.remove(handler.getInfo().getNamespace());
    }

    public void addIQResultListener(String id, IQResultListener listener) {
        this.addIQResultListener(id, listener, 60000L);
    }

    public void addIQResultListener(String id, IQResultListener listener, long timeoutmillis) {
        this.resultListeners.put(id, listener);
        this.resultTimeout.put(id, System.currentTimeMillis() + timeoutmillis);
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        TaskEngine.getInstance().scheduleAtFixedRate((TimerTask)new TimeoutTask(), 5000L, 5000L);
        this.serverName = server.getServerInfo().getXMPPDomain();
        this.routingTable = server.getRoutingTable();
        this.multicastRouter = server.getMulticastRouter();
        this.iqHandlers.addAll(server.getIQHandlers());
        this.sessionManager = server.getSessionManager();
        this.userManager = server.getUserManager();
    }

    private boolean isLocalServer(JID recipientJID) {
        boolean implicitServer;
        boolean bl = implicitServer = recipientJID == null || recipientJID.getDomain() == null || "".equals(recipientJID.getDomain());
        if (!implicitServer) {
            if (recipientJID.getNode() == null || recipientJID.getResource() == null) {
                return this.serverName.equals(recipientJID.getDomain());
            }
            return false;
        }
        return true;
    }

    private void handle(IQ packet) {
        block26: {
            IQResultListener iqResultListener;
            Element childElement;
            JID recipientJID = packet.getTo();
            if (recipientJID != null && recipientJID.getNode() == null && recipientJID.getResource() == null && this.serverName.equals(recipientJID.getDomain()) && (childElement = packet.getChildElement()) != null && childElement.element("addresses") != null) {
                this.multicastRouter.route((Packet)packet);
                return;
            }
            if (packet.getID() != null && (IQ.Type.result == packet.getType() || IQ.Type.error == packet.getType()) && (iqResultListener = this.resultListeners.remove(packet.getID())) != null) {
                this.resultTimeout.remove(packet.getID());
                if (iqResultListener != null) {
                    try {
                        iqResultListener.receivedAnswer(packet);
                    }
                    catch (Exception e) {
                        Log.error("Error processing answer of remote entity. Answer: " + packet.toXML(), (Throwable)e);
                    }
                    return;
                }
            }
            try {
                if (recipientJID != null && (this.routingTable.hasComponentRoute(recipientJID) || this.routingTable.hasServerRoute(new DomainPair(packet.getFrom().getDomain(), recipientJID.getDomain())))) {
                    this.routingTable.routePacket(recipientJID, (Packet)packet, false);
                    return;
                }
                if (this.isLocalServer(recipientJID)) {
                    childElement = packet.getChildElement();
                    String namespace = null;
                    if (childElement != null) {
                        namespace = childElement.getNamespaceURI();
                    }
                    if (namespace == null) {
                        if (packet.getType() != IQ.Type.result && packet.getType() != IQ.Type.error) {
                            Log.warn("Unknown packet " + packet.toXML());
                        }
                    } else {
                        PrivacyList list;
                        if (recipientJID != null && this.userManager.isRegisteredUser(recipientJID.getNode()) && (list = PrivacyListManager.getInstance().getDefaultPrivacyList(recipientJID.getNode())) != null && list.shouldBlockPacket((Packet)packet)) {
                            if (IQ.Type.set == packet.getType() || IQ.Type.get == packet.getType()) {
                                this.sendErrorPacket(packet, PacketError.Condition.service_unavailable);
                            }
                            return;
                        }
                        IQHandler handler = this.getHandler(namespace);
                        if (handler == null) {
                            if (recipientJID == null) {
                                this.sendErrorPacket(packet, PacketError.Condition.service_unavailable);
                            } else if (recipientJID.getNode() == null || "".equals(recipientJID.getNode())) {
                                this.sendErrorPacket(packet, PacketError.Condition.feature_not_implemented);
                            } else {
                                this.sendErrorPacket(packet, PacketError.Condition.service_unavailable);
                            }
                        } else {
                            handler.process((Packet)packet);
                        }
                    }
                } else {
                    if (recipientJID != null && recipientJID.getNode() != null && this.serverName.equals(recipientJID.getDomain()) && !this.userManager.isRegisteredUser(recipientJID.getNode()) && this.sessionManager.getSession(recipientJID) == null && (IQ.Type.set == packet.getType() || IQ.Type.get == packet.getType())) {
                        this.sendErrorPacket(packet, PacketError.Condition.service_unavailable);
                        return;
                    }
                    ClientSession session = this.sessionManager.getSession(packet.getFrom());
                    boolean isAcceptable = true;
                    if (session instanceof LocalClientSession) {
                        IQ dummyIQ = packet.createCopy();
                        dummyIQ.setFrom(packet.getTo());
                        dummyIQ.setTo(packet.getFrom());
                        if (!((LocalClientSession)session).canProcess((Packet)dummyIQ)) {
                            packet.setTo(session.getAddress());
                            packet.setFrom((JID)null);
                            packet.setError(PacketError.Condition.not_acceptable);
                            session.process((Packet)packet);
                            isAcceptable = false;
                        }
                    }
                    if (isAcceptable) {
                        this.routingTable.routePacket(recipientJID, (Packet)packet, false);
                    }
                }
            }
            catch (Exception e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error.routing"), (Throwable)e);
                ClientSession session = this.sessionManager.getSession(packet.getFrom());
                if (session == null) break block26;
                IQ reply = IQ.createResultIQ((IQ)packet);
                reply.setError(PacketError.Condition.internal_server_error);
                session.process((Packet)reply);
            }
        }
    }

    private void sendErrorPacket(IQ originalPacket, PacketError.Condition condition) {
        if (IQ.Type.error == originalPacket.getType()) {
            Log.error("Cannot reply an IQ error to another IQ error: " + originalPacket.toXML());
            return;
        }
        if (originalPacket.getFrom() == null) {
            if (Log.isDebugEnabled()) {
                Log.debug("Original IQ has no sender for reply; dropped: " + originalPacket.toXML());
            }
            return;
        }
        IQ reply = IQ.createResultIQ((IQ)originalPacket);
        reply.setChildElement(originalPacket.getChildElement().createCopy());
        reply.setError(condition);
        if (this.serverName.equals(originalPacket.getFrom().toString())) {
            this.handle(reply);
            return;
        }
        this.routingTable.routePacket(reply.getTo(), (Packet)reply, true);
    }

    public boolean supports(String namespace) {
        return this.getHandler(namespace) != null;
    }

    private IQHandler getHandler(String namespace) {
        IQHandler handler = this.namespace2Handlers.get(namespace);
        if (handler == null) {
            for (IQHandler handlerCandidate : this.iqHandlers) {
                IQHandlerInfo handlerInfo = handlerCandidate.getInfo();
                if (handlerInfo == null || !namespace.equalsIgnoreCase(handlerInfo.getNamespace())) continue;
                handler = handlerCandidate;
                this.namespace2Handlers.put(namespace, handler);
                break;
            }
        }
        return handler;
    }

    public void routingFailed(JID recipient, Packet packet) {
        Log.debug("IQ sent to unreachable address: " + packet.toXML());
        IQ iq = (IQ)packet;
        if (iq.isRequest()) {
            this.sendErrorPacket(iq, PacketError.Condition.service_unavailable);
        }
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            Iterator it = IQRouter.this.resultTimeout.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pointer = it.next();
                if (System.currentTimeMillis() < (Long)pointer.getValue()) continue;
                String packetId = (String)pointer.getKey();
                IQResultListener listener = (IQResultListener)IQRouter.this.resultListeners.remove(packetId);
                if (listener != null) {
                    listener.answerTimeout(packetId);
                }
                it.remove();
            }
        }
    }
}

