/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.database;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedPreparedStatement {
    private static final Logger Log = LoggerFactory.getLogger(CachedPreparedStatement.class);
    private String sql;
    private List<Object> params = new ArrayList<Object>();
    private List<Integer> types = new ArrayList<Integer>();

    public CachedPreparedStatement() {
    }

    public CachedPreparedStatement(String sql) {
        this();
        this.setSQL(sql);
    }

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public void addBoolean(boolean value) {
        this.params.add(value);
        this.types.add(16);
    }

    public void addInt(int value) {
        this.params.add(value);
        this.types.add(4);
    }

    public void addLong(long value) {
        this.params.add(value);
        this.types.add(-5);
    }

    public void addString(String value) {
        this.params.add(value);
        this.types.add(12);
    }

    public void setParams(PreparedStatement pstmt) throws SQLException {
        block6: for (int i = 0; i < this.params.size(); ++i) {
            Object param = this.params.get(i);
            int type = this.types.get(i);
            switch (type) {
                case 4: {
                    pstmt.setInt(i + 1, (Integer)param);
                    continue block6;
                }
                case -5: {
                    pstmt.setLong(i + 1, (Long)param);
                    continue block6;
                }
                case 12: {
                    pstmt.setString(i + 1, (String)param);
                    continue block6;
                }
                case 16: {
                    pstmt.setBoolean(i + 1, (Boolean)param);
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof CachedPreparedStatement)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        CachedPreparedStatement otherStmt = (CachedPreparedStatement)object;
        return this.sql == null && otherStmt.sql == null || this.sql != null && this.sql.equals(otherStmt.sql) && this.types.equals(otherStmt.types) && this.params.equals(otherStmt.params);
    }

    public int hashCode() {
        int hashCode = 1;
        if (this.sql != null) {
            hashCode += this.sql.hashCode();
        }
        hashCode = hashCode * 31 + this.types.hashCode();
        hashCode = hashCode * 31 + this.params.hashCode();
        return hashCode;
    }

    public String toString() {
        String toStringSql = this.sql;
        try {
            int index = toStringSql.indexOf(63);
            int count = 0;
            while (index > -1) {
                Object param = this.params.get(count);
                int type = this.types.get(count);
                String val = null;
                switch (type) {
                    case 4: {
                        val = "" + param;
                        break;
                    }
                    case -5: {
                        val = "" + param;
                        break;
                    }
                    case 12: {
                        val = '\'' + (String)param + '\'';
                        break;
                    }
                    case 16: {
                        val = "" + param;
                    }
                }
                toStringSql = toStringSql.substring(0, index) + val + (index == toStringSql.length() - 1 ? "" : toStringSql.substring(index + 1));
                index = toStringSql.indexOf(63, index + val.length());
                ++count;
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        return "CachedPreparedStatement{ sql=" + toStringSql + '}';
    }
}

