/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.admin;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminConsole {
    private static final Logger Log = LoggerFactory.getLogger(AdminConsole.class);
    private static Element coreModel;
    private static Map<String, Element> overrideModels;
    private static Element generatedModel;

    private AdminConsole() {
    }

    public static void addModel(String name, InputStream in) throws Exception {
        SAXReader saxReader = new SAXReader();
        Document doc = saxReader.read(in);
        AdminConsole.addModel(name, (Element)doc.selectSingleNode("/adminconsole"));
    }

    public static synchronized void addModel(String name, Element element) throws Exception {
        overrideModels.put(name, element);
        AdminConsole.rebuildModel();
    }

    public static synchronized void removeModel(String name) {
        overrideModels.remove(name);
        AdminConsole.rebuildModel();
    }

    public static synchronized String getAppName() {
        Element appName = (Element)generatedModel.selectSingleNode("//adminconsole/global/appname");
        if (appName != null) {
            String pluginName = appName.attributeValue("plugin");
            return AdminConsole.getAdminText(appName.getText(), pluginName);
        }
        return null;
    }

    public static synchronized String getLogoImage() {
        Element globalLogoImage = (Element)generatedModel.selectSingleNode("//adminconsole/global/logo-image");
        if (globalLogoImage != null) {
            String pluginName = globalLogoImage.attributeValue("plugin");
            return AdminConsole.getAdminText(globalLogoImage.getText(), pluginName);
        }
        return null;
    }

    public static synchronized String getLoginLogoImage() {
        Element globalLoginLogoImage = (Element)generatedModel.selectSingleNode("//adminconsole/global/login-image");
        if (globalLoginLogoImage != null) {
            String pluginName = globalLoginLogoImage.attributeValue("plugin");
            return AdminConsole.getAdminText(globalLoginLogoImage.getText(), pluginName);
        }
        return null;
    }

    public static synchronized String getVersionString() {
        Element globalVersion = (Element)generatedModel.selectSingleNode("//adminconsole/global/version");
        if (globalVersion != null) {
            String pluginName = globalVersion.attributeValue("plugin");
            return AdminConsole.getAdminText(globalVersion.getText(), pluginName);
        }
        XMPPServer xmppServer = XMPPServer.getInstance();
        return xmppServer.getServerInfo().getVersion().getVersionString();
    }

    public static synchronized Element getModel() {
        return generatedModel;
    }

    public static synchronized Element getElemnetByID(String id) {
        return (Element)generatedModel.selectSingleNode("//*[@id='" + id + "']");
    }

    public static String getAdminText(String string, String pluginName) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("${") == 0 && string.indexOf("}") == string.length() - 1) {
            return LocaleUtils.getLocalizedString(string.substring(2, string.length() - 1), pluginName);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() {
        ClassLoader[] classLoaders;
        InputStream in = ClassUtils.getResourceAsStream("/admin-sidebar.xml");
        if (in == null) {
            Log.error("Failed to load admin-sidebar.xml file from Openfire classes - admin console will not work correctly.");
            return;
        }
        try {
            SAXReader saxReader = new SAXReader();
            Document doc = saxReader.read(in);
            coreModel = (Element)doc.selectSingleNode("/adminconsole");
        }
        catch (Exception e) {
            Log.error("Failure when parsing main admin-sidebar.xml file", (Throwable)e);
        }
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (ClassLoader classLoader : classLoaders = AdminConsole.getClassLoaders()) {
            URL url = null;
            try {
                if (classLoader == null) continue;
                Enumeration<URL> e = classLoader.getResources("/META-INF/admin-sidebar.xml");
                while (e.hasMoreElements()) {
                    url = e.nextElement();
                    try {
                        in = url.openStream();
                        AdminConsole.addModel("admin", in);
                    }
                    finally {
                        try {
                            if (in == null) continue;
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                String msg = "Failed to load admin-sidebar.xml";
                if (url != null) {
                    msg = msg + " from resource: " + url.toString();
                }
                Log.warn(msg, (Throwable)e);
            }
        }
        AdminConsole.rebuildModel();
    }

    private static synchronized void rebuildModel() {
        Document doc = DocumentFactory.getInstance().createDocument();
        generatedModel = coreModel.createCopy();
        doc.add(generatedModel);
        for (Element element : overrideModels.values()) {
            Element appVersion;
            Element appLoginImage;
            Element appLogoImage;
            Element appName = (Element)element.selectSingleNode("//adminconsole/global/appname");
            if (appName != null) {
                Element existingAppName = (Element)generatedModel.selectSingleNode("//adminconsole/global/appname");
                existingAppName.setText(appName.getText());
                if (appName.attributeValue("plugin") != null) {
                    existingAppName.addAttribute("plugin", appName.attributeValue("plugin"));
                }
            }
            if ((appLogoImage = (Element)element.selectSingleNode("//adminconsole/global/logo-image")) != null) {
                Element existingLogoImage = (Element)generatedModel.selectSingleNode("//adminconsole/global/logo-image");
                existingLogoImage.setText(appLogoImage.getText());
                if (appLogoImage.attributeValue("plugin") != null) {
                    existingLogoImage.addAttribute("plugin", appLogoImage.attributeValue("plugin"));
                }
            }
            if ((appLoginImage = (Element)element.selectSingleNode("//adminconsole/global/login-image")) != null) {
                Element existingLoginImage = (Element)generatedModel.selectSingleNode("//adminconsole/global/login-image");
                existingLoginImage.setText(appLoginImage.getText());
                if (appLoginImage.attributeValue("plugin") != null) {
                    existingLoginImage.addAttribute("plugin", appLoginImage.attributeValue("plugin"));
                }
            }
            if ((appVersion = (Element)element.selectSingleNode("//adminconsole/global/version")) != null) {
                Element existingVersion = (Element)generatedModel.selectSingleNode("//adminconsole/global/version");
                if (existingVersion != null) {
                    existingVersion.setText(appVersion.getText());
                    if (appVersion.attributeValue("plugin") != null) {
                        existingVersion.addAttribute("plugin", appVersion.attributeValue("plugin"));
                    }
                } else {
                    ((Element)generatedModel.selectSingleNode("//adminconsole/global")).add(appVersion.createCopy());
                }
            }
            for (Object o : element.selectNodes("//tab")) {
                Element tab = (Element)o;
                String id = tab.attributeValue("id");
                Element existingTab = AdminConsole.getElemnetByID(id);
                if (existingTab == null) {
                    Element firstItem;
                    if (tab.attributeValue("url") == null && (firstItem = (Element)tab.selectSingleNode("//item[@url]")) != null) {
                        tab.addAttribute("url", firstItem.attributeValue("url"));
                    }
                    generatedModel.add(tab.createCopy());
                    continue;
                }
                AdminConsole.overrideTab(existingTab, tab);
            }
        }
    }

    private static void overrideTab(Element tab, Element overrideTab) {
        if (overrideTab.attributeValue("name") != null) {
            tab.addAttribute("name", overrideTab.attributeValue("name"));
        }
        if (overrideTab.attributeValue("url") != null) {
            tab.addAttribute("url", overrideTab.attributeValue("url"));
        }
        if (overrideTab.attributeValue("description") != null) {
            tab.addAttribute("description", overrideTab.attributeValue("description"));
        }
        if (overrideTab.attributeValue("plugin") != null) {
            tab.addAttribute("plugin", overrideTab.attributeValue("plugin"));
        }
        Iterator i = overrideTab.elementIterator();
        while (i.hasNext()) {
            Element sidebar = (Element)i.next();
            String id = sidebar.attributeValue("id");
            Element existingSidebar = AdminConsole.getElemnetByID(id);
            if (existingSidebar == null) {
                tab.add(sidebar.createCopy());
                continue;
            }
            AdminConsole.overrideSidebar(existingSidebar, sidebar);
        }
    }

    private static void overrideSidebar(Element sidebar, Element overrideSidebar) {
        if (overrideSidebar.attributeValue("name") != null) {
            sidebar.addAttribute("name", overrideSidebar.attributeValue("name"));
        }
        if (overrideSidebar.attributeValue("plugin") != null) {
            sidebar.addAttribute("plugin", overrideSidebar.attributeValue("plugin"));
        }
        Iterator i = overrideSidebar.elementIterator();
        while (i.hasNext()) {
            Element entry = (Element)i.next();
            String id = entry.attributeValue("id");
            Element existingEntry = AdminConsole.getElemnetByID(id);
            if (existingEntry == null) {
                sidebar.add(entry.createCopy());
                continue;
            }
            AdminConsole.overrideEntry(existingEntry, entry);
        }
    }

    private static void overrideEntry(Element entry, Element overrideEntry) {
        if (overrideEntry.attributeValue("name") != null) {
            entry.addAttribute("name", overrideEntry.attributeValue("name"));
        }
        if (overrideEntry.attributeValue("url") != null) {
            entry.addAttribute("url", overrideEntry.attributeValue("url"));
        }
        if (overrideEntry.attributeValue("description") != null) {
            entry.addAttribute("description", overrideEntry.attributeValue("description"));
        }
        if (overrideEntry.attributeValue("plugin") != null) {
            entry.addAttribute("plugin", overrideEntry.attributeValue("plugin"));
        }
        Iterator i = overrideEntry.elementIterator();
        while (i.hasNext()) {
            Element sidebar = (Element)i.next();
            String id = sidebar.attributeValue("id");
            Element existingSidebar = AdminConsole.getElemnetByID(id);
            if (existingSidebar == null) {
                entry.add(sidebar.createCopy());
                continue;
            }
            AdminConsole.overrideSidebar(existingSidebar, sidebar);
        }
    }

    private static ClassLoader[] getClassLoaders() {
        ClassLoader[] classLoaders = new ClassLoader[]{AdminConsole.class.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()};
        return classLoaders;
    }

    static {
        overrideModels = new LinkedHashMap<String, Element>();
        AdminConsole.load();
    }
}

