/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputresource;

import com.icesoft.faces.component.outputresource.OutputResource;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OutputResourceRenderer
extends DomBasicInputRenderer {
    protected static final String CONTAINER_DIV_SUFFIX = "_cont";

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        OutputResource outputResource = (OutputResource)uiComponent;
        if (outputResource.getResource() != null) {
            DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
            if (!domContext.isInitialized()) {
                domContext.createRootElement("div");
            }
            Element root = (Element)domContext.getRootNode();
            root.setAttribute("id", uiComponent.getClientId(facesContext) + CONTAINER_DIV_SUFFIX);
            domContext.setCursorParent((Node)root);
            String style = outputResource.getStyle();
            String styleClass = outputResource.getStyleClass();
            Element resource = null;
            if ("button".equals(outputResource.getType())) {
                resource = domContext.createElement("input");
                resource.setAttribute("type", "button");
                resource.setAttribute("value", outputResource.getLabel());
                resource.setAttribute("onclick", "window.open('" + outputResource.getPath() + "');");
            } else {
                resource = domContext.createElement("a");
                resource.setAttribute("href", outputResource.getPath());
                resource.setAttribute("target", "blank");
                if (outputResource.getImage() != null) {
                    Element img = domContext.createElement("img");
                    img.setAttribute("src", outputResource.getImage());
                    resource.appendChild(img);
                    img.setAttribute("alt", outputResource.getLabel());
                } else {
                    resource.appendChild(domContext.createTextNode(outputResource.getLabel()));
                }
            }
            resource.setAttribute("id", clientId);
            root.appendChild(resource);
            if (style != null) {
                resource.setAttribute("style", style);
            }
            if (styleClass != null) {
                resource.setAttribute("class", styleClass);
            }
            domContext.stepOver();
            domContext.streamWrite(facesContext, uiComponent);
        }
    }
}

