/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.util;

public class JSONBuilder {
    private StringBuilder params = new StringBuilder();

    public static JSONBuilder create() {
        return new JSONBuilder();
    }

    public JSONBuilder beginMap() {
        this.conditionallyAppendComma();
        this.params.append("{");
        return this;
    }

    public JSONBuilder beginMap(String key) {
        this.appendCommaAndKey(key);
        this.params.append("{");
        return this;
    }

    public JSONBuilder endMap() {
        this.params.append("}");
        return this;
    }

    public JSONBuilder beginArray(String key) {
        this.appendCommaAndKey(key);
        this.params.append("[");
        return this;
    }

    public JSONBuilder endArray() {
        this.params.append("]");
        return this;
    }

    public JSONBuilder beginFunction(String name) {
        this.params.append(name);
        this.params.append('(');
        return this;
    }

    public JSONBuilder endFunction() {
        this.params.append(");");
        return this;
    }

    public JSONBuilder entry(String key, int value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, long value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, float value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, double value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, boolean value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, String[] keyValuePairs) {
        this.beginArray(key);
        int len = keyValuePairs.length;
        for (int idx = 0; idx < len; ++idx) {
            String curr = keyValuePairs[idx];
            if (curr == null) {
                this.params.append("null");
            } else {
                this.params.append('\"').append(JSONBuilder.escapeString(curr)).append('\"');
            }
            if (idx >= len - 1) continue;
            this.params.append(',');
        }
        this.endArray();
        return this;
    }

    public JSONBuilder entryNonNullValue(String key, Integer value) {
        if (value == null) {
            return this;
        }
        return this.entry(key, value);
    }

    public JSONBuilder entryNonNullValue(String key, Long value) {
        if (value == null) {
            return this;
        }
        return this.entry(key, value);
    }

    public JSONBuilder entryNonNullValue(String key, Float value) {
        if (value == null) {
            return this;
        }
        return this.entry(key, value.floatValue());
    }

    public JSONBuilder entryNonNullValue(String key, Double value) {
        if (value == null) {
            return this;
        }
        return this.entry(key, value);
    }

    public JSONBuilder entryNonNullValue(String key, Boolean value) {
        if (value == null) {
            return this;
        }
        return this.entry(key, value);
    }

    public JSONBuilder entryNonNullValue(String key, String value) {
        if (value == null) {
            return this;
        }
        return this.entry(key, value, false);
    }

    public JSONBuilder entry(String key, String value) {
        return this.entry(key, value, false);
    }

    public JSONBuilder entry(String key, String value, boolean isStringLiteral) {
        this.appendCommaAndKey(key);
        if (isStringLiteral) {
            this.params.append(value);
        } else {
            value = JSONBuilder.escapeString(value);
            this.params.append('\"').append(value).append('\"');
        }
        return this;
    }

    public JSONBuilder item(int value) {
        this.conditionallyAppendComma();
        this.params.append(value);
        return this;
    }

    public JSONBuilder item(long value) {
        this.conditionallyAppendComma();
        this.params.append(value);
        return this;
    }

    public JSONBuilder item(float value) {
        this.conditionallyAppendComma();
        this.params.append(value);
        return this;
    }

    public JSONBuilder item(double value) {
        this.conditionallyAppendComma();
        this.params.append(value);
        return this;
    }

    public JSONBuilder item(boolean value) {
        this.conditionallyAppendComma();
        this.params.append(value);
        return this;
    }

    public JSONBuilder item(String value) {
        this.conditionallyAppendComma();
        value = JSONBuilder.escapeString(value);
        this.params.append('\"').append(value).append('\"');
        return this;
    }

    public static String escapeString(String value) {
        StringBuilder sb = new StringBuilder();
        block10: for (int idx = 0; idx < value.length(); ++idx) {
            char c = value.charAt(idx);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.params.toString();
    }

    private void appendCommaAndKey(String key) {
        this.conditionallyAppendComma();
        this.params.append('\"').append(key).append('\"').append(":");
    }

    private void conditionallyAppendComma() {
        char lastChar;
        int len = this.params.length();
        if (len > 0 && (lastChar = this.params.charAt(len - 1)) != '{' && lastChar != '[' && lastChar != '(') {
            this.params.append(",");
        }
    }
}

