/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.renderkit;

import java.io.IOException;
import java.util.ListIterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class HeadRenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("head", component);
        String theme = null;
        String themeParamValue = context.getExternalContext().getInitParameter("org.icefaces.ace.theme");
        if (themeParamValue != null) {
            ELContext elContext = context.getELContext();
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            ValueExpression ve = expressionFactory.createValueExpression(elContext, themeParamValue, String.class);
            theme = (String)ve.getValue(elContext);
        }
        if ("".equals(theme = theme == null ? "" : theme.trim()) || theme.equalsIgnoreCase("sam")) {
            this.encodeTheme(context, "icefaces.ace", "themes/sam/theme.css");
        } else if (theme.equalsIgnoreCase("rime")) {
            this.encodeTheme(context, "icefaces.ace", "themes/rime/theme.css");
        } else if (!theme.equalsIgnoreCase("none")) {
            this.encodeTheme(context, "ace-" + theme, "theme.css");
        }
        UIViewRoot viewRoot = context.getViewRoot();
        ListIterator iter = viewRoot.getComponentResources(context, "head").listIterator();
        while (iter.hasNext()) {
            writer.write("\n");
            UIComponent resource = (UIComponent)iter.next();
            resource.encodeAll(context);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("head");
    }

    private UIComponent createThemeResource(FacesContext fc, String library, String resourceName) {
        UIComponent resource = fc.getApplication().createComponent("javax.faces.Output");
        resource.setRendererType("javax.faces.resource.Stylesheet");
        Map attrs = resource.getAttributes();
        attrs.put("name", resourceName);
        attrs.put("library", library);
        attrs.put("target", "head");
        return resource;
    }

    protected void encodeTheme(FacesContext context, String library, String resource) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write("\n");
        Resource themeResource = context.getApplication().getResourceHandler().createResource(resource, library);
        if (themeResource == null) {
            throw new FacesException("Error loading theme, cannot find \"" + resource + "\" resource of \"" + library + "\" library");
        }
        writer.startElement("link", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("href", (Object)themeResource.getRequestPath(), null);
        writer.endElement("link");
    }
}

