/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.model.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.model.DataModel;
import org.icefaces.ace.model.table.RowState;
import org.icefaces.ace.model.table.TreeDataModel;
import org.icefaces.ace.util.CollectionUtils;
import org.icefaces.ace.util.collections.EntrySetToKeyListTransformer;
import org.icefaces.ace.util.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowStateMap
implements Map<Object, RowState>,
Serializable {
    private Map<Object, RowState> map = new HashMap<Object, RowState>();
    private static Predicate selectedPredicate = new SelectedPredicate();
    private static Predicate selectablePredicate = new SelectablePredicate();
    private static Predicate editablePredicate = new EditablePredicate();
    private static Predicate expandablePredicate = new ExpandablePredicate();
    private static Predicate expandedPredicate = new ExpandedPredicate();
    private static Predicate visiblePredicate = new VisiblePredicate();
    private static Predicate rowExpansionPredicate = new RowExpansionPredicate();
    private static Predicate panelExpansionPredicate = new PanelExpansionPredicate();

    @Override
    public RowState put(Object o, RowState s) {
        return this.map.put(o, s);
    }

    public void add(Object o) {
        this.map.put(o, new RowState());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public RowState get(Object o) {
        RowState s = this.map.get(o);
        if (s == null) {
            this.add(o);
            s = this.map.get(o);
        }
        return s;
    }

    @Override
    public RowState remove(Object o) {
        return this.map.remove(o);
    }

    @Override
    public void putAll(Map m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection values() {
        return this.map.values();
    }

    @Override
    public Set entrySet() {
        return this.map.entrySet();
    }

    public void updateData(Object o) {
        this.map.put(o, this.map.remove(o));
    }

    public void updateData(List data) {
        ArrayList<RowState> values = new ArrayList<RowState>(data.size());
        for (Object d : data) {
            values.add(this.map.remove(d));
        }
        int i = 0;
        for (RowState v : values) {
            if (v != null) {
                this.map.put(data.get(i), v);
            }
            ++i;
        }
    }

    public void removeStates(List data) {
        Set<Object> keys = this.map.keySet();
        keys.removeAll(data);
    }

    public void filterStates(List data) {
        Set<Object> keys = this.map.keySet();
        keys.retainAll(data);
    }

    public void filterStates(DataModel model) {
        Set<Object> keys = this.map.keySet();
        ArrayList<Object> rowDataList = new ArrayList<Object>();
        int rowsToProcess = model.getRowCount();
        while (rowsToProcess > 0) {
            model.setRowIndex(--rowsToProcess);
            if (!model.isRowAvailable()) continue;
            rowDataList.add(model.getRowData());
        }
        keys.retainAll(rowDataList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpandableByTreeModel(TreeDataModel dataModel) {
        String currentRootId = "";
        int rowCount = dataModel.getRowCount();
        int i = 0;
        while (i < rowCount) {
            dataModel.setRowIndex(i++);
            try {
                do {
                    RowState currentModel = this.get(dataModel.getRowData());
                    if (dataModel.getCurrentRowChildCount() == 0) {
                        currentModel.setExpandable(false);
                    }
                    if (dataModel.getCurrentRowChildCount() > 0) {
                        currentModel.setExpandable(true);
                        currentRootId = currentRootId.equals("") ? dataModel.getRowIndex() + "" : currentRootId + "." + dataModel.getRowIndex();
                        dataModel.setRootIndex(currentRootId);
                        dataModel.setRowIndex(0);
                        continue;
                    }
                    if (dataModel.getRowIndex() < dataModel.getRowCount() - 1) {
                        dataModel.setRowIndex(dataModel.getRowIndex() + 1);
                        continue;
                    }
                    if (currentRootId.equals("")) continue;
                    int lastSiblingRowIndex = dataModel.pop();
                    while (lastSiblingRowIndex == dataModel.getRowCount() - 1 && dataModel.isRootIndexSet()) {
                        lastSiblingRowIndex = dataModel.pop();
                        currentRootId = currentRootId.lastIndexOf(46) != -1 ? currentRootId.substring(0, currentRootId.lastIndexOf(46)) : "";
                    }
                    dataModel.setRowIndex(lastSiblingRowIndex + 1);
                    String string = currentRootId = currentRootId.lastIndexOf(46) != -1 ? currentRootId.substring(0, currentRootId.lastIndexOf(46)) : "";
                } while (!currentRootId.equals(""));
            }
            finally {
                dataModel.setRowIndex(-1);
                dataModel.setRootIndex(null);
            }
        }
    }

    public List getSelected() {
        return EntrySetToKeyListTransformer.transform(CollectionUtils.select(this.map.entrySet(), selectedPredicate));
    }

    public List getSelectable() {
        return EntrySetToKeyListTransformer.transform(CollectionUtils.select(this.map.entrySet(), selectablePredicate));
    }

    public List getEditable() {
        return EntrySetToKeyListTransformer.transform(CollectionUtils.select(this.map.entrySet(), editablePredicate));
    }

    public List getExpanded() {
        return EntrySetToKeyListTransformer.transform(CollectionUtils.select(this.map.entrySet(), expandedPredicate));
    }

    public List getExpandable() {
        return EntrySetToKeyListTransformer.transform(CollectionUtils.select(this.map.entrySet(), expandablePredicate));
    }

    public List getVisible() {
        return EntrySetToKeyListTransformer.transform(CollectionUtils.select(this.map.entrySet(), visiblePredicate));
    }

    public List getEditing(UIComponent editor) {
        return EntrySetToKeyListTransformer.transform(CollectionUtils.select(this.map.entrySet(), new EditingPredicate(editor)));
    }

    public List getRowExpanders() {
        return EntrySetToKeyListTransformer.transform(CollectionUtils.select(this.map.entrySet(), rowExpansionPredicate));
    }

    public List getPanelExpanders() {
        return EntrySetToKeyListTransformer.transform(CollectionUtils.select(this.map.entrySet(), panelExpansionPredicate));
    }

    public void setAllSelected(boolean value) {
        for (RowState s : this.map.values()) {
            s.setSelected(value);
        }
    }

    public void setAllSelectable(boolean value) {
        for (RowState s : this.map.values()) {
            s.setSelectable(value);
        }
    }

    public void setAllEditable(boolean value) {
        for (RowState s : this.map.values()) {
            s.setEditable(value);
        }
    }

    public void setAllExpanded(boolean value) {
        for (RowState s : this.map.values()) {
            s.setExpanded(value);
        }
    }

    public void setAllExpandable(boolean value) {
        for (RowState s : this.map.values()) {
            s.setExpandable(value);
        }
    }

    public void setAllVisible(boolean value) {
        for (RowState s : this.map.values()) {
            s.setVisible(value);
        }
    }

    public void setAllRowExpansion() {
        for (RowState s : this.map.values()) {
            s.setExpansionType(RowState.ExpansionType.ROW);
        }
    }

    public void setAllPanelExpansion() {
        for (RowState s : this.map.values()) {
            s.setExpansionType(RowState.ExpansionType.PANEL);
        }
    }

    public void setAllEditing(UIComponent editor, boolean add) {
        for (RowState s : this.map.values()) {
            if (add) {
                s.addActiveCellEditor(editor);
                continue;
            }
            s.removeActiveCellEditor(editor);
        }
    }

    private class EditingPredicate
    implements Predicate {
        String id;

        public EditingPredicate(UIComponent editor) {
            this.id = editor.getId();
        }

        public boolean evaluate(Object object) {
            return object instanceof Map.Entry && ((RowState)((Map.Entry)object).getValue()).activeCellEditorIds.contains(object);
        }
    }

    static class PanelExpansionPredicate
    implements Predicate {
        PanelExpansionPredicate() {
        }

        public boolean evaluate(Object o) {
            return o instanceof Map.Entry && ((RowState)((Map.Entry)o).getValue()).getExpansionType().equals((Object)RowState.ExpansionType.PANEL);
        }
    }

    static class RowExpansionPredicate
    implements Predicate {
        RowExpansionPredicate() {
        }

        public boolean evaluate(Object o) {
            return o instanceof Map.Entry && ((RowState)((Map.Entry)o).getValue()).getExpansionType().equals((Object)RowState.ExpansionType.ROW);
        }
    }

    static class VisiblePredicate
    implements Predicate {
        VisiblePredicate() {
        }

        public boolean evaluate(Object o) {
            return o instanceof Map.Entry && ((RowState)((Map.Entry)o).getValue()).isVisible();
        }
    }

    static class EditablePredicate
    implements Predicate {
        EditablePredicate() {
        }

        public boolean evaluate(Object o) {
            return o instanceof Map.Entry && ((RowState)((Map.Entry)o).getValue()).isEditable();
        }
    }

    static class ExpandablePredicate
    implements Predicate {
        ExpandablePredicate() {
        }

        public boolean evaluate(Object o) {
            return o instanceof Map.Entry && ((RowState)((Map.Entry)o).getValue()).isExpandable();
        }
    }

    static class ExpandedPredicate
    implements Predicate {
        ExpandedPredicate() {
        }

        public boolean evaluate(Object o) {
            return o instanceof Map.Entry && ((RowState)((Map.Entry)o).getValue()).isExpanded();
        }
    }

    static class SelectablePredicate
    implements Predicate {
        SelectablePredicate() {
        }

        public boolean evaluate(Object o) {
            return o instanceof Map.Entry && ((RowState)((Map.Entry)o).getValue()).isSelectable();
        }
    }

    static class SelectedPredicate
    implements Predicate {
        SelectedPredicate() {
        }

        public boolean evaluate(Object o) {
            return o instanceof Map.Entry && ((RowState)((Map.Entry)o).getValue()).isSelected();
        }
    }
}

