/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.tooltip;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.tooltip.Tooltip;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="tooltip", value="org.icefaces.ace.component.tooltip.Tooltip")
public class TooltipRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Tooltip tooltip = (Tooltip)component;
        String clientId = tooltip.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId + "_displayListener") && tooltip.getDisplayListener() != null) {
            tooltip.getDisplayListener().invoke(facesContext.getELContext(), null);
        }
        this.decodeBehaviors(facesContext, (UIComponent)tooltip);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Tooltip tooltip = (Tooltip)component;
        this.encodeScript(facesContext, tooltip);
        if (tooltip.getValue() == null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            String clientId = tooltip.getClientId(facesContext);
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_content"), null);
            writer.writeAttribute("style", (Object)"display:none;", null);
            this.renderChildren(facesContext, (UIComponent)tooltip);
            writer.endElement("div");
        }
    }

    protected void encodeScript(FacesContext facesContext, Tooltip tooltip) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean global = tooltip.isGlobal();
        String owner = this.getTarget(facesContext, tooltip);
        String clientId = tooltip.getClientId(facesContext);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("ice.ace.jq(function() {");
        writer.write(this.resolveWidgetVar((UIComponent)tooltip) + " = new ");
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.Tooltip").beginMap().entry("global", global).entry("id", clientId).entry("displayListener", tooltip.getDisplayListener() != null);
        if (tooltip.isSpeechBubble()) {
            jb.entry("speechBubble", true);
        }
        if (!global) {
            jb.entry("forComponent", owner);
            writer.write(jb.toString());
            writer.write(",content:");
            if (tooltip.getValue() == null) {
                writer.write("document.getElementById('" + clientId + "_content').innerHTML");
            } else {
                writer.write("'");
                writer.write(ComponentUtils.getStringValueToRender(facesContext, (UIComponent)tooltip).replaceAll("'", "\\\\'"));
                writer.write("'");
            }
            writer.write(",");
        } else {
            writer.write(jb.toString());
            writer.write(",");
        }
        jb = JSONBuilder.create();
        jb.beginMap("show").beginMap("when").entry("event", tooltip.getShowEvent()).endMap().entry("delay", tooltip.getShowDelay()).beginMap("effect").entry("length", tooltip.getShowEffectLength()).entry("type", tooltip.getShowEffect()).endMap().endMap();
        jb.beginMap("hide").beginMap("when").entry("event", tooltip.getHideEvent()).endMap().entry("delay", tooltip.getHideDelay()).beginMap("effect").entry("length", tooltip.getHideEffectLength()).entry("type", tooltip.getHideEffect()).endMap().endMap();
        jb.beginMap("position");
        String container = owner == null ? "document.body" : "ice.ace.jq(ice.ace.escapeClientId('" + owner + "')).parent()";
        jb.entry("container", container, true).beginMap("corner").entry("target", tooltip.getTargetPosition()).entry("tooltip", tooltip.getPosition()).endMap().endMap();
        this.encodeClientBehaviors(facesContext, tooltip, jb);
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.write("});");
        writer.endElement("script");
        writer.endElement("span");
    }

    protected String getTarget(FacesContext facesContext, Tooltip tooltip) {
        if (tooltip.isGlobal()) {
            return null;
        }
        String _for = tooltip.getFor();
        String forElement = tooltip.getForElement();
        if (_for != null) {
            UIComponent forComponent = tooltip.findComponent(_for);
            if (forComponent == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return forComponent.getClientId(facesContext);
        }
        if (forElement != null) {
            return forElement;
        }
        return tooltip.getParent().getClientId(facesContext);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

