/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.progressbar;

import java.io.IOException;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.progressbar.ProgressBar;
import org.icefaces.ace.context.RequestContext;
import org.icefaces.ace.event.ProgressBarChangeEvent;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="progressBar", value="org.icefaces.ace.component.progressbar.ProgressBar")
public class ProgressBarRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        ProgressBar progressBar = (ProgressBar)component;
        String clientId = progressBar.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            if (params.containsKey(clientId + "_cancel")) {
                progressBar.getValueExpression("value").setValue(facesContext.getELContext(), (Object)0);
                if (progressBar.getCancelListener() != null) {
                    progressBar.getCancelListener().invoke(facesContext.getELContext(), null);
                }
            } else if (params.containsKey(clientId + "_complete")) {
                if (progressBar.getCompleteListener() != null) {
                    progressBar.getCompleteListener().invoke(facesContext.getELContext(), null);
                }
            } else if (params.containsKey(clientId + "_change")) {
                MethodExpression changeListener = progressBar.getChangeListener();
                if (changeListener != null) {
                    ProgressBarChangeEvent event = new ProgressBarChangeEvent(component, (String)params.get(clientId + "_value"), (String)params.get(clientId + "_percentage"));
                    changeListener.invoke(facesContext.getELContext(), new Object[]{event});
                }
            } else {
                RequestContext.getCurrentInstance().addCallbackParam(progressBar.getClientId(facesContext) + "_value", progressBar.getValue());
            }
        }
        this.decodeBehaviors(facesContext, (UIComponent)progressBar);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ProgressBar progressBar = (ProgressBar)component;
        this.encodeMarkup(facesContext, progressBar);
        this.encodeScript(facesContext, progressBar);
    }

    protected void encodeMarkup(FacesContext facesContext, ProgressBar progressBar) throws IOException {
        String styleClass;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", (UIComponent)progressBar);
        writer.writeAttribute("id", (Object)progressBar.getClientId(facesContext), "id");
        String style = progressBar.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if ((styleClass = progressBar.getStyleClass()) != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext facesContext, ProgressBar progressBar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = progressBar.getClientId(facesContext);
        boolean hasChangeListener = progressBar.getChangeListener() != null;
        writer.startElement("script", (UIComponent)progressBar);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("ice.ace.jq(function() {");
        writer.write(this.resolveWidgetVar((UIComponent)progressBar) + " = new ");
        JSONBuilder json = JSONBuilder.create();
        json.beginFunction("ice.ace.ProgressBar").item(clientId).beginMap().entry("value", progressBar.getValue());
        if (progressBar.isUsePolling()) {
            json.entry("usePolling", true);
            json.entry("pollingInterval", progressBar.getPollingInterval());
        } else {
            json.entry("usePolling", false);
        }
        if (progressBar.isDisabled()) {
            json.entry("disabled", true);
        }
        json.entry("hasChangeListener", hasChangeListener);
        this.encodeClientBehaviors(facesContext, progressBar, json);
        json.endMap();
        json.endFunction();
        writer.write(json.toString());
        writer.write("});");
        writer.endElement("script");
    }
}

