/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.menu;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.ajax.AjaxBehavior;
import org.icefaces.ace.component.menu.AbstractMenu;
import org.icefaces.ace.component.menuitem.MenuItem;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.Utils;

public abstract class BaseMenuRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AbstractMenu menu = (AbstractMenu)component;
        if (menu.shouldBuildFromModel()) {
            menu.buildMenuFromModel();
        }
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected abstract void encodeMarkup(FacesContext var1, AbstractMenu var2) throws IOException;

    protected abstract void encodeScript(FacesContext var1, AbstractMenu var2) throws IOException;

    protected void encodeMenuItem(FacesContext context, MenuItem menuItem) throws IOException {
        String clientId = menuItem.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        String icon = menuItem.getIcon();
        if (menuItem.shouldRenderChildren()) {
            this.renderChildren(context, (UIComponent)menuItem);
        } else {
            writer.startElement("a", null);
            if (menuItem.getUrl() != null) {
                writer.writeAttribute("href", (Object)this.getResourceURL(context, menuItem.getUrl()), null);
                if (menuItem.getOnclick() != null) {
                    writer.writeAttribute("onclick", (Object)menuItem.getOnclick(), null);
                }
                if (menuItem.getTarget() != null) {
                    writer.writeAttribute("target", (Object)menuItem.getTarget(), null);
                }
            } else {
                writer.writeAttribute("href", (Object)"#", null);
                UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)menuItem);
                if (form == null) {
                    throw new FacesException("Menubar must be inside a form element");
                }
                String formClientId = form.getClientId(context);
                boolean hasAjaxBehavior = false;
                StringBuilder command = new StringBuilder();
                command.append("var self = this; setTimeout(function() { var f = function(){");
                Map behaviorEvents = menuItem.getClientBehaviors();
                if (!behaviorEvents.isEmpty()) {
                    List params = Collections.emptyList();
                    for (ClientBehavior behavior : (List)behaviorEvents.get("activate")) {
                        ClientBehaviorContext cbc;
                        String script;
                        if (behavior instanceof AjaxBehavior) {
                            hasAjaxBehavior = true;
                        }
                        if ((script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)menuItem, (String)"activate", (String)clientId, params))) == null) continue;
                        command.append(script);
                        command.append(";");
                    }
                }
                command.append("}; ");
                if (!(hasAjaxBehavior || menuItem.getActionExpression() == null && menuItem.getActionListeners().length <= 0)) {
                    command.append("self.id = '" + clientId + "'; ice.s(event, self");
                    StringBuilder parameters = new StringBuilder();
                    parameters.append(",function(p){");
                    for (UIComponent child : menuItem.getChildren()) {
                        if (!(child instanceof UIParameter)) continue;
                        UIParameter param = (UIParameter)child;
                        parameters.append("p('");
                        parameters.append(param.getName());
                        parameters.append("','");
                        parameters.append(String.valueOf(param.getValue()));
                        parameters.append("');");
                    }
                    parameters.append("});");
                    command.append(parameters.toString());
                } else {
                    command.append("f(null, null, null, self);");
                }
                command.append("}, 10);");
                String customOnclick = menuItem.getOnclick();
                String onclick = customOnclick == null ? command.toString() : customOnclick + ";" + command.toString();
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
            if (icon != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)(icon + " wijmo-wijmenu-icon-left"), null);
                writer.endElement("span");
            }
            if (menuItem.getValue() != null) {
                writer.startElement("span", null);
                String style = menuItem.getStyle();
                if (style != null && style.trim().length() > 0) {
                    writer.writeAttribute("style", (Object)style, "style");
                }
                Utils.writeConcatenatedStyleClasses(writer, "wijmo-wijmenu-text", menuItem.getStyleClass());
                writer.write((String)menuItem.getValue());
                writer.endElement("span");
            }
            writer.endElement("a");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

