/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.maskedentry;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.maskedentry.MaskedEntry;
import org.icefaces.ace.renderkit.InputRenderer;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.HTML;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.ace.util.Utils;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="maskedEntry", value="org.icefaces.ace.component.maskedentry.MaskedEntry")
public class MaskedEntryRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        MaskedEntry maskedEntry = (MaskedEntry)component;
        if (maskedEntry.isDisabled() || maskedEntry.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)maskedEntry);
        String clientId = maskedEntry.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            maskedEntry.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        MaskedEntry maskedEntry = (MaskedEntry)component;
        this.encodeMarkup(context, maskedEntry);
        this.encodeScript(context, maskedEntry);
    }

    protected void encodeScript(FacesContext context, MaskedEntry maskedEntry) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = maskedEntry.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(this.resolveWidgetVar((UIComponent)maskedEntry) + " = new ");
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.InputMask").item(clientId).beginMap().entry("mask", maskedEntry.getMask());
        String placeHolder = maskedEntry.getPlaceHolder();
        if (placeHolder != null) {
            jb.entry("placeholder", placeHolder);
        }
        this.encodeClientBehaviors(context, maskedEntry, jb);
        if (!this.themeForms()) {
            jb.entry("theme", false);
        }
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, MaskedEntry maskedEntry) throws IOException {
        String style;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = maskedEntry.getClientId(context);
        String defaultClass = this.themeForms() ? "ui-inputfield ui-inputmask ui-widget ui-state-default ui-corner-all" : "ui-inputmask";
        String styleClass = maskedEntry.getStyleClass();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"text", null);
        String valueToRender = ComponentUtils.getStringValueToRender(context, (UIComponent)maskedEntry);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)maskedEntry, HTML.INPUT_TEXT_ATTRS);
        if (maskedEntry.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (maskedEntry.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if ((style = maskedEntry.getStyle()) != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        Utils.writeConcatenatedStyleClasses(writer, defaultClass, styleClass);
        writer.endElement("input");
    }
}

