/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.linkbutton;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import org.icefaces.ace.component.linkbutton.LinkButton;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.HTML;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.ace.util.ScriptWriter;
import org.icefaces.ace.util.Utils;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.util.EnvUtils;

@MandatoryResourceComponent(tagName="linkButton", value="org.icefaces.ace.component.linkbutton.LinkButton")
public class LinkButtonRenderer
extends CoreRenderer {
    List<UIParameter> uiParamChildren;
    private static String[] excludedAttributes = new String[]{"onclick", "onkeydown", "hreflang", "href", "target", "style"};

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        LinkButton link = (LinkButton)uiComponent;
        if (requestParameterMap.containsKey("ice.event.captured")) {
            String source = String.valueOf(requestParameterMap.get("ice.event.captured"));
            String clientId = link.getClientId();
            if (clientId.equals(source)) {
                try {
                    uiComponent.queueEvent((FacesEvent)new ActionEvent(uiComponent));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.decodeBehaviors(facesContext, (UIComponent)link);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        LinkButton linkButton = (LinkButton)uiComponent;
        this.uiParamChildren = Utils.captureParameters((UIComponent)linkButton);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        String styleClass = linkButton.getStyleClass();
        String styleClassVal = "";
        if (styleClass != null && styleClass.trim().length() > 0) {
            styleClassVal = " " + styleClass;
        }
        writer.writeAttribute("class", (Object)("ice-linkbutton" + styleClassVal), null);
        String style = linkButton.getStyle();
        if (style != null && style.trim().length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_span"), null);
        styleClass = "yui-button yui-link-button ui-button ui-widget";
        boolean disabled = linkButton.isDisabled();
        if (disabled) {
            styleClass = styleClass + " yui-button-disabled yui-link-button-disabled";
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("span", uiComponent);
        styleClass = "first-child";
        writer.writeAttribute("class", (Object)styleClass, null);
        if (disabled) {
            return;
        }
        writer.startElement("a", uiComponent);
        this.renderPassThruAttributes(facesContext, (UIComponent)linkButton, HTML.LINK_ATTRS, excludedAttributes);
        String userOnclick = (String)linkButton.getAttributes().get("onclick");
        userOnclick = userOnclick == null ? "" : userOnclick + ";";
        writer.writeAttribute("onclick", (Object)(userOnclick + "return ice.ace.linkButton.clickHandler(event, '" + clientId + "' );"), null);
        String temp = linkButton.getHref();
        if (temp != null) {
            if (this.uiParamChildren != null) {
                temp = temp + "?" + Utils.asParameterString(this.uiParamChildren);
            }
            writer.writeAttribute("href", (Object)temp, null);
        } else {
            String userOnkeydown = (String)linkButton.getAttributes().get("onkeydown");
            userOnkeydown = userOnkeydown == null ? "" : userOnkeydown + ";";
            writer.writeAttribute("onkeydown", (Object)(userOnkeydown + "return ice.ace.linkButton.keyDownHandler(event, '" + clientId + "' );"), null);
        }
        temp = linkButton.getHrefLang();
        if (temp != null) {
            writer.writeAttribute("hreflang", (Object)temp, null);
        }
        if ((temp = linkButton.getTarget()) != null) {
            writer.writeAttribute("target", (Object)temp, null);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        LinkButton linkButton = (LinkButton)uiComponent;
        String value = (String)linkButton.getValue();
        writer.writeText((Object)value, null);
        boolean disabled = linkButton.isDisabled();
        if (!disabled) {
            writer.endElement("a");
        }
        writer.endElement("span");
        writer.endElement("span");
        ActionListener[] al = linkButton.getActionListeners();
        boolean doAction = al.length > 0 || linkButton.getActionExpression() != null;
        StringBuilder sb = new StringBuilder();
        sb.append(value).append(linkButton.getHref()).append(linkButton.getHrefLang()).append(linkButton.getStyleClass()).append(linkButton.getStyle()).append(linkButton.getTarget());
        boolean ariaEnabled = EnvUtils.isAriaEnabled((FacesContext)facesContext);
        Integer tabindex = linkButton.getTabindex();
        if (ariaEnabled && tabindex == null) {
            tabindex = 0;
        }
        JSONBuilder jsonBuilder = JSONBuilder.create().beginMap();
        jsonBuilder.entry("type", "link");
        if (tabindex != null) {
            jsonBuilder.entry("tabindex", tabindex);
        }
        jsonBuilder.entry("label", (String)linkButton.getValue());
        jsonBuilder.entry("disabled", disabled);
        this.encodeClientBehaviors(facesContext, linkButton, jsonBuilder);
        String jsProps = jsonBuilder.endMap().toString();
        JSONBuilder jBuild = JSONBuilder.create().beginMap().entry("doAction", doAction).entry("hashCode", sb.toString().hashCode()).entry("ariaEnabled", ariaEnabled);
        if (doAction && this.uiParamChildren != null) {
            jBuild.entry("postParameters", Utils.asStringArray(this.uiParamChildren));
        }
        String params = "'" + clientId + "'," + jsProps + "," + jBuild.endMap().toString();
        String finalScript = "ice.ace.linkButton.updateProperties(" + params + ");";
        ScriptWriter.insertScript(facesContext, uiComponent, finalScript);
        writer.endElement("div");
    }
}

