/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.dialog;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.dialog.Dialog;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="dialog", value="org.icefaces.ace.component.dialog.Dialog")
public class DialogRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Dialog dialog = (Dialog)component;
        String clientId = dialog.getClientId(context);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        this.encodeMarkup(context, dialog);
        this.encodeScript(context, dialog);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Dialog dialog) throws IOException {
        String onHide;
        String onShow;
        String hideEffect;
        String showEffect;
        int minWidth;
        int zIndex;
        int height;
        int width;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dialog.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("ice.ace.jq(function() {");
        writer.write(this.resolveWidgetVar((UIComponent)dialog) + " = new ");
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.Dialog").item(clientId + "_main").beginMap().entry("isVisible", dialog.isVisible()).entry("minHeight", dialog.getMinHeight());
        String styleClass = dialog.getStyleClass();
        if (styleClass != null) {
            jb.entry("dialogClass", styleClass);
        }
        if ((width = dialog.getWidth()) > 0) {
            jb.entry("width", width);
        }
        if ((height = dialog.getHeight()) > 0) {
            jb.entry("height", height);
        }
        if (!dialog.isDraggable()) {
            jb.entry("draggable", false);
        }
        if (dialog.isModal()) {
            jb.entry("modal", true);
        }
        if ((zIndex = dialog.getZindex()) != 1000) {
            jb.entry("zIndex", zIndex);
        }
        if (!dialog.isResizable()) {
            jb.entry("resizable", false);
        }
        if ((minWidth = dialog.getMinWidth()) != 150) {
            jb.entry("minWidth", minWidth);
        }
        if ((showEffect = dialog.getShowEffect()) != null) {
            jb.entry("show", showEffect);
        }
        if ((hideEffect = dialog.getHideEffect()) != null) {
            jb.entry("hide", hideEffect);
        }
        if (!dialog.isCloseOnEscape()) {
            jb.entry("closeOnEscape", false);
        }
        if (!dialog.isClosable()) {
            jb.entry("closable", false);
        }
        if (!dialog.isShowHeader()) {
            jb.entry("showHeader", false);
        }
        String headerText = dialog.getHeader();
        jb.entryNonNullValue("title", headerText);
        String position = dialog.getPosition();
        if (position != null) {
            if (position.contains(",")) {
                jb.entry("position", "[" + position + "]", true);
            } else {
                jb.entry("position", position);
            }
        }
        if ((onShow = dialog.getOnShow()) != null) {
            jb.entry("onShow", "function(event, ui) {" + onShow + "}", true);
        }
        if ((onHide = dialog.getOnHide()) != null) {
            jb.entry("onHide", "function(event, ui) {" + onHide + "}", true);
        }
        this.encodeClientBehaviors(context, dialog, jb);
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, Dialog dialog) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dialog.getClientId(facesContext);
        String headerText = dialog.getHeader();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_main"), null);
        writer.writeAttribute("style", (Object)"display:none", null);
        if (headerText != null) {
            // empty if block
        }
        this.renderChildren(facesContext, (UIComponent)dialog);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

