/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.datatable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.icefaces.ace.component.celleditor.CellEditor;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.columngroup.ColumnGroup;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.panelexpansion.PanelExpansion;
import org.icefaces.ace.component.row.Row;
import org.icefaces.ace.component.rowexpansion.RowExpansion;
import org.icefaces.ace.component.tableconfigpanel.TableConfigPanel;
import org.icefaces.ace.context.RequestContext;
import org.icefaces.ace.event.SelectEvent;
import org.icefaces.ace.event.UnselectEvent;
import org.icefaces.ace.model.legacy.Cell;
import org.icefaces.ace.model.table.RowState;
import org.icefaces.ace.model.table.RowStateMap;
import org.icefaces.ace.model.table.TreeDataModel;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.render.MandatoryResourceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MandatoryResourceComponent(tagName="dataTable", value="org.icefaces.ace.component.datatable.DataTable")
public class DataTableRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        DataTable table = (DataTable)component;
        if (table.isSelectionEnabled()) {
            this.decodeSelection(context, table);
        }
        if (table.isFilterRequest(context)) {
            this.decodeFilters(context, table);
        } else if (table.isTableConfigurationRequest(context)) {
            this.decodeTableConfigurationRequest(context, table);
        } else if (table.isPaginationRequest(context)) {
            this.decodePageRequest(context, table);
        } else if (table.isSortRequest(context)) {
            this.decodeSortRequest(context, table, null, null);
        } else if (table.isColumnReorderRequest(context)) {
            this.decodeColumnReorderRequest(context, table);
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataTable table = (DataTable)component;
        if (table.isPaginator()) {
            table.calculatePage();
        }
        if (table.isSortOrderChanged().booleanValue()) {
            table.processSorting();
        }
        if (table.isFilterValueChanged().booleanValue()) {
            table.setFilteredData(table.processFilters(context));
        }
        table.setModel(null);
        if (table.isScrollingRequest(context)) {
            this.encodeLiveRows(context, table);
        } else {
            this.encodeEntierty(context, table);
        }
    }

    private void decodeColumnReorderRequest(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        List ordering = table.getColumnOrdering();
        String[] columnTargets = ((String)params.get(clientId + "_columnReorder")).split("-");
        Integer columnIndex = (Integer)ordering.remove(Integer.parseInt(columnTargets[0]));
        ordering.add(Integer.parseInt(columnTargets[1]), columnIndex);
        table.setColumnOrdering(ordering);
    }

    void decodePageRequest(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String rowsParam = (String)params.get(clientId + "_rows");
        String pageParam = (String)params.get(clientId + "_page");
        table.setRows(Integer.valueOf(rowsParam));
        table.setPage(Integer.valueOf(pageParam));
        table.setFirst((table.getPage() - 1) * table.getRows());
    }

    void decodeSortRequest(FacesContext context, DataTable table, String clientId, String sortKeysInput) {
        List<Object> columns = new ArrayList();
        Map params = context.getExternalContext().getRequestParameterMap();
        ColumnGroup group = table.getColumnGroup("header");
        Column sortColumn = null;
        if (clientId == null) {
            clientId = table.getClientId(context);
        }
        String[] sortKeys = sortKeysInput != null ? sortKeysInput.split(",") : ((String)params.get(clientId + "_sortKeys")).split(",");
        String[] sortDirs = ((String)params.get(clientId + "_sortDirs")).split(",");
        if (group != null) {
            for (Object c : group.getChildren()) {
                if (!(c instanceof Row)) continue;
                for (UIComponent rc : c.getChildren()) {
                    if (!(rc instanceof Column)) continue;
                    columns.add((Object)((Column)rc));
                }
            }
        } else {
            columns = table.getColumns();
        }
        for (Object c : columns) {
            ((Column)((Object)c)).setSortPriority(null);
        }
        if (sortKeys[0].equals("")) {
            return;
        }
        int i = 0;
        for (String sortKey : sortKeys) {
            block13: {
                if (group != null) {
                    for (UIComponent child : group.getChildren()) {
                        for (UIComponent headerRowChild : ((Row)child).getChildren()) {
                            if (!(headerRowChild instanceof Column) || !headerRowChild.getClientId(context).equals(sortKey)) continue;
                            sortColumn = (Column)headerRowChild;
                            break block13;
                        }
                    }
                } else {
                    for (Column column : table.getColumns()) {
                        if (!column.getClientId(context).equals(sortKey)) continue;
                        sortColumn = column;
                        break;
                    }
                }
            }
            sortColumn.setSortPriority(i + 1);
            sortColumn.setSortAscending(Boolean.parseBoolean(sortDirs[i]));
            ++i;
        }
    }

    void decodeFilters(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String filteredId = (String)params.get(clientId + "_filteredColumn");
        Column filteredColumn = null;
        table.setFirst(0);
        table.setPage(1);
        if (table.isLazy()) {
            Map<String, Column> filterMap = table.getFilterMap();
            filteredColumn = filterMap.get(filteredId);
            if (filteredColumn != null) {
                filteredColumn.setFilterValue(((String)params.get(filteredId)).toLowerCase());
            }
            if (table.isPaginator() && RequestContext.getCurrentInstance() != null) {
                RequestContext.getCurrentInstance().addCallbackParam("totalRecords", table.getRowCount());
            }
        } else {
            Map<String, Column> filterMap = table.getFilterMap();
            filteredColumn = filterMap.get(filteredId);
            if (filteredColumn != null) {
                filteredColumn.setFilterValue(((String)params.get(filteredId)).toLowerCase());
            }
            String globalFilter = (String)params.get(clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + "globalFilter");
            table.setFilterValue(globalFilter);
            table.applyFilters();
        }
    }

    void decodeSelection(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String selection = (String)params.get(clientId + "_selection");
        if (table.isSingleSelectionMode()) {
            this.decodeSingleSelection(table, selection, (String)params.get(clientId + "_deselection"));
        } else {
            this.decodeMultipleSelection(table, selection, (String)params.get(clientId + "_deselection"));
        }
        this.queueInstantSelectionEvent(context, table, clientId, params);
    }

    void queueInstantSelectionEvent(FacesContext context, DataTable table, String clientId, Map<String, String> params) {
        if (table.isInstantSelectionRequest(context)) {
            DataModel model = table.getDataModel();
            TreeDataModel treeModel = null;
            String selection = params.get(clientId + "_instantSelectedRowIndex");
            if (table.hasTreeDataModel().booleanValue() && selection.indexOf(46) > 0) {
                treeModel = (TreeDataModel)model;
                int lastSepIndex = selection.lastIndexOf(46);
                treeModel.setRootIndex(selection.substring(0, lastSepIndex));
                selection = selection.substring(lastSepIndex + 1);
            }
            int selectedRowIndex = Integer.parseInt(selection);
            table.setRowIndex(selectedRowIndex);
            SelectEvent selectEvent = new SelectEvent((UIComponent)table, table.getRowData());
            selectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            table.queueEvent(selectEvent);
            if (treeModel != null) {
                treeModel.setRootIndex(null);
            }
        } else if (table.isInstantUnselectionRequest(context)) {
            DataModel model = table.getDataModel();
            TreeDataModel treeModel = null;
            String selection = params.get(clientId + "_instantUnselectedRowIndex");
            if (table.hasTreeDataModel().booleanValue() && selection.indexOf(46) > 0) {
                treeModel = (TreeDataModel)model;
                int lastSepIndex = selection.lastIndexOf(46);
                treeModel.setRootIndex(selection.substring(0, lastSepIndex));
                selection = selection.substring(lastSepIndex + 1);
            }
            int unselectedRowIndex = Integer.parseInt(selection);
            table.setRowIndex(unselectedRowIndex);
            UnselectEvent unselectEvent = new UnselectEvent((UIComponent)table, table.getRowData());
            unselectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            table.queueEvent(unselectEvent);
            if (treeModel != null) {
                treeModel.setRootIndex(null);
            }
        }
        table.setRowIndex(-1);
    }

    void decodeSingleSelection(DataTable table, String selection, String deselection) {
        RowStateMap stateMap = table.getStateMap();
        if (this.isValueBlank(selection)) {
            if (!deselection.equals("")) {
                stateMap.setAllSelected(false);
            }
        } else if (table.isCellSelection()) {
            table.setCellSelection(this.buildCell(table, selection));
        } else {
            TreeDataModel treeModel = null;
            DataModel model = table.getDataModel();
            if (table.hasTreeDataModel().booleanValue()) {
                treeModel = (TreeDataModel)model;
            }
            if (treeModel != null & selection.indexOf(46) > 0) {
                int lastSepIndex = selection.lastIndexOf(46);
                treeModel.setRootIndex(selection.substring(0, lastSepIndex));
                selection = selection.substring(lastSepIndex + 1);
            }
            stateMap.setAllSelected(false);
            int selectedRowIndex = Integer.parseInt(selection);
            table.setRowIndex(selectedRowIndex);
            Object rowData = table.getRowData();
            RowState state = stateMap.get(rowData);
            if (state.isSelectable()) {
                state.setSelected(true);
            }
            if (treeModel != null) {
                treeModel.setRootIndex(null);
            }
            table.setRowIndex(-1);
        }
    }

    void decodeMultipleSelection(DataTable table, String selection, String deselection) {
        DataModel value = table.getDataModel();
        TreeDataModel model = null;
        if (table.hasTreeDataModel().booleanValue()) {
            model = (TreeDataModel)value;
        }
        RowStateMap stateMap = table.getStateMap();
        if (!this.isValueBlank(selection)) {
            if (table.isCellSelection()) {
                String[] cellInfos = selection.split(",");
                Cell[] cells = new Cell[cellInfos.length];
                for (int i = 0; i < cellInfos.length; ++i) {
                    cells[i] = this.buildCell(table, cellInfos[i]);
                    table.setRowIndex(-1);
                }
                table.setCellSelection(cells);
            } else {
                String[] rowSelectValues;
                for (String s : rowSelectValues = selection.split(",")) {
                    if (s.indexOf(".") != -1 && model != null) {
                        int lastSepIndex = s.lastIndexOf(46);
                        model.setRootIndex(s.substring(0, lastSepIndex));
                        s = s.substring(lastSepIndex + 1);
                    }
                    table.setRowIndex(Integer.parseInt(s));
                    RowState state = stateMap.get(table.getRowData());
                    if (!state.isSelected() && state.isSelectable()) {
                        state.setSelected(true);
                    }
                    if (model == null) continue;
                    model.setRootIndex(null);
                }
                table.setRowIndex(-1);
            }
        }
        String[] rowDeselectValues = new String[]{};
        if (deselection != null && !deselection.equals("")) {
            rowDeselectValues = deselection.split(",");
        }
        boolean x = false;
        for (String s : rowDeselectValues) {
            if (s.indexOf(".") != -1 && model != null) {
                int lastSepIndex = s.lastIndexOf(46);
                model.setRootIndex(s.substring(0, lastSepIndex));
                s = s.substring(lastSepIndex + 1);
            }
            table.setRowIndex(Integer.parseInt(s));
            RowState state = stateMap.get(table.getRowData());
            if (state.isSelected()) {
                state.setSelected(false);
            }
            if (model == null) continue;
            model.setRootIndex(null);
        }
        table.setRowIndex(-1);
    }

    void decodeTableConfigurationRequest(FacesContext context, DataTable table) {
        TableConfigPanel tableConfigPanel = table.findTableConfigPanel(context);
        this.decodeColumnConfigurations(context, table, tableConfigPanel);
    }

    private void decodeColumnConfigurations(FacesContext context, DataTable table, TableConfigPanel panel) {
        String clientId = table.getClientId(context);
        List<Column> columns = table.getColumns();
        Map params = context.getExternalContext().getRequestParameterMap();
        boolean visibility = panel.isColumnVisibilityConfigurable();
        boolean ordering = panel.isColumnOrderingConfigurable();
        boolean sizing = false;
        boolean name = panel.isColumnNameConfigurable();
        boolean firstCol = panel.getType().equals("first-col");
        boolean lastCol = panel.getType().equals("last-col");
        boolean sorting = panel.isColumnSortingConfigurable();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            if (!column.isConfigurable()) continue;
            boolean disableVisibilityControl = firstCol && i == 0 || lastCol && i == columns.size() - 1;
            String panelId = panel.getClientId();
            if (visibility && !disableVisibilityControl) {
                this.decodeColumnVisibility(params, column, i, panelId);
            }
            if (sizing) {
                this.decodeColumnSizing(params, column, i, panelId);
            }
            if (!name) continue;
            this.decodeColumnName(params, column, i, panelId);
        }
        if (ordering) {
            this.decodeColumnOrdering(params, table, clientId);
        }
        if (sorting) {
            this.decodeSortRequest(context, table, clientId, this.processConfigPanelSortKeys(clientId, params, table));
        }
    }

    private String processConfigPanelSortKeys(String clientId, Map<String, String> params, DataTable table) {
        String[] sortKeys = params.get(clientId + "_sortKeys").split(",");
        List<Column> columns = table.getColumns();
        String newSortKeys = "";
        for (String key : sortKeys) {
            if (key.length() <= 0) continue;
            newSortKeys = newSortKeys.length() == 0 ? columns.get(Integer.parseInt(key)).getClientId() : newSortKeys + "," + columns.get(Integer.parseInt(key)).getClientId();
        }
        return newSortKeys;
    }

    private void decodeColumnName(Map<String, String> params, Column column, int i, String clientId) {
        String text = params.get(clientId + "_head_" + i);
        column.setHeaderText(text);
    }

    private void decodeColumnOrdering(Map<String, String> params, DataTable table, String clientId) {
        String[] indexes = params.get(clientId + "_colorder").split(",");
        table.setColumnOrdering(indexes);
    }

    private void decodeColumnSizing(Map<String, String> params, Column column, int i, String clientId) {
    }

    private void decodeColumnVisibility(Map<String, String> params, Column column, int i, String clientId) {
        String code = params.get(clientId + "_colvis_" + i);
        if (code == null) {
            column.setRendered(false);
        } else {
            column.setRendered(true);
        }
    }

    @Override
    public boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    protected void encodeScript(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        String filterEvent = table.getFilterEvent();
        writer.startElement("script", (UIComponent)table);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("var " + this.resolveWidgetVar((UIComponent)table) + " = new ice.ace.DataTable('" + clientId + "',{");
        UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)table);
        if (form == null) {
            throw new FacesException("DataTable : \"" + clientId + "\" must be inside a form element.");
        }
        writer.write("formId:'" + form.getClientId(context) + "'");
        writer.write(",filterEvent:'" + filterEvent + "'");
        if (table.getTableConfigPanel() != null) {
            writer.write(",configPanel:'" + table.getTableConfigPanel() + "'");
        }
        if (table.isPaginator()) {
            this.encodePaginatorConfig(context, table);
        }
        if (table.isSelectionEnabled()) {
            writer.write(",selectionMode:'" + table.getSelectionMode() + "'");
            if (table.isDoubleClickSelect()) {
                writer.write(",dblclickSelect:true");
            }
            if (table.hasSelectionClientBehaviour() || table.getRowSelectListener() != null || table.getRowUnselectListener() != null) {
                writer.write(",instantSelect:true");
            }
        }
        if (table.getPanelExpansion() != null) {
            writer.write(",panelExpansion:true");
        }
        if (table.getRowExpansion() != null) {
            writer.write(",rowExpansion:true");
        }
        if (table.isClickableHeaderSorting()) {
            writer.write(",clickableHeaderSorting:true");
        }
        if (table.isScrollable()) {
            writer.write(",scrollable:true");
            writer.write(",liveScroll:" + table.isLiveScroll());
            writer.write(",scrollStep:" + table.getRows());
            writer.write(",scrollLimit:" + table.getRowCount());
            if (table.getHeight() != Integer.MIN_VALUE) {
                writer.write(",height:" + table.getHeight());
            }
        }
        if (table.isResizableColumns()) {
            writer.write(",resizableColumns:true");
        }
        if (table.isReorderableColumns()) {
            writer.write(",reorderableColumns:true");
        }
        if (table.isSingleSort()) {
            writer.write(",singleSort:true");
        }
        if (table.isDisabled()) {
            writer.write(",disabled:true");
        }
        this.encodeClientBehaviors(context, table);
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeEntierty(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        boolean scrollable = table.isScrollable();
        table.getStateMap();
        String containerClass = scrollable ? "ui-datatable ui-widget ui-datatable-scrollable" : "ui-datatable ui-widget";
        containerClass = table.getStyleClass() != null ? containerClass + " " + table.getStyleClass() : containerClass;
        String style = null;
        boolean hasPaginator = table.isPaginator();
        String paginatorPosition = table.getPaginatorPosition();
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)containerClass, "styleClass");
        style = table.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeFacet(context, table, table.getHeader(), "ui-datatable-header ui-widget-header ui-corner-tl ui-corner-tr");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            this.encodePaginatorMarkup(context, table, "top");
        }
        if (scrollable) {
            this.encodeScrollableTable(context, table);
        } else {
            this.encodeRegularTable(context, table);
        }
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            this.encodePaginatorMarkup(context, table, "bottom");
        }
        this.encodeFacet(context, table, table.getFooter(), "ui-datatable-footer ui-widget-header ui-corner-bl ui-corner-br");
        if (table.isSelectionEnabled()) {
            this.encodeSelectionAndDeselectionHolder(context, table);
        }
        this.encodeScript(context, table);
        table.clearCachedStateMap();
        if (!"false".equals(context.getExternalContext().getInitParameter("ForceFullTableDOMUpdates"))) {
            writer.startElement("div", null);
            writer.writeAttribute("style", (Object)"display:none;", null);
            writer.writeText((Object)table.getForcedUpdateCounter(), null);
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    protected void encodeUtilityChildren(FacesContext context, DataTable table) throws IOException {
        for (UIComponent child : table.getChildren()) {
            if (!(child instanceof TableConfigPanel)) continue;
            child.encodeAll(context);
        }
    }

    protected void encodeRegularTable(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<Column> columns = table.getColumns();
        this.encodeUtilityChildren(context, table);
        writer.startElement("table", null);
        if (table.hasHeaders()) {
            this.encodeTableHead(context, table, columns);
        }
        this.encodeTableBody(context, table, columns);
        this.encodeTableFoot(context, table, columns);
        writer.endElement("table");
    }

    protected void encodeScrollableTable(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<Column> columns = table.getColumns();
        this.encodeUtilityChildren(context, table);
        if (table.hasHeaders()) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-datatable-scrollable-header", null);
            writer.startElement("table", null);
            this.encodeTableHead(context, table, columns);
            writer.endElement("table");
            writer.endElement("div");
        }
        writer.startElement("div", null);
        String scrollClass = "ui-datatable-scroll-x ui-datatable-scrollable-body";
        writer.writeAttribute("class", (Object)scrollClass, null);
        writer.writeAttribute("style", (Object)("max-height:" + table.getHeight() + "px"), null);
        writer.startElement("table", null);
        if (table.hasHeaders()) {
            table.setInDuplicateSegment(true);
            this.encodeTableHead(context, table, columns);
            table.setInDuplicateSegment(false);
        }
        this.encodeTableBody(context, table, columns);
        table.setInDuplicateSegment(true);
        this.encodeTableFoot(context, table, columns);
        table.setInDuplicateSegment(false);
        writer.endElement("table");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-scrollable-footer", null);
        writer.startElement("table", null);
        this.encodeTableFoot(context, table, columns);
        writer.endElement("table");
        writer.endElement("div");
    }

    private void writeConfigPanelLaunchButton(ResponseWriter writer, UIComponent component, boolean first) throws IOException {
        String jsId = this.resolveWidgetVar(component);
        String panelJsId = this.resolveWidgetVar((UIComponent)((DataTable)component).findTableConfigPanel(FacesContext.getCurrentInstance()));
        String clientId = ((DataTable)component).findTableConfigPanel(FacesContext.getCurrentInstance()).getClientId();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-tableconf-button", null);
        writer.writeAttribute("style", (Object)(first ? "left:0;" : "right:0;"), null);
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)"ui-state-default ui-corner-all", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("onclick", (Object)("ice.ace.jq(ice.ace.escapeClientId('" + clientId + "')).toggle()"), null);
        writer.writeAttribute("id", (Object)(clientId + "_tableconf_launch"), null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-gear", null);
        writer.endElement("span");
        writer.endElement("a");
        writer.endElement("span");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)("ice.ace.jq(function() {\n\tice.ace.jq(ice.ace.escapeClientId('" + clientId + "_tableconf_launch')).hover(function(event){ice.ace.jq(event.currentTarget).toggleClass('ui-state-hover'); event.stopPropagation(); }).click(function(event){ice.ace.jq(event.currentTarget).toggleClass('ui-state-active'); var panel = ice.ace.jq(ice.ace.escapeClientId('" + clientId + "')); if (panel.is(':not(:visible)')) " + panelJsId + ".submitTableConfig(event.currentTarget); else if (" + panelJsId + ".behaviors) if (" + panelJsId + ".behaviors.open) " + panelJsId + ".behaviors.open(); event.stopPropagation(); });\n" + "});"), null);
        writer.endElement("script");
    }

    protected void encodeColumnHeader(FacesContext context, DataTable table, List columnSiblings, Column column, boolean first, boolean last, boolean subRows) throws IOException {
        TableConfigPanel panel;
        boolean isNextStacked;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = column.getClientId(context);
        boolean isSortable = column.getValueExpression("sortBy") != null;
        boolean hasFilter = column.getValueExpression("filterBy") != null;
        int rightHeaderPadding = 0;
        int leftHeaderPadding = 0;
        Column nextColumn = this.getNextColumn(column, columnSiblings);
        boolean isCurrStacked = this.isCurrColumnStacked(columnSiblings, column);
        boolean bl = isNextStacked = nextColumn != null ? nextColumn.isStacked() : false;
        if (!isCurrStacked) {
            String style = column.getStyle();
            String styleClass = column.getStyleClass();
            String columnClass = "ui-widget-header";
            columnClass = table.isReorderableColumns() && column.isReorderable() ? columnClass + " " + "ui-reorderable-col" : columnClass;
            columnClass = styleClass != null ? columnClass + " " + styleClass : columnClass;
            columnClass = column.getSortPriority() != null && !isNextStacked ? columnClass + " ui-state-active" : columnClass;
            writer.startElement("th", null);
            writer.writeAttribute("class", (Object)columnClass, null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if (column.getRowspan() != 1) {
                writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
            }
            if (column.getColspan() != 1) {
                writer.writeAttribute("colspan", (Object)column.getColspan(), null);
            }
        } else {
            writer.startElement("hr", null);
            writer.endElement("hr");
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        String columnClass = "ui-header-column";
        columnClass = isSortable ? columnClass + " " + "ui-sortable-column" : columnClass;
        columnClass = table.isClickableHeaderSorting() ? columnClass + " clickable" : columnClass;
        columnClass = column.getSortPriority() != null && (isCurrStacked || isNextStacked) ? columnClass + " ui-state-active" : columnClass;
        writer.writeAttribute("class", (Object)columnClass, null);
        writer.startElement("span", null);
        boolean writeConfigPanelLaunchOnLeft = false;
        if (first && (panel = table.findTableConfigPanel(context)) != null && panel.getType().equals("first-col")) {
            leftHeaderPadding += 35;
            writeConfigPanelLaunchOnLeft = true;
        }
        if (last && (panel = table.findTableConfigPanel(context)) != null && panel.getType().equals("last-col")) {
            rightHeaderPadding += 35;
        }
        String paddingStyle = "";
        if (leftHeaderPadding > 0) {
            paddingStyle = paddingStyle + "padding-left:" + leftHeaderPadding + "px;";
        }
        if (!paddingStyle.equals("")) {
            writer.writeAttribute("style", (Object)paddingStyle, null);
        }
        if (writeConfigPanelLaunchOnLeft) {
            this.writeConfigPanelLaunchButton(writer, (UIComponent)table, first);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-header-text", null);
        UIComponent header = column.getFacet("header");
        String headerText = column.getHeaderText();
        if (header != null) {
            header.encodeAll(context);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        writer.endElement("span");
        writer.endElement("span");
        if (isSortable || this.isLastColConfPanel(context, table)) {
            this.writeHeaderRightSideControls(writer, context, table, column, isSortable, last);
        }
        if (hasFilter) {
            this.encodeFilter(context, table, column);
        }
        writer.endElement("div");
        if (!isNextStacked) {
            writer.endElement("th");
        } else if (subRows) {
            if (!this.areBothSingleColumnSpan(column, nextColumn)) {
                throw new FacesException("DataTable : \"" + table.getClientId(context) + "\" must not have stacked header columns, with colspan values greater than 1.");
            }
            if (!this.isNextColumnRowSpanEqual(column, nextColumn)) {
                throw new FacesException("DataTable : \"" + table.getClientId(context) + "\" must not have stacked header columns, with unequal rowspan values.");
            }
        }
    }

    private Column getNextColumn(Column column, List columnSiblings) {
        UIComponent next;
        int index = columnSiblings.indexOf((Object)column);
        if (index >= 0 && index + 1 < columnSiblings.size() && (next = (UIComponent)columnSiblings.get(index + 1)) instanceof Column) {
            return (Column)next;
        }
        return null;
    }

    private boolean isNextColumnRowSpanEqual(Column column, Column nextCol) {
        return nextCol.getRowspan() == column.getRowspan();
    }

    private boolean areBothSingleColumnSpan(Column column, Column nextCol) {
        return nextCol.getColspan() == 1 && column.getColspan() == 1;
    }

    private boolean isLastColConfPanel(FacesContext context, DataTable table) {
        TableConfigPanel panel = table.findTableConfigPanel(context);
        return panel != null && panel.getType().equals("last-col");
    }

    private void writeHeaderRightSideControls(ResponseWriter writer, FacesContext context, DataTable table, Column column, boolean sortable, boolean last) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-header-right", null);
        if (sortable) {
            this.writeSortControl(writer, context, table, column);
        }
        if (last && this.isLastColConfPanel(context, table)) {
            this.writeConfigPanelLaunchButton(writer, (UIComponent)table, false);
        }
        writer.endElement("span");
    }

    private void writeSortControl(ResponseWriter writer, FacesContext context, DataTable table, Column column) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-sortable-control", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-sortable-column-icon", null);
        writer.startElement("a", null);
        writer.writeAttribute("tabindex", (Object)0, null);
        if (column.getSortPriority() != null && column.isSortAscending()) {
            writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-n ui-toggled", null);
        } else {
            writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-n", null);
        }
        writer.endElement("a");
        writer.startElement("a", null);
        writer.writeAttribute("tabindex", (Object)0, null);
        if (column.getSortPriority() != null && !column.isSortAscending()) {
            writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-s ui-toggled", null);
        } else {
            writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-s", null);
        }
        writer.endElement("a");
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-sortable-column-order", null);
        if (table.isSingleSort()) {
            writer.writeAttribute("style", (Object)"display:none;", null);
        } else if (column.getSortPriority() != null) {
            writer.writeText((Object)column.getSortPriority(), null);
        }
        writer.endElement("span");
        writer.endElement("span");
    }

    protected void encodeFilter(FacesContext context, DataTable table, Column column) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        ResponseWriter writer = context.getResponseWriter();
        String widgetVar = this.resolveWidgetVar((UIComponent)table);
        String filterId = column.getClientId(context) + "_filter";
        String filterFunction = widgetVar + ".filter(event)";
        String filterStyleClass = column.getFilterStyleClass();
        String filterEvent = table.getFilterEvent();
        String string = filterStyleClass = filterStyleClass == null ? "ui-column-filter" : "ui-column-filter " + filterStyleClass;
        if (column.getValueExpression("filterOptions") == null) {
            String filterValue = column.getFilterValue() != null ? column.getFilterValue() : "";
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)filterId, null);
            writer.writeAttribute("name", (Object)filterId, null);
            writer.writeAttribute("class", (Object)filterStyleClass, null);
            writer.writeAttribute("size", (Object)"1", null);
            writer.writeAttribute("value", (Object)filterValue, null);
            if (filterEvent.equals("keyup") || filterEvent.equals("blur")) {
                writer.writeAttribute("on" + filterEvent, (Object)filterFunction, null);
            }
            if (column.getFilterStyle() != null) {
                writer.writeAttribute("style", (Object)column.getFilterStyle(), null);
            }
            writer.endElement("input");
        } else {
            SelectItem[] itemsArray;
            writer.startElement("select", null);
            writer.writeAttribute("id", (Object)filterId, null);
            writer.writeAttribute("name", (Object)filterId, null);
            writer.writeAttribute("class", (Object)filterStyleClass, null);
            writer.writeAttribute("onchange", (Object)filterFunction, null);
            for (SelectItem item : itemsArray = this.getFilterOptions(column)) {
                writer.startElement("option", null);
                writer.writeAttribute("value", item.getValue(), null);
                writer.write(item.getLabel());
                writer.endElement("option");
            }
            writer.endElement("select");
        }
    }

    protected SelectItem[] getFilterOptions(Column column) {
        Object options = column.getFilterOptions();
        if (options instanceof SelectItem[]) {
            return (SelectItem[])options;
        }
        if (options instanceof Collection) {
            return ((Collection)column.getFilterOptions()).toArray(new SelectItem[0]);
        }
        throw new FacesException("Filter options for column " + column.getClientId() + " should be a SelectItem array or collection");
    }

    protected void encodeColumnFooter(FacesContext context, DataTable table, List columnSiblings, Column column, boolean subRows) throws IOException {
        boolean isNextStacked;
        ResponseWriter writer = context.getResponseWriter();
        Column nextColumn = this.getNextColumn(column, columnSiblings);
        boolean isCurrStacked = this.isCurrColumnStacked(columnSiblings, column);
        boolean bl = isNextStacked = nextColumn != null ? nextColumn.isStacked() : false;
        if (!isCurrStacked) {
            String style = column.getStyle();
            String styleClass = column.getStyleClass();
            String footerClass = styleClass != null ? "ui-widget-header " + styleClass : "ui-widget-header";
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)footerClass, null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if (column.getRowspan() != 1) {
                writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
            }
            if (column.getColspan() != 1) {
                writer.writeAttribute("colspan", (Object)column.getColspan(), null);
            }
        } else {
            writer.startElement("hr", null);
            writer.endElement("hr");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-footer-column", null);
        UIComponent facet = column.getFacet("footer");
        String text = column.getFooterText();
        if (facet != null) {
            facet.encodeAll(context);
        } else if (text != null) {
            writer.write(text);
        }
        writer.endElement("div");
        if (!isNextStacked) {
            writer.endElement("td");
        } else if (subRows) {
            if (!this.areBothSingleColumnSpan(column, nextColumn)) {
                throw new FacesException("DataTable : \"" + table.getClientId(context) + "\" must not have stacked footer columns, with colspan values greater than 1.");
            }
            if (!this.isNextColumnRowSpanEqual(column, nextColumn)) {
                throw new FacesException("DataTable : \"" + table.getClientId(context) + "\" must not have stacked footer columns, with unequal rowspan values.");
            }
        }
    }

    protected void encodeTableHead(FacesContext context, DataTable table, List<Column> columns) throws IOException {
        List headContainer = columns;
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = table.getColumnGroup("header");
        if (group != null) {
            headContainer = group.getChildren();
        }
        writer.startElement("thead", null);
        if (table.isInDuplicateSegment().booleanValue()) {
            writer.writeAttribute("style", (Object)"display:none;", null);
        }
        boolean firstHeadElement = true;
        boolean subRows = false;
        Iterator headElementIterator = headContainer.iterator();
        do {
            UIComponent headerElem = (UIComponent)headElementIterator.next();
            List headerRowChildren = new ArrayList<UIComponent>();
            boolean i = false;
            if (!headerElem.isRendered()) continue;
            if (headerElem instanceof Row) {
                Row headerRow = (Row)headerElem;
                headerRowChildren = headerRow.getChildren();
                subRows = true;
            } else {
                headerRowChildren.add(headerElem);
            }
            if (subRows || firstHeadElement) {
                writer.startElement("tr", null);
            }
            Iterator componentIterator = headerRowChildren.iterator();
            boolean firstComponent = true;
            while (componentIterator.hasNext()) {
                UIComponent headerRowChild = (UIComponent)componentIterator.next();
                if (headerRowChild.isRendered() && headerRowChild instanceof Column) {
                    this.encodeColumnHeader(context, table, subRows ? headerRowChildren : headContainer, (Column)headerRowChild, firstComponent && firstHeadElement, !headElementIterator.hasNext() && !componentIterator.hasNext(), subRows);
                }
                firstComponent = false;
            }
            firstHeadElement = false;
            if (!subRows) continue;
            writer.endElement("tr");
        } while (headElementIterator.hasNext());
        if (!subRows) {
            writer.endElement("tr");
        }
        writer.endElement("thead");
    }

    protected void encodeTableBody(FacesContext context, DataTable table, List<Column> columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String rowIndexVar = table.getRowIndexVar();
        String clientId = table.getClientId(context);
        if (table.isLazy()) {
            table.loadLazyData();
        }
        int rows = table.getRows();
        int first = table.getFirst();
        int page = table.getPage();
        int rowCount = table.getRowCount();
        int rowCountToRender = rows == 0 ? rowCount : rows;
        boolean hasData = rowCount > 0;
        String tbodyClass = hasData ? "ui-datatable-data ui-widget-content" : "ui-datatable-data-empty";
        writer.startElement("tbody", null);
        writer.writeAttribute("id", (Object)(clientId + "_data"), null);
        writer.writeAttribute("class", (Object)tbodyClass, null);
        if (hasData) {
            for (int i = first; i < first + rowCountToRender; ++i) {
                this.encodeRow(context, table, columns, clientId, i, null, rowIndexVar, i == first);
            }
        } else {
            this.encodeEmptyMessage(table, writer, columns);
        }
        writer.endElement("tbody");
        table.setRowIndex(-1);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
    }

    private void encodeEmptyMessage(DataTable table, ResponseWriter writer, List<Column> columns) throws IOException {
        String emptyMessage = table.getEmptyMessage();
        if (emptyMessage != null) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)columns.size(), null);
            writer.write(emptyMessage);
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    protected void encodeRow(FacesContext context, DataTable table, List<Column> columns, String clientId, int rowIndex, String parentIndex, String rowIndexVar, boolean topRow) throws IOException {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().put(rowIndexVar, rowIndex);
        }
        RowState rowState = table.getStateMap().get(table.getRowData());
        boolean selected = rowState.isSelected();
        boolean unselectable = !rowState.isSelectable();
        boolean expanded = rowState.isExpanded();
        boolean visible = rowState.isVisible();
        context.getExternalContext().getRequestMap().put(table.getRowStateVar(), rowState);
        if (visible) {
            String rowStyleClass;
            ResponseWriter writer = context.getResponseWriter();
            List<Row> leadingRows = table.getConditionalRows(rowIndex, true);
            for (Row r : leadingRows) {
                this.encodeConditionalRow(context, r);
            }
            String userRowStyleClass = table.getRowStyleClass();
            String expandedClass = expanded ? "ui-expanded-row" : "";
            String unselectableClass = unselectable ? "ui-unselectable" : "";
            String string = rowStyleClass = rowIndex % 2 == 0 ? " ui-datatable-even" : " ui-datatable-odd";
            if (selected && table.getSelectionMode() != null) {
                rowStyleClass = rowStyleClass + " ui-selected ui-state-active";
            }
            if (userRowStyleClass != null) {
                rowStyleClass = rowStyleClass + " " + userRowStyleClass;
            }
            writer.startElement("tr", null);
            parentIndex = parentIndex != null ? parentIndex + "." : "";
            writer.writeAttribute("id", (Object)(clientId + "_row_" + parentIndex + rowIndex), null);
            writer.writeAttribute("class", (Object)(rowStyleClass + " " + expandedClass + " " + unselectableClass), null);
            writer.writeAttribute("tabindex", (Object)"0", null);
            boolean innerTdDivRequired = (table.isScrollable() || table.isResizableColumns()) & topRow;
            for (Column kid : columns) {
                if (!kid.isRendered()) continue;
                this.encodeRegularCell(context, columns, kid, innerTdDivRequired);
            }
            if (rowIndexVar != null) {
                context.getExternalContext().getRequestMap().put(rowIndexVar, rowIndex);
            }
            writer.endElement("tr");
            if (expanded) {
                context.getExternalContext().getRequestMap().put(clientId + "_expandedRowId", "" + rowIndex);
                boolean isPanel = table.getPanelExpansion() != null;
                boolean isRow = table.getRowExpansion() != null;
                table.setRowIndex(-1);
                if (isPanel && isRow) {
                    if (rowState.getExpansionType() == RowState.ExpansionType.ROW) {
                        this.encodeRowExpansion(context, table, columns, writer);
                    } else if (rowState.getExpansionType() == RowState.ExpansionType.PANEL) {
                        this.encodeRowPanelExpansion(context, table);
                    }
                } else if (isPanel) {
                    this.encodeRowPanelExpansion(context, table);
                } else if (isRow) {
                    this.encodeRowExpansion(context, table, columns, writer);
                }
                table.setRowIndex(rowIndex);
            }
            List<Row> tailingRows = table.getConditionalRows(rowIndex, false);
            for (Row r : tailingRows) {
                this.encodeConditionalRow(context, r);
            }
        }
    }

    protected void encodeRegularCell(FacesContext context, List columnSiblings, Column column, boolean resizable) throws IOException {
        boolean isNextGrouped;
        ResponseWriter writer = context.getResponseWriter();
        Column nextColumn = this.getNextColumn(column, columnSiblings);
        boolean isCurrStacked = this.isCurrColumnStacked(columnSiblings, column);
        boolean isNextStacked = nextColumn != null ? nextColumn.isStacked() : false;
        boolean isCurrGrouped = column.getCurrGroupLength() > 0;
        boolean bl = isNextGrouped = isCurrGrouped ? false : column.isNextColumnGrouped();
        if (isCurrGrouped) {
            column.setCurrGroupLength(column.getCurrGroupLength() - 1);
        } else {
            if (!isCurrStacked) {
                writer.startElement("td", null);
                if (column.getStyle() != null) {
                    writer.writeAttribute("style", (Object)column.getStyle(), null);
                }
                if (isNextGrouped) {
                    writer.writeAttribute("rowspan", (Object)(column.findCurrGroupLength() + 1), null);
                }
                CellEditor editor = column.getCellEditor();
                String columnStyleClass = column.getStyleClass();
                if (editor != null) {
                    String string = columnStyleClass = columnStyleClass == null ? "ui-editable-column" : "ui-editable-column " + columnStyleClass;
                }
                if (column.getValueExpression("groupBy") != null) {
                    if (column.isLastGroupDifferent()) {
                        column.setOddGroup(!column.isOddGroup());
                    }
                    if (columnStyleClass == null) {
                        columnStyleClass = "";
                    }
                    columnStyleClass = columnStyleClass + (column.isOddGroup() ? " ui-datatable-group-odd" : " ui-datatable-group-even");
                }
                if (columnStyleClass != null) {
                    writer.writeAttribute("class", (Object)columnStyleClass, null);
                }
                if (resizable) {
                    writer.startElement("div", null);
                }
            } else {
                writer.startElement("hr", null);
                writer.endElement("hr");
            }
            column.encodeAll(context);
            if (!isNextStacked) {
                if (resizable) {
                    writer.endElement("div");
                }
                writer.endElement("td");
            }
        }
    }

    protected void encodeConditionalRow(FacesContext context, Row r) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", null);
        if (r.getStyle() != null) {
            writer.writeAttribute("style", (Object)r.getStyle(), null);
        }
        if (r.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)r.getStyleClass(), null);
        }
        List children = r.getChildren();
        ArrayList<Column> rowColumns = new ArrayList<Column>(children.size());
        for (UIComponent uIComponent : children) {
            if (!(uIComponent instanceof Column)) continue;
            rowColumns.add((Column)uIComponent);
        }
        for (Column column : rowColumns) {
            if (!column.isRendered()) continue;
            this.encodeConditionalRowCell(context, column);
        }
        writer.endElement("tr");
    }

    protected void encodeConditionalRowCell(FacesContext context, Column c) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("colspan", (Object)c.getColspan(), null);
        if (c.getStyle() != null) {
            writer.writeAttribute("style", (Object)c.getStyle(), null);
        }
        if (c.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)c.getStyleClass(), null);
        }
        c.encodeAll(context);
        writer.endElement("td");
    }

    protected void encodeTableFoot(FacesContext context, DataTable table, List<Column> columns) throws IOException {
        boolean shouldRender;
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = table.getColumnGroup("footer");
        boolean bl = shouldRender = table.hasFooterColumn(columns) || group != null;
        if (!shouldRender) {
            return;
        }
        writer.startElement("tfoot", null);
        if (table.isInDuplicateSegment().booleanValue()) {
            writer.writeAttribute("style", (Object)"display:none;", null);
        }
        if (group != null) {
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered() || !(child instanceof Row)) continue;
                Row footerRow = (Row)child;
                writer.startElement("tr", null);
                List footerRowChildren = footerRow.getChildren();
                for (UIComponent footerRowChild : footerRowChildren) {
                    if (!footerRowChild.isRendered() || !(footerRowChild instanceof Column)) continue;
                    this.encodeColumnFooter(context, table, footerRowChildren, (Column)footerRowChild, true);
                }
                writer.endElement("tr");
            }
        } else {
            writer.startElement("tr", null);
            for (Column column : columns) {
                this.encodeColumnFooter(context, table, columns, column, false);
            }
            writer.endElement("tr");
        }
        writer.endElement("tfoot");
    }

    protected void encodeFacet(FacesContext context, DataTable table, UIComponent facet, String styleClass) throws IOException {
        if (facet == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        facet.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodePaginatorConfig(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        String paginatorPosition = table.getPaginatorPosition();
        String paginatorContainers = null;
        paginatorContainers = paginatorPosition.equalsIgnoreCase("both") ? "'" + clientId + "_paginatortop','" + clientId + "_paginatorbottom'" : "'" + clientId + "_paginator" + paginatorPosition + "'";
        writer.write(",paginator:new YAHOO.widget.Paginator({");
        writer.write("rowsPerPage:" + table.getRows());
        writer.write(",totalRecords:" + table.getRowCount());
        writer.write(",initialPage:" + table.getPage());
        writer.write(",containers:[" + paginatorContainers + "]");
        if (table.isDisabled()) {
            writer.write(",pageLinks:1");
        } else if (table.getPageCount() != 10) {
            writer.write(",pageLinks:" + table.getPageCount());
        }
        if (table.getPaginatorTemplate() != null) {
            writer.write(",template:'" + table.getPaginatorTemplate() + "'");
        }
        if (table.getRowsPerPageTemplate() != null) {
            writer.write(",rowsPerPageOptions : [" + table.getRowsPerPageTemplate() + "]");
        }
        if (table.getCurrentPageReportTemplate() != null) {
            writer.write(",pageReportTemplate:'" + table.getCurrentPageReportTemplate() + "'");
        }
        if (!table.isPaginatorAlwaysVisible()) {
            writer.write(",alwaysVisible:false");
        }
        writer.write("})");
    }

    protected void encodePaginatorMarkup(FacesContext context, DataTable table, String position) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        String styleClass = "ui-paginator ui-paginator-" + position + " ui-widget-header";
        if (!position.equals("top") && table.getFooter() == null) {
            styleClass = styleClass + " ui-corner-bl ui-corner-br";
        } else if (!position.equals("bottom") && table.getHeader() == null) {
            styleClass = styleClass + " ui-corner-tl ui-corner-tr";
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_paginator" + position), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        TableConfigPanel panel = table.findTableConfigPanel(context);
        if (panel != null && panel.getType().equals("paginator-button")) {
            this.writeConfigPanelLaunchButton(writer, (UIComponent)table, false);
        }
        writer.endElement("div");
    }

    protected void encodeSelectionAndDeselectionHolder(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = table.getClientId(context) + "_selection";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.endElement("input");
        id = table.getClientId(context) + "_deselection";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.endElement("input");
    }

    private void encodeRowPanelContraction(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        String expandedRowId = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_contractedRowId");
        DataModel model = table.getDataModel();
        if (!table.hasTreeDataModel().booleanValue()) {
            table.setRowIndex(Integer.parseInt(expandedRowId));
            table.getStateMap().get(model.getRowData()).setExpanded(false);
            table.setRowIndex(-1);
        } else {
            TreeDataModel rootModel = (TreeDataModel)model;
            rootModel.setRootIndex(expandedRowId);
            table.getStateMap().get(rootModel.getRootData()).setExpanded(false);
            rootModel.setRootIndex(null);
        }
    }

    private void encodeRowContraction(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        String expandedRowId = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_contractedRowId");
        DataModel model = table.getDataModel();
        if (!table.hasTreeDataModel().booleanValue()) {
            throw new FacesException("DataTable : \"" + clientId + "\" must be bound to an instance of TreeDataModel when using sub-row expansion.");
        }
        TreeDataModel rootModel = (TreeDataModel)model;
        rootModel.setRootIndex(expandedRowId);
        table.getStateMap().get(rootModel.getRootData()).setExpanded(false);
        rootModel.setRootIndex(null);
    }

    private void encodeRowExpansion(FacesContext context, DataTable table, List<Column> columns, ResponseWriter writer) throws IOException {
        String rowVar = table.getVar();
        String rowIndexVar = table.getRowIndexVar();
        String clientId = table.getClientId(context);
        String expandedRowId = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_expandedRowId");
        if (expandedRowId == null) {
            expandedRowId = (String)context.getExternalContext().getRequestMap().get(clientId + "_expandedRowId");
        }
        DataModel model = table.getDataModel();
        if (!table.hasTreeDataModel().booleanValue()) {
            throw new FacesException("DataTable : \"" + clientId + "\" must be bound to an instance of TreeDataModel when using sub-row expansion.");
        }
        TreeDataModel rootModel = (TreeDataModel)model;
        rootModel.setRootIndex(expandedRowId);
        table.getStateMap().get(rootModel.getRootData()).setExpanded(true);
        table.setRowIndex(0);
        if (rootModel.getRowCount() > 0) {
            while (rootModel.getRowIndex() < rootModel.getRowCount()) {
                String unselectableClass;
                if (rowVar != null) {
                    context.getExternalContext().getRequestMap().put(rowVar, rootModel.getRowData());
                }
                if (rowIndexVar != null) {
                    context.getExternalContext().getRequestMap().put(rowIndexVar, rootModel.getRowIndex());
                }
                RowState rowState = table.getStateMap().get(rootModel.getRowData());
                boolean selected = rowState.isSelected();
                boolean expanded = rowState.isExpanded();
                boolean unselectable = !rowState.isSelectable();
                boolean visible = rowState.isVisible();
                context.getExternalContext().getRequestMap().put(table.getRowStateVar(), rowState);
                String expandedClass = expanded ? "ui-expanded-row" : "";
                String alternatingClass = rootModel.getRowIndex() % 2 == 0 ? "ui-datatable-even" : "ui-datatable-odd";
                String selectionClass = selected && table.getSelectionMode() != null ? "ui-selected ui-state-active" : "";
                String string = unselectableClass = unselectable ? "ui-unselectable" : "";
                if (visible) {
                    writer.startElement("tr", null);
                    writer.writeAttribute("id", (Object)(clientId + "_row_" + expandedRowId + "." + rootModel.getRowIndex()), null);
                    writer.writeAttribute("class", (Object)(" " + alternatingClass + " " + selectionClass + " " + expandedClass + " " + unselectableClass), null);
                    for (Column kid : columns) {
                        if (!kid.isRendered()) continue;
                        this.encodeRegularCell(context, columns, kid, false);
                    }
                    writer.endElement("tr");
                    if (expanded) {
                        int rowIndex = rootModel.getRowIndex();
                        context.getExternalContext().getRequestMap().put(clientId + "_expandedRowId", expandedRowId + "." + rowIndex);
                        PanelExpansion panelExpansion = table.getPanelExpansion();
                        RowExpansion rowExpansion = table.getRowExpansion();
                        boolean isPanel = panelExpansion != null;
                        boolean isRow = rowExpansion != null;
                        table.setRowIndex(-1);
                        if (isPanel && isRow) {
                            if (rowState.getExpansionType() == RowState.ExpansionType.ROW) {
                                this.encodeRowExpansion(context, table, columns, writer);
                            } else if (rowState.getExpansionType() == RowState.ExpansionType.PANEL) {
                                this.encodeRowPanelExpansion(context, table);
                            }
                        } else if (isPanel) {
                            this.encodeRowPanelExpansion(context, table);
                        } else if (isRow) {
                            this.encodeRowExpansion(context, table, columns, writer);
                        }
                        rootModel = (TreeDataModel)table.getDataModel();
                        rootModel.setRootIndex(expandedRowId);
                        table.setRowIndex(rowIndex);
                        context.getExternalContext().getRequestMap().put(clientId + "_expandedRowId", expandedRowId);
                    }
                }
                table.setRowIndex(rootModel.getRowIndex() + 1);
                if (rowIndexVar != null) {
                    context.getExternalContext().getRequestMap().remove(rowIndexVar);
                }
                if (rowVar == null) continue;
                context.getExternalContext().getRequestMap().remove(rowVar);
            }
        }
        rootModel.setRootIndex(null);
        table.setRowIndex(-1);
    }

    protected void encodeRowPanelExpansion(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId(context);
        DataModel model = table.getDataModel();
        String expandedRowId = (String)params.get(clientId + "_expandedRowId");
        if (expandedRowId == null) {
            expandedRowId = (String)context.getExternalContext().getRequestMap().get(clientId + "_expandedRowId");
        }
        int sepIndex = expandedRowId.lastIndexOf(46);
        String rootIndex = null;
        if (sepIndex >= 0) {
            rootIndex = expandedRowId.substring(0, sepIndex);
            expandedRowId = expandedRowId.substring(sepIndex + 1);
        }
        if (rootIndex != null) {
            ((TreeDataModel)model).setRootIndex(rootIndex);
        }
        table.setRowIndex(Integer.parseInt(expandedRowId));
        table.getStateMap().get(table.getRowData()).setExpanded(true);
        writer.startElement("tr", null);
        writer.writeAttribute("class", (Object)"ui-expanded-row-content ui-widget-content ui-unselectable", null);
        writer.startElement("td", null);
        int enabledColumns = 0;
        for (Column c : table.getColumns()) {
            if (!c.isRendered() || c.isStacked()) continue;
            ++enabledColumns;
        }
        writer.writeAttribute("colspan", (Object)enabledColumns, null);
        table.getPanelExpansion().encodeAll(context);
        writer.endElement("td");
        writer.endElement("tr");
        table.setRowIndex(-1);
    }

    protected void encodeLiveRows(FacesContext context, DataTable table) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        int scrollOffset = Integer.parseInt((String)params.get(table.getClientId(context) + "_scrollOffset"));
        String clientId = table.getClientId(context);
        String rowIndexVar = table.getRowIndexVar();
        for (int i = scrollOffset; i < scrollOffset + table.getRows(); ++i) {
            this.encodeRow(context, table, table.getColumns(), clientId, i, null, rowIndexVar, i == 0);
        }
    }

    private boolean isCurrColumnStacked(List comps, Column currCol) {
        int index = comps.indexOf((Object)currCol);
        if (index == 0) {
            return false;
        }
        return currCol.isStacked();
    }

    private Cell buildCell(DataTable dataTable, String value) {
        String[] cellInfo = value.split("#");
        int rowIndex = Integer.parseInt(cellInfo[0]);
        UIColumn column = dataTable.getColumns().get(Integer.parseInt(cellInfo[1]));
        dataTable.setRowIndex(rowIndex);
        Object rowData = dataTable.getRowData();
        Object cellValue = null;
        UIComponent columnChild = (UIComponent)column.getChildren().get(0);
        if (columnChild instanceof ValueHolder) {
            cellValue = ((ValueHolder)columnChild).getValue();
        }
        return new Cell(rowData, column.getId(), cellValue);
    }
}

