/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.dataexporter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.application.Resource;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.columngroup.ColumnGroup;
import org.icefaces.ace.component.dataexporter.Exporter;
import org.icefaces.ace.component.dataexporter.ExporterResource;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.row.Row;
import org.icefaces.ace.util.XMLChar;
import org.icefaces.application.ResourceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLExporter
extends Exporter {
    @Override
    public String export(FacesContext facesContext, DataTable table, String filename, boolean pageOnly, int[] excludeColumns, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, boolean includeHeaders, boolean includeFooters, boolean selectedRowsOnly) throws IOException {
        String rowIndexVar;
        StringBuilder builder = new StringBuilder();
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        ColumnGroup columnGroup = this.getColumnGroupHeader(table);
        List<String> headers = columnGroup != null ? this.getHeadersFromColumnGroup(columnGroup, columns, table, excludeColumns) : this.getFacetTexts(columns, Exporter.ColumnType.HEADER);
        List<String> footers = this.getFacetTexts(columns, Exporter.ColumnType.FOOTER);
        String var = table.getVar().toLowerCase();
        builder.append("<?xml version=\"1.0\"?>\n");
        builder.append("<" + table.getId() + ">\n");
        int rowCount = table.getRowCount();
        int first = pageOnly ? table.getFirst() : 0;
        int size = pageOnly ? first + table.getRows() : rowCount;
        size = size > rowCount ? rowCount : size;
        Object originalData = null;
        if (selectedRowsOnly) {
            originalData = table.getModel().getWrappedData();
            table.getModel().setWrappedData((Object)table.getStateMap().getSelected());
            first = 0;
            size = table.getRowCount();
        }
        rowIndexVar = (rowIndexVar = table.getRowIndexVar()) == null ? "" : rowIndexVar;
        for (int i = first; i < size; ++i) {
            table.setRowIndex(i);
            if (!"".equals(rowIndexVar)) {
                facesContext.getExternalContext().getRequestMap().put(rowIndexVar, i);
            }
            builder.append("\t<" + var + ">\n");
            this.addColumnValues(builder, columns, headers);
            builder.append("\t</" + var + ">\n");
        }
        if (selectedRowsOnly) {
            table.getModel().setWrappedData(originalData);
        }
        if (this.hasColumnFooter(columns) && includeFooters) {
            builder.append("\t<footers>\n");
            this.addFooterValues(builder, footers, headers);
            builder.append("\t</footers>\n");
        }
        builder.append("</" + table.getId() + ">");
        table.setRowIndex(-1);
        byte[] bytes = builder.toString().getBytes();
        ExporterResource resource = new ExporterResource(bytes);
        resource.setContentType("text/xml");
        Map<String, String> httpHeaders = resource.getResponseHeaders();
        httpHeaders.put("Expires", "0");
        httpHeaders.put("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        httpHeaders.put("Pragma", "public");
        httpHeaders.put("Content-disposition", "attachment;filename=" + filename + ".xml");
        String path = ResourceRegistry.addSessionResource((Resource)resource);
        return path;
    }

    private void addColumnValues(StringBuilder builder, List<UIColumn> columns, List<String> headers) throws IOException {
        for (int i = 0; i < columns.size(); ++i) {
            this.addColumnValue(builder, columns.get(i).getChildren(), headers.get(i));
        }
    }

    private void addFooterValues(StringBuilder builder, List<String> footers, List<String> headers) throws IOException {
        for (int i = 0; i < footers.size(); ++i) {
            String footer = footers.get(i);
            if (footer.length() <= 0) continue;
            this.addColumnValue(builder, footer, headers.get(i));
        }
    }

    private List<String> getFacetTexts(List<UIColumn> columns, Exporter.ColumnType columnType) {
        ArrayList<String> facets = new ArrayList<String>();
        for (UIColumn uiColumn : columns) {
            String value;
            UIComponent facet = uiColumn.getFacet(columnType.facet());
            if (facet != null) {
                value = this.exportValue(FacesContext.getCurrentInstance(), facet);
                facets.add(this.sanitizeXMLTagName(value));
                continue;
            }
            value = "";
            if (uiColumn instanceof Column) {
                Column column = (Column)uiColumn;
                if (columnType == Exporter.ColumnType.HEADER) {
                    String headerText = column.getHeaderText();
                    value = headerText != null ? headerText : "";
                } else if (columnType == Exporter.ColumnType.FOOTER) {
                    String footerText = column.getFooterText();
                    value = footerText != null ? footerText : "";
                }
            }
            facets.add(this.sanitizeXMLTagName(value));
        }
        return facets;
    }

    private String extractValueToDisplay(UIColumn column, Exporter.ColumnType columnType) {
        UIComponent facet = column.getFacet(columnType.facet());
        if (facet != null && facet.isRendered()) {
            String value = this.exportValue(FacesContext.getCurrentInstance(), facet);
            return value;
        }
        String value = "";
        if (column instanceof Column) {
            Column _column = (Column)column;
            if (columnType == Exporter.ColumnType.HEADER) {
                String headerText = _column.getHeaderText();
                value = headerText != null ? headerText : "";
            } else if (columnType == Exporter.ColumnType.FOOTER) {
                String footerText = _column.getFooterText();
                value = footerText != null ? footerText : "";
            }
        }
        return value;
    }

    private List<String> getHeadersFromColumnGroup(ColumnGroup columnGroup, List<UIColumn> columns, UIData data, int[] excludeColumns) {
        ArrayList rows = (ArrayList)this.getRows(columnGroup);
        int size = rows.size();
        if (size > 0) {
            List<UIColumn> rowColumns = this.getRowColumnsToExport((Row)((Object)rows.get(size - 1)), data, excludeColumns);
            ArrayList<String> values = new ArrayList<String>();
            for (UIColumn column : rowColumns) {
                String value = this.extractValueToDisplay(column, Exporter.ColumnType.HEADER);
                values.add(this.sanitizeXMLTagName(value));
            }
            return values;
        }
        return this.getFacetTexts(columns, Exporter.ColumnType.HEADER);
    }

    private void addColumnValue(StringBuilder builder, List<UIComponent> components, String header) throws IOException {
        StringBuilder builder1 = new StringBuilder();
        String tag = header.toLowerCase();
        builder.append("\t\t<" + tag + ">");
        for (UIComponent component : components) {
            if (!component.isRendered()) continue;
            String value = this.exportValue(FacesContext.getCurrentInstance(), component);
            builder1.append(value);
        }
        builder.append(builder1.toString());
        builder.append("</" + tag + ">\n");
    }

    private void addColumnValue(StringBuilder builder, String footer, String header) throws IOException {
        String tag = header.toLowerCase();
        builder.append("\t\t<" + tag + ">");
        builder.append(footer.toLowerCase());
        builder.append("</" + tag + ">\n");
    }

    private String sanitizeXMLTagName(String tag) {
        StringBuilder sb = new StringBuilder();
        int length = tag.length();
        for (int i = 0; i < length; ++i) {
            if (!XMLChar.isName(tag.codePointAt(i))) continue;
            sb.appendCodePoint(tag.codePointAt(i));
        }
        String sanitized = sb.toString();
        if ("".equals(sanitized)) {
            return "_";
        }
        if (!XMLChar.isNameStart(sanitized.codePointAt(0))) {
            return "_" + sanitized;
        }
        return sanitized;
    }
}

