/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.animation;

import java.util.HashMap;
import java.util.Map;
import org.icefaces.ace.component.animation.AnimationBehavior;
import org.icefaces.ace.util.JSONBuilder;

public abstract class Effect {
    private AnimationBehavior effectBehavior;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private String sourceElement;

    String getSourceElement() {
        return this.sourceElement;
    }

    void setSourceElement(String sourceElement) {
        this.sourceElement = sourceElement;
        this.properties.put("node", sourceElement);
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public String getPropertiesAsJSON() {
        return this.convertMapToJSON(this.properties);
    }

    private String convertMapToJSON(Map map) {
        JSONBuilder json = JSONBuilder.create();
        json.beginMap();
        for (String prop : map.keySet()) {
            Object value = map.get(prop);
            if (value == null) continue;
            if (value instanceof Map) {
                json.entry(prop, this.convertMapToJSON((Map)value), true);
                continue;
            }
            String val = value.toString();
            try {
                Integer inVaue = Integer.parseInt(val);
                json.entry(prop, inVaue);
            }
            catch (Exception exception) {
                try {
                    Float floatValue = Float.valueOf(Float.parseFloat(val));
                    json.entry(prop, floatValue.floatValue());
                }
                catch (Exception ex) {
                    if ("true".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val)) {
                        Boolean bolValue = Boolean.parseBoolean(val);
                        json.entry(prop, bolValue);
                        continue;
                    }
                    if (val.startsWith("{")) {
                        json.entry(prop, value.toString(), true);
                        continue;
                    }
                    json.entry(prop, value.toString());
                }
            }
        }
        return json.endMap().toString();
    }

    AnimationBehavior getEffectBehavior() {
        return this.effectBehavior;
    }

    void setEffectBehavior(AnimationBehavior effectBehavior) {
        this.effectBehavior = effectBehavior;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void run() {
        if (null != this.getEffectBehavior()) {
            this.effectBehavior.setRun(true);
        }
    }
}

