/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.hyperledger.fabric.contract.ContractRuntimeException;
import org.hyperledger.fabric.protos.peer.ChaincodeMessage;
import org.hyperledger.fabric.shim.Chaincode;
import org.hyperledger.fabric.shim.impl.ChaincodeMessageFactory;
import org.hyperledger.fabric.shim.impl.InvocationStubImpl;
import org.hyperledger.fabric.traces.Traces;

public class ChaincodeInvocationTask
implements Callable<ChaincodeMessage> {
    private static final Logger LOGGER = Logger.getLogger(ChaincodeInvocationTask.class.getName());
    private static final Logger PERFLOGGER = Logger.getLogger("org.hyperledger.Performance");
    private final String key;
    private final ChaincodeMessage.Type type;
    private final String txId;
    private final Consumer<ChaincodeMessage> outgoingMessageConsumer;
    private final BlockingQueue<ChaincodeMessage> postbox = new ArrayBlockingQueue<ChaincodeMessage>(2, true);
    private final ChaincodeMessage message;
    private final Chaincode chaincode;

    public ChaincodeInvocationTask(ChaincodeMessage message, ChaincodeMessage.Type type, Consumer<ChaincodeMessage> outgoingMessage, Chaincode chaincode) {
        this.key = message.getChannelId() + message.getTxid();
        this.type = type;
        this.outgoingMessageConsumer = outgoingMessage;
        this.txId = message.getTxid();
        this.chaincode = chaincode;
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChaincodeMessage call() {
        Span span = null;
        try {
            ChaincodeMessage finalResponseMessage;
            block9: {
                try {
                    PERFLOGGER.fine(() -> "> task:start TX::" + this.txId);
                    InvocationStubImpl stub = new InvocationStubImpl(this.message, this);
                    span = Traces.getProvider().createSpan(stub);
                    PERFLOGGER.fine(() -> "> task:invoke TX::" + this.txId);
                    Chaincode.Response result = this.type.equals((Object)ChaincodeMessage.Type.INIT) ? this.chaincode.init(stub) : this.chaincode.invoke(stub);
                    PERFLOGGER.fine(() -> "< task:invoke TX::" + this.txId);
                    if (result.getStatus().getCode() >= Chaincode.Response.Status.INTERNAL_SERVER_ERROR.getCode()) {
                        LOGGER.severe(() -> String.format("[%-8.8s] Invoke failed with error code %d. Sending %s", this.message.getTxid(), result.getStatus().getCode(), ChaincodeMessage.Type.ERROR));
                        finalResponseMessage = ChaincodeMessageFactory.newCompletedEventMessage(this.message.getChannelId(), this.message.getTxid(), result, stub.getEvent());
                        if (span != null) {
                            span.setStatus(StatusCode.ERROR, result.getMessage());
                        }
                    } else {
                        LOGGER.fine(() -> String.format("[%-8.8s] Invoke succeeded. Sending %s", this.message.getTxid(), ChaincodeMessage.Type.COMPLETED));
                        finalResponseMessage = ChaincodeMessageFactory.newCompletedEventMessage(this.message.getChannelId(), this.message.getTxid(), result, stub.getEvent());
                    }
                }
                catch (InvalidProtocolBufferException | RuntimeException | NoSuchAlgorithmException e) {
                    LOGGER.severe(() -> this.lambda$call$5((Exception)e));
                    finalResponseMessage = ChaincodeMessageFactory.newErrorEventMessage(this.message.getChannelId(), this.message.getTxid(), e);
                    if (span == null) break block9;
                    span.setStatus(StatusCode.ERROR, e.getMessage());
                }
            }
            this.outgoingMessageConsumer.accept(finalResponseMessage);
            PERFLOGGER.fine(() -> "< task:end TX::" + this.txId);
        }
        finally {
            if (span != null) {
                span.end();
            }
        }
        return null;
    }

    public String getTxKey() {
        return this.key;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ChaincodeInvocationTask)) {
            return false;
        }
        ChaincodeInvocationTask that = (ChaincodeInvocationTask)other;
        return this.key.equals(that.getTxKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public void postMessage(ChaincodeMessage msg) throws InterruptedException {
        this.postbox.put(msg);
    }

    protected ByteString invoke(ChaincodeMessage message) {
        ChaincodeMessage response;
        LOGGER.fine(() -> "Task Sending message to the peer " + message.getTxid());
        this.outgoingMessageConsumer.accept(message);
        try {
            PERFLOGGER.fine(() -> "> task:answer TX::" + message.getTxid());
            response = this.postbox.take();
            PERFLOGGER.fine(() -> "< task:answer TX::" + message.getTxid());
        }
        catch (InterruptedException e) {
            LOGGER.severe(() -> "Interrupted exchanging messages ");
            throw new ContractRuntimeException(String.format("[%-8.8s]InterruptedException received.", this.txId), e);
        }
        switch (response.getType()) {
            case RESPONSE: {
                LOGGER.fine(() -> String.format("[%-8.8s] Successful response received.", this.txId));
                return response.getPayload();
            }
            case ERROR: {
                LOGGER.severe(() -> String.format("[%-8.8s] Unsuccessful response received.", this.txId));
                throw new ContractRuntimeException(String.format("[%-8.8s]Unsuccessful response received.", this.txId));
            }
        }
        LOGGER.severe(() -> String.format("[%-8.8s] Unexpected %s response received. Expected %s or %s.", this.txId, response.getType(), ChaincodeMessage.Type.RESPONSE, ChaincodeMessage.Type.ERROR));
        throw new IllegalStateException(String.format("[%-8.8s] Unexpected %s response received. Expected %s or %s.", this.txId, response.getType(), ChaincodeMessage.Type.RESPONSE, ChaincodeMessage.Type.ERROR));
    }

    private /* synthetic */ String lambda$call$5(Exception e) {
        return String.format("[%-8.8s] Invoke failed. Sending %s: %s", this.message.getTxid(), ChaincodeMessage.Type.ERROR, e);
    }
}

