/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.ext.sbe.impl;

import java.util.Arrays;
import java.util.List;
import org.hyperledger.fabric.protos.common.MSPPrincipal;
import org.hyperledger.fabric.protos.common.MSPRole;
import org.hyperledger.fabric.protos.common.SignaturePolicy;
import org.hyperledger.fabric.protos.common.SignaturePolicyEnvelope;

public final class StateBasedEndorsementUtils {
    private StateBasedEndorsementUtils() {
    }

    static SignaturePolicy signedBy(int index) {
        return SignaturePolicy.newBuilder().setSignedBy(index).build();
    }

    static SignaturePolicy nOutOf(int n, List<SignaturePolicy> policies) {
        return SignaturePolicy.newBuilder().setNOutOf(SignaturePolicy.NOutOf.newBuilder().setN(n).addAllRules(policies).build()).build();
    }

    static SignaturePolicyEnvelope signedByFabricEntity(String mspId, MSPRole.MSPRoleType role) {
        MSPPrincipal principal = MSPPrincipal.newBuilder().setPrincipalClassification(MSPPrincipal.Classification.ROLE).setPrincipal(MSPRole.newBuilder().setMspIdentifier(mspId).setRole(role).build().toByteString()).build();
        return SignaturePolicyEnvelope.newBuilder().setVersion(0).setRule(StateBasedEndorsementUtils.nOutOf(1, Arrays.asList(StateBasedEndorsementUtils.signedBy(0)))).addIdentities(principal).build();
    }
}

