/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.routing.impl;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.hyperledger.fabric.Logger;
import org.hyperledger.fabric.contract.annotation.Serializer;
import org.hyperledger.fabric.contract.execution.SerializerInterface;

public class SerializerRegistryImpl {
    private static final Logger LOGGER = Logger.getLogger(SerializerRegistryImpl.class);
    private final Class<Serializer> annotationClass = Serializer.class;
    private final Map<String, SerializerInterface> contents = new HashMap<String, SerializerInterface>();

    public SerializerInterface getSerializer(String name, Serializer.TARGET target) {
        String key = name + ":" + String.valueOf((Object)target);
        return this.contents.get(key);
    }

    private SerializerInterface add(String name, Serializer.TARGET target, Class<SerializerInterface> clazz) throws InstantiationException, IllegalAccessException {
        LOGGER.debug(() -> "Adding new Class " + clazz.getCanonicalName() + " for " + String.valueOf((Object)target));
        String key = name + ":" + String.valueOf((Object)target);
        SerializerInterface newObj = clazz.newInstance();
        this.contents.put(key, newObj);
        return newObj;
    }

    public void findAndSetContents() throws InstantiationException, IllegalAccessException {
        ClassGraph classGraph = new ClassGraph().enableClassInfo().enableAnnotationInfo();
        HashSet<String> seenClass = new HashSet<String>();
        try (ScanResult scanResult = classGraph.scan();){
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(this.annotationClass.getCanonicalName())) {
                LOGGER.debug(() -> "Found class with contract annotation: " + classInfo.getName());
                Class cls = classInfo.loadClass();
                LOGGER.debug("Loaded class");
                String className = cls.getCanonicalName();
                if (seenClass.contains(className)) continue;
                seenClass.add(className);
                this.add(className, Serializer.TARGET.TRANSACTION, cls);
            }
        }
    }
}

